/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

public abstract class AbstractDelegatingTransport
implements Transport {
    protected final Transport actual;

    protected AbstractDelegatingTransport(Transport actual) {
        this.actual = actual;
    }

    @Override
    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        this.beforeInvokeRemotely(rpcCommand);
        Map<Address, Response> result = this.actual.invokeRemotely(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast);
        return this.afterInvokeRemotely(rpcCommand, result);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) throws Exception {
        return this.actual.invokeRemotely(rpcCommands, mode, timeout, usePriorityQueue, responseFilter, totalOrder, anycast);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        return this.actual.invokeRemotely(rpcCommands, mode, timeout, responseFilter, deliverOrder, anycast);
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        return this.actual.invokeRemotelyAsync(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast);
    }

    @Override
    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand rpcCommand) throws Exception {
        this.beforeBackupRemotely(rpcCommand);
        BackupResponse response = this.actual.backupRemotely(backups, rpcCommand);
        return this.afterBackupRemotely(rpcCommand, response);
    }

    @Override
    public boolean isCoordinator() {
        return this.actual.isCoordinator();
    }

    @Override
    public Address getCoordinator() {
        return this.actual.getCoordinator();
    }

    @Override
    public Address getAddress() {
        return this.actual.getAddress();
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        return this.actual.getPhysicalAddresses();
    }

    @Override
    public List<Address> getMembers() {
        return this.actual.getMembers();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.actual.isMulticastCapable();
    }

    @Override
    public void start() {
        this.actual.start();
    }

    @Override
    public void stop() {
        this.actual.stop();
    }

    @Override
    public int getViewId() {
        return this.actual.getViewId();
    }

    @Override
    public void waitForView(int viewId) throws InterruptedException {
        this.actual.waitForView(viewId);
    }

    @Override
    public void checkTotalOrderSupported() {
        this.actual.checkTotalOrderSupported();
    }

    @Override
    public Log getLog() {
        return this.actual.getLog();
    }

    public Transport getDelegate() {
        return this.actual;
    }

    protected void beforeInvokeRemotely(ReplicableCommand command) {
    }

    protected Map<Address, Response> afterInvokeRemotely(ReplicableCommand command, Map<Address, Response> responseMap) {
        return responseMap;
    }

    protected void beforeBackupRemotely(XSiteReplicateCommand command) {
    }

    protected BackupResponse afterBackupRemotely(ReplicableCommand command, BackupResponse response) {
        return response;
    }
}

