/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.iq80.leveldb.impl;

import infinispan.com.google.common.base.Function;
import infinispan.org.iq80.leveldb.impl.InternalKey;
import java.util.concurrent.atomic.AtomicInteger;

public class FileMetaData {
    public static Function<FileMetaData, InternalKey> GET_LARGEST_USER_KEY = new Function<FileMetaData, InternalKey>(){

        @Override
        public InternalKey apply(FileMetaData fileMetaData) {
            return fileMetaData.getLargest();
        }
    };
    private final long number;
    private final long fileSize;
    private final InternalKey smallest;
    private final InternalKey largest;
    private final AtomicInteger allowedSeeks = new AtomicInteger(0x40000000);

    public FileMetaData(long number, long fileSize, InternalKey smallest, InternalKey largest) {
        this.number = number;
        this.fileSize = fileSize;
        this.smallest = smallest;
        this.largest = largest;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getNumber() {
        return this.number;
    }

    public InternalKey getSmallest() {
        return this.smallest;
    }

    public InternalKey getLargest() {
        return this.largest;
    }

    public int getAllowedSeeks() {
        return this.allowedSeeks.get();
    }

    public void setAllowedSeeks(int allowedSeeks) {
        this.allowedSeeks.set(allowedSeeks);
    }

    public void decrementAllowedSeeks() {
        this.allowedSeeks.getAndDecrement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileMetaData");
        sb.append("{number=").append(this.number);
        sb.append(", fileSize=").append(this.fileSize);
        sb.append(", smallest=").append(this.smallest);
        sb.append(", largest=").append(this.largest);
        sb.append(", allowedSeeks=").append(this.allowedSeeks);
        sb.append('}');
        return sb.toString();
    }
}

