/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;

public final class CommandInvocationId {
    private static final AtomicLong nextId = new AtomicLong(0L);
    private final Address address;
    private final long id;

    private CommandInvocationId(Address address, long id) {
        this.address = address;
        this.id = id;
    }

    public static CommandInvocationId generateId(Address address) {
        return new CommandInvocationId(address, nextId.getAndIncrement());
    }

    public static CommandInvocationId generateIdFrom(CommandInvocationId commandInvocationId) {
        return new CommandInvocationId(commandInvocationId.address, nextId.getAndIncrement());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandInvocationId that = (CommandInvocationId)o;
        return this.id == that.id && !(this.address == null ? that.address != null : !this.address.equals(that.address));
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return "CommandInvocation:" + Objects.toString(this.address, "local") + ":" + this.id;
    }

    public static void writeTo(ObjectOutput output, CommandInvocationId commandInvocationId) throws IOException {
        output.writeObject(commandInvocationId.address);
        output.writeLong(commandInvocationId.id);
    }

    public static CommandInvocationId readFrom(ObjectInput input) throws ClassNotFoundException, IOException {
        Address address = (Address)input.readObject();
        long id = input.readLong();
        return new CommandInvocationId(address, id);
    }

    public static class Externalizer
    extends AbstractExternalizer<CommandInvocationId> {
        @Override
        public Set<Class<? extends CommandInvocationId>> getTypeClasses() {
            return Collections.singleton(CommandInvocationId.class);
        }

        @Override
        public void writeObject(ObjectOutput output, CommandInvocationId object) throws IOException {
            CommandInvocationId.writeTo(output, object);
        }

        @Override
        public CommandInvocationId readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return CommandInvocationId.readFrom(input);
        }

        @Override
        public Integer getId() {
            return 149;
        }
    }
}

