/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.RemoteFetchingCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;

public final class GetCacheEntryCommand
extends AbstractDataCommand
implements RemoteFetchingCommand {
    public static final byte COMMAND_ID = 45;
    private InternalEntryFactory entryFactory;
    private InternalCacheEntry remotelyFetchedValue;

    public GetCacheEntryCommand(Object key, long flagsBitSet, InternalEntryFactory entryFactory) {
        super(key, flagsBitSet);
        this.entryFactory = entryFactory;
    }

    public GetCacheEntryCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetCacheEntryCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null || entry.isNull()) {
            return null;
        }
        if (entry.isRemoved()) {
            return null;
        }
        return this.entryFactory.copy(entry);
    }

    @Override
    public byte getCommandId() {
        return 45;
    }

    @Override
    public void setRemotelyFetchedValue(InternalCacheEntry remotelyFetchedValue) {
        this.remotelyFetchedValue = remotelyFetchedValue;
    }

    @Override
    public InternalCacheEntry getRemotelyFetchedValue() {
        return this.remotelyFetchedValue;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public String toString() {
        return "GetCacheEntryCommand {key=" + Util.toStr(this.key) + ", flags=" + this.printFlags() + "}";
    }
}

