/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RepeatableReadEntry
extends ReadCommittedEntry {
    private static final Log log = LogFactory.getLog(RepeatableReadEntry.class);
    private static final boolean trace = log.isTraceEnabled();

    public RepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
    }

    @Override
    public void copyForUpdate() {
        if (this.isFlagSet(ReadCommittedEntry.Flags.COPIED)) {
            return;
        }
        this.setFlag(ReadCommittedEntry.Flags.COPIED);
        this.oldValue = this.value;
    }

    public void performLocalWriteSkewCheck(DataContainer container, boolean alreadyCopied) {
        Object valueToCompare;
        InternalCacheEntry ice = container.get(this.key);
        Object actualValue = ice == null ? null : ice.getValue();
        Object object = valueToCompare = alreadyCopied ? this.oldValue : this.value;
        if (trace) {
            log.tracef("Performing local write skew check. actualValue=%s, transactionValue=%s", (Object)actualValue, valueToCompare);
        }
        if (actualValue != null && actualValue != valueToCompare) {
            log.unableToCopyEntryForUpdate(this.getKey());
            throw new WriteSkewException("Detected write skew.", this.key);
        }
        if (valueToCompare != null && ice == null && !this.isCreated()) {
            log.unableToCopyEntryForUpdate(this.getKey());
            throw new WriteSkewException("Detected write skew - concurrent removal of entry!", this.key);
        }
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
        this.setFlag(skipLookup, ReadCommittedEntry.Flags.SKIP_LOOKUP);
    }

    @Override
    public boolean skipLookup() {
        return this.isFlagSet(ReadCommittedEntry.Flags.SKIP_LOOKUP);
    }

    @Override
    public RepeatableReadEntry clone() {
        return (RepeatableReadEntry)super.clone();
    }
}

