/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClusteredRepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.impl.VersionedEntryWrappingInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderVersionedEntryWrappingInterceptor
extends VersionedEntryWrappingInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderVersionedEntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final EntryVersionsMap EMPTY_VERSION_MAP = new EntryVersionsMap();

    @Override
    public final CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            ((VersionedPrepareCommand)command).setVersionsSeen(((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead());
            ((AbstractCacheTransaction)ctx.getCacheTransaction()).setUpdatedEntryVersions(EMPTY_VERSION_MAP);
            return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
                if (throwable == null && this.shouldCommitDuringPrepare((PrepareCommand)rCommand, ctx)) {
                    this.commitContextEntries(ctx, null, null);
                }
                return null;
            });
        }
        this.wrapEntriesForPrepare(ctx, command);
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            TxInvocationContext txInvocationContext = (TxInvocationContext)rCtx;
            VersionedPrepareCommand prepareCommand = (VersionedPrepareCommand)rCommand;
            EntryVersionsMap versionsMap = this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, txInvocationContext, prepareCommand);
            if (prepareCommand.isOnePhaseCommit()) {
                this.commitContextEntries(txInvocationContext, null, null);
            } else if (trace) {
                log.tracef("Transaction %s will be committed in the 2nd phase", (Object)txInvocationContext.getGlobalTransaction().globalId());
            }
            return CompletableFuture.completedFuture(versionsMap == null ? rv : new ArrayList(versionsMap.keySet()));
        });
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            this.commitContextEntries(rCtx, null, null);
            return null;
        });
    }

    @Override
    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Metadata metadata, Flag stateTransferFlag, boolean l1Invalidation) {
        if (ctx.isInTxScope() && stateTransferFlag == null) {
            ClusteredRepeatableReadEntry clusterMvccEntry = (ClusteredRepeatableReadEntry)entry;
            EntryVersion existingVersion = clusterMvccEntry.getMetadata().version();
            IncrementableEntryVersion newVersion = existingVersion == null ? this.versionGenerator.generateNew() : this.versionGenerator.increment((IncrementableEntryVersion)existingVersion);
            Metadata commitMetadata = metadata == null ? new EmbeddedMetadata.Builder().version(newVersion).build() : metadata.builder().version(newVersion).build();
            this.cdl.commitEntry(entry, commitMetadata, command, ctx, null, l1Invalidation);
        } else {
            this.cdl.commitEntry(entry, entry.getMetadata(), command, ctx, stateTransferFlag, l1Invalidation);
        }
    }
}

