/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.function.CloseableSupplier;

public class PersistenceManagerCloseableSupplier<K, V>
implements CloseableSupplier<CacheEntry<K, V>> {
    private final Executor executor;
    private final PersistenceManager manager;
    private final KeyFilter<K> filter;
    private final InternalEntryFactory factory;
    private final BlockingQueue<CacheEntry<K, V>> queue;
    private final long timeout;
    private final TimeUnit unit;
    private final Lock closeLock = new ReentrantLock();
    private final Condition closeCondition = this.closeLock.newCondition();
    private boolean closed = false;
    private AtomicReference<AdvancedCacheLoader.CacheLoaderTask<K, V>> taskRef = new AtomicReference();

    public PersistenceManagerCloseableSupplier(Executor executor, PersistenceManager manager, InternalEntryFactory factory, KeyFilter<K> filter, long timeout, TimeUnit unit, int maxQueue) {
        this.executor = executor;
        this.manager = manager;
        this.factory = factory;
        this.filter = filter;
        this.timeout = timeout;
        this.unit = unit;
        this.queue = new ArrayBlockingQueue<CacheEntry<K, V>>(maxQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry<K, V> get() throws TimeoutException {
        CacheEntry entry;
        if (this.taskRef.get() == null && this.taskRef.getAndUpdate(t -> t == null ? new SupplierCacheLoaderTask() : t) == null) {
            AdvancedCacheLoader.CacheLoaderTask<K, V> task = this.taskRef.get();
            this.executor.execute(() -> {
                try {
                    this.manager.processOnAllStores(new WithinThreadExecutor(), this.filter, task, true, true);
                }
                finally {
                    this.close();
                }
            });
        }
        boolean interrupted = false;
        while ((entry = (CacheEntry)this.queue.poll()) == null) {
            this.closeLock.lock();
            try {
                if (this.closed) break;
                long targetTime = System.nanoTime() + this.unit.toNanos(this.timeout);
                try {
                    if (this.closeCondition.await(targetTime - System.nanoTime(), TimeUnit.NANOSECONDS)) continue;
                    throw new TimeoutException("Couldn't retrieve entry an entry from store in allotted timeout: " + this.timeout + " unit: " + (Object)((Object)this.unit));
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            finally {
                this.closeLock.unlock();
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return entry;
    }

    @Override
    public void close() {
        this.closeLock.lock();
        try {
            this.closed = true;
            this.closeCondition.signalAll();
        }
        finally {
            this.closeLock.unlock();
        }
    }

    class SupplierCacheLoaderTask
    implements AdvancedCacheLoader.CacheLoaderTask<K, V> {
        SupplierCacheLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processEntry(MarshalledEntry<K, V> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            if (!taskContext.isStopped()) {
                PersistenceManagerCloseableSupplier.this.closeLock.lock();
                try {
                    if (PersistenceManagerCloseableSupplier.this.closed) {
                        taskContext.stop();
                        return;
                    }
                }
                finally {
                    PersistenceManagerCloseableSupplier.this.closeLock.unlock();
                }
                InternalCacheEntry ice = PersistenceUtil.convert(marshalledEntry, PersistenceManagerCloseableSupplier.this.factory);
                boolean stop = PersistenceManagerCloseableSupplier.this.closed;
                while (!stop) {
                    if (PersistenceManagerCloseableSupplier.this.queue.offer(ice, 100L, TimeUnit.MILLISECONDS)) {
                        PersistenceManagerCloseableSupplier.this.closeLock.lock();
                        try {
                            PersistenceManagerCloseableSupplier.this.closeCondition.signalAll();
                            break;
                        }
                        finally {
                            PersistenceManagerCloseableSupplier.this.closeLock.unlock();
                        }
                    }
                    PersistenceManagerCloseableSupplier.this.closeLock.lock();
                    try {
                        stop = PersistenceManagerCloseableSupplier.this.closed;
                    }
                    finally {
                        PersistenceManagerCloseableSupplier.this.closeLock.unlock();
                    }
                }
            }
        }
    }
}

