/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DldGlobalTransaction
extends GlobalTransaction {
    private static final Log log = LogFactory.getLog(DldGlobalTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    protected volatile long coinToss;
    protected volatile transient Collection<Object> lockIntention = Collections.emptySet();
    protected volatile Collection<Object> remoteLockIntention = Collections.emptySet();
    protected volatile Set<Object> locksAtOrigin = Collections.emptySet();

    public DldGlobalTransaction() {
    }

    public DldGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    public void setCoinToss(long coinToss) {
        this.coinToss = coinToss;
    }

    public long getCoinToss() {
        return this.coinToss;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DldGlobalTransaction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DldGlobalTransaction that = (DldGlobalTransaction)o;
        return this.coinToss == that.coinToss;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.coinToss ^ this.coinToss >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ":dld:" + this.coinToss;
    }

    public Collection<Object> getLockIntention() {
        return this.lockIntention;
    }

    public void setLockIntention(Collection<Object> lockIntention) {
        Objects.requireNonNull(lockIntention, "Local lock Intention must be non-null.");
        if (trace) {
            log.tracef("Setting local lock intention to %s", (Object)lockIntention);
        }
        this.lockIntention = lockIntention;
    }

    public boolean wouldLose(DldGlobalTransaction other) {
        return this.coinToss < other.coinToss;
    }

    public void setRemoteLockIntention(Collection<Object> remoteLockIntention) {
        Objects.requireNonNull(this.lockIntention, "Remote lock intention must be non-null.");
        if (trace) {
            log.tracef("Setting the remote lock intention: %s", (Object)remoteLockIntention);
        }
        this.remoteLockIntention = remoteLockIntention;
    }

    public Collection<Object> getRemoteLockIntention() {
        return this.remoteLockIntention;
    }

    public boolean hasAnyLockAtOrigin(DldGlobalTransaction otherTx) {
        if (trace) {
            log.tracef("Our(%s) locks at origin are: %s. Others remote lock intention is: %s", (Object)this, (Object)this.locksAtOrigin, (Object)otherTx.getRemoteLockIntention());
        }
        for (Object key : otherTx.getRemoteLockIntention()) {
            if (!this.locksAtOrigin.contains(key)) continue;
            return true;
        }
        return false;
    }

    public void setLocksHeldAtOrigin(Set<Object> locksAtOrigin) {
        Objects.requireNonNull(locksAtOrigin, "Locks at origin must be non-null.");
        if (trace) {
            log.tracef("Setting locks at origin for (%s) to %s", (Object)this, (Object)locksAtOrigin);
        }
        this.locksAtOrigin = locksAtOrigin;
    }

    public Set<Object> getLocksHeldAtOrigin() {
        return this.locksAtOrigin;
    }

    public static class Externalizer
    extends GlobalTransaction.AbstractGlobalTxExternalizer<DldGlobalTransaction> {
        @Override
        protected DldGlobalTransaction createGlobalTransaction() {
            return (DldGlobalTransaction)TransactionFactory.TxFactoryEnum.DLD_NORECOVERY_XA.newGlobalTransaction();
        }

        @Override
        public void writeObject(ObjectOutput output, DldGlobalTransaction ddGt) throws IOException {
            super.writeObject(output, ddGt);
            output.writeLong(ddGt.getCoinToss());
            if (ddGt.locksAtOrigin.isEmpty()) {
                output.writeObject(null);
            } else {
                output.writeObject(ddGt.locksAtOrigin);
            }
        }

        @Override
        public DldGlobalTransaction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            DldGlobalTransaction ddGt = (DldGlobalTransaction)super.readObject(input);
            ddGt.setCoinToss(input.readLong());
            Object locksAtOriginObj = input.readObject();
            if (locksAtOriginObj == null) {
                ddGt.setLocksHeldAtOrigin(Collections.emptySet());
            } else {
                ddGt.setLocksHeldAtOrigin((Set)locksAtOriginObj);
            }
            return ddGt;
        }

        @Override
        public Integer getId() {
            return 43;
        }

        @Override
        public Set<Class<? extends DldGlobalTransaction>> getTypeClasses() {
            return Util.asSet(DldGlobalTransaction.class);
        }
    }
}

