/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;

public class Tombstone
implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
InjectableComponent {
    public static final ExcludeTombstonesFilter EXCLUDE_TOMBSTONES = new ExcludeTombstonesFilter();
    private final long[] data;
    private transient InfinispanDataRegion region;

    public Tombstone(UUID uuid, long timestamp) {
        this.data = new long[]{timestamp, uuid.getLeastSignificantBits(), uuid.getMostSignificantBits()};
    }

    private Tombstone(long[] data) {
        this.data = data;
    }

    public long getLastTimestamp() {
        long max = this.data[0];
        for (int i = 3; i < this.data.length; i += 3) {
            max = Math.max(max, this.data[i]);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tombstone{");
        for (int i = 0; i < this.data.length; i += 3) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(new UUID(this.data[i + 2], this.data[i + 1])).append('=').append(this.data[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    public Tombstone merge(Tombstone update) {
        assert (update != null);
        assert (update.data.length == 3);
        int toRemove = 0;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < update.data[0]) {
                toRemove += 3;
                continue;
            }
            if (update.data[1] != this.data[i + 1] || update.data[2] != this.data[i + 2]) continue;
            toRemove += 3;
        }
        if (this.data.length == toRemove) {
            return update;
        }
        long[] newData = new long[this.data.length - toRemove + 3];
        int j = 0;
        boolean uuidMatch = false;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < update.data[0]) continue;
            if (update.data[1] == this.data[i + 1] && update.data[2] == this.data[i + 2]) {
                System.arraycopy(update.data, 0, newData, j, 3);
                uuidMatch = true;
                j += 3;
                continue;
            }
            System.arraycopy(this.data, i, newData, j, 3);
            j += 3;
        }
        assert (uuidMatch && j == newData.length || !uuidMatch && j == newData.length - 3);
        if (!uuidMatch) {
            System.arraycopy(update.data, 0, newData, j, 3);
        }
        return new Tombstone(newData);
    }

    public Object applyUpdate(UUID uuid, long timestamp, Object value) {
        int toRemove = 0;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < timestamp) {
                toRemove += 3;
                continue;
            }
            if (uuid.getLeastSignificantBits() != this.data[i + 1] || uuid.getMostSignificantBits() != this.data[i + 2]) continue;
            toRemove += 3;
        }
        if (this.data.length == toRemove) {
            if (value == null) {
                return new Tombstone(uuid, timestamp);
            }
            return value;
        }
        long[] newData = new long[this.data.length - toRemove + 3];
        int j = 0;
        boolean uuidMatch = false;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < timestamp) continue;
            if (uuid.getLeastSignificantBits() == this.data[i + 1] && uuid.getMostSignificantBits() == this.data[i + 2]) {
                newData[j] = timestamp;
                newData[j + 1] = uuid.getLeastSignificantBits();
                newData[j + 2] = uuid.getMostSignificantBits();
                uuidMatch = true;
                j += 3;
                continue;
            }
            System.arraycopy(this.data, i, newData, j, 3);
            j += 3;
        }
        assert (uuidMatch && j == newData.length || !uuidMatch && j == newData.length - 3);
        if (!uuidMatch) {
            newData[j] = timestamp;
            newData[j + 1] = uuid.getLeastSignificantBits();
            newData[j + 2] = uuid.getMostSignificantBits();
        }
        return new Tombstone(newData);
    }

    public int size() {
        return this.data.length / 3;
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
        Object storedValue = view.find().orElse(null);
        MetaParam.MetaLifespan expiringMetaParam = this.region.getExpiringMetaParam();
        if (storedValue instanceof Tombstone) {
            view.set((Object)((Tombstone)storedValue).merge(this), new MetaParam.Writable[]{expiringMetaParam});
        } else {
            view.set((Object)this, new MetaParam.Writable[]{expiringMetaParam});
        }
        return null;
    }

    public void inject(ComponentRegistry registry) {
        this.region = (InfinispanDataRegion)registry.getComponent(InfinispanDataRegion.class);
    }

    public static class ExcludeTombstonesFilterExternalizer
    implements AdvancedExternalizer<ExcludeTombstonesFilter> {
        public Set<Class<? extends ExcludeTombstonesFilter>> getTypeClasses() {
            return Collections.singleton(ExcludeTombstonesFilter.class);
        }

        public Integer getId() {
            return 1202;
        }

        public void writeObject(ObjectOutput output, ExcludeTombstonesFilter object) throws IOException {
        }

        public ExcludeTombstonesFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return EXCLUDE_TOMBSTONES;
        }
    }

    public static class ExcludeTombstonesFilter
    implements Predicate<Map.Entry<Object, Object>> {
        private ExcludeTombstonesFilter() {
        }

        @Override
        public boolean test(Map.Entry<Object, Object> entry) {
            return !(entry.getValue() instanceof Tombstone);
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<Tombstone> {
        public Set<Class<? extends Tombstone>> getTypeClasses() {
            return Collections.singleton(Tombstone.class);
        }

        public Integer getId() {
            return 1201;
        }

        public void writeObject(ObjectOutput output, Tombstone tombstone) throws IOException {
            output.writeInt(tombstone.data.length);
            for (int i = 0; i < tombstone.data.length; ++i) {
                output.writeLong(tombstone.data[i]);
            }
        }

        public Tombstone readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int length = input.readInt();
            long[] data = new long[length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = input.readLong();
            }
            return new Tombstone(data);
        }
    }
}

