/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v51.impl;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.transaction.TransactionManager;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.LockingInterceptor;
import org.infinispan.hibernate.cache.commons.access.NonStrictAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.NonTxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.TombstoneAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.TxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.UnorderedDistributionInterceptor;
import org.infinispan.hibernate.cache.commons.access.UnorderedReplicationLogic;
import org.infinispan.hibernate.cache.commons.util.CacheCommandInitializer;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.hibernate.cache.v51.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v51.impl.BaseRegion;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;

public abstract class BaseTransactionalDataRegion
extends BaseRegion
implements TransactionalDataRegion,
InfinispanDataRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(BaseTransactionalDataRegion.class);
    private final CacheDataDescription metadata;
    private final CacheKeysFactory cacheKeysFactory;
    private final boolean requiresTransaction;
    private final MetaParam.MetaLifespan expiringMetaParam;
    private final AdvancedCache<Object, Object> localCache;
    private long tombstoneExpiration;
    private PutFromLoadValidator validator;
    private AccessType accessType;
    private Strategy strategy;

    public BaseTransactionalDataRegion(AdvancedCache cache, String name, TransactionManager transactionManager, CacheDataDescription metadata, InfinispanRegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, name, transactionManager, factory);
        this.metadata = metadata;
        this.cacheKeysFactory = cacheKeysFactory;
        this.localCache = cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        Configuration configuration = cache.getCacheConfiguration();
        this.requiresTransaction = configuration.transaction().transactionMode().isTransactional() && !configuration.transaction().autoCommit();
        this.tombstoneExpiration = factory.getPendingPutsCacheConfiguration().expiration().maxIdle();
        if (!this.isRegionAccessStrategyEnabled()) {
            this.strategy = Strategy.NONE;
        }
        this.expiringMetaParam = new MetaParam.MetaLifespan(this.tombstoneExpiration);
    }

    protected boolean isRegionAccessStrategyEnabled() {
        return true;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    protected synchronized AccessDelegate createAccessDelegate(AccessType accessType) {
        if (accessType == null) {
            throw new IllegalArgumentException();
        }
        if (this.accessType != null && !this.accessType.equals((Object)accessType)) {
            throw new IllegalStateException("This region was already set up for " + this.accessType + ", cannot use using " + accessType);
        }
        this.accessType = accessType;
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            this.prepareForVersionedEntries(cacheMode);
            return new NonStrictAccessDelegate((InfinispanDataRegion)this, this.getCacheDataDescription().getVersionComparator());
        }
        if (cacheMode.isDistributed() || cacheMode.isReplicated()) {
            this.prepareForTombstones(cacheMode);
            return new TombstoneAccessDelegate((InfinispanDataRegion)this);
        }
        this.prepareForValidation();
        if (this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            return new TxInvalidationCacheAccessDelegate((InfinispanDataRegion)this, this.validator);
        }
        return new NonTxInvalidationCacheAccessDelegate((InfinispanDataRegion)this, this.validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForValidation() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VALIDATION);
            return;
        }
        AdvancedCache advancedCache = this.cache;
        synchronized (advancedCache) {
            PutFromLoadValidator found = this.findValidator(this.cache);
            this.validator = found != null ? found : new PutFromLoadValidator(this.cache, (TimeSource)this.factory, this.factory.getPendingPutsCacheConfiguration());
            this.strategy = Strategy.VALIDATION;
        }
    }

    private PutFromLoadValidator findValidator(AdvancedCache cache) {
        CacheCommandInitializer cmdInit = (CacheCommandInitializer)cache.getComponentRegistry().getComponent(CacheCommandInitializer.class);
        return cmdInit.findPutFromLoadValidator(cache.getName());
    }

    private void prepareForVersionedEntries(CacheMode cacheMode) {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VERSIONED_ENTRIES);
            return;
        }
        this.prepareCommon(cacheMode);
        this.filter = VersionedEntry.EXCLUDE_EMPTY_VERSIONED_ENTRY;
        this.strategy = Strategy.VERSIONED_ENTRIES;
    }

    private void prepareForTombstones(CacheMode cacheMode) {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.TOMBSTONES);
            return;
        }
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.memory().isEvictionEnabled()) {
            log.evictionWithTombstones();
        }
        this.prepareCommon(cacheMode);
        this.filter = Tombstone.EXCLUDE_TOMBSTONES;
        this.strategy = Strategy.TOMBSTONES;
    }

    private void prepareCommon(CacheMode cacheMode) {
        InternalExpirationManager expirationManager;
        BasicComponentRegistry registry = (BasicComponentRegistry)this.cache.getComponentRegistry().getComponent(BasicComponentRegistry.class);
        if (cacheMode.isReplicated() || cacheMode.isDistributed()) {
            AsyncInterceptorChain chain = this.cache.getAsyncInterceptorChain();
            LockingInterceptor lockingInterceptor = new LockingInterceptor();
            registry.registerComponent(LockingInterceptor.class, (Object)lockingInterceptor, true).running();
            if (!chain.addInterceptorBefore((AsyncInterceptor)lockingInterceptor, NonTransactionalLockingInterceptor.class)) {
                throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
            }
            chain.removeInterceptor(NonTransactionalLockingInterceptor.class);
            UnorderedDistributionInterceptor distributionInterceptor = new UnorderedDistributionInterceptor();
            registry.registerComponent(UnorderedDistributionInterceptor.class, (Object)distributionInterceptor, true).running();
            if (!chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, NonTxDistributionInterceptor.class) && !chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, TriangleDistributionInterceptor.class)) {
                throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
            }
            chain.removeInterceptor(NonTxDistributionInterceptor.class);
            chain.removeInterceptor(TriangleDistributionInterceptor.class);
        }
        if ((expirationManager = (InternalExpirationManager)registry.getComponent(InternalExpirationManager.class).running()) instanceof ClusterExpirationManager) {
            registry.replaceComponent(InternalExpirationManager.class.getName(), (Object)new ExpirationManagerImpl(), true);
            registry.getComponent(InternalExpirationManager.class).running();
            registry.rewire();
            ((ClusterExpirationManager)expirationManager).stop();
        } else if (!(expirationManager instanceof ExpirationManagerImpl)) {
            throw new IllegalStateException("Expected clustered expiration manager, found " + expirationManager);
        }
        registry.registerComponent(InfinispanDataRegion.class, (Object)this, true);
        if (cacheMode.isClustered()) {
            UnorderedReplicationLogic replLogic = new UnorderedReplicationLogic();
            registry.replaceComponent(ClusteringDependentLogic.class.getName(), (Object)replLogic, true);
            registry.getComponent(ClusteringDependentLogic.class).running();
            registry.rewire();
        }
    }

    public long getTombstoneExpiration() {
        return this.tombstoneExpiration;
    }

    public MetaParam.MetaLifespan getExpiringMetaParam() {
        return this.expiringMetaParam;
    }

    @Override
    protected void runInvalidation(boolean inTransaction) {
        if (this.strategy == null) {
            throw new IllegalStateException("Strategy was not set");
        }
        switch (this.strategy) {
            case NONE: 
            case VALIDATION: {
                super.runInvalidation(inTransaction);
                return;
            }
            case TOMBSTONES: {
                this.removeEntries(inTransaction, entry -> this.localCache.remove(entry.getKey(), entry.getValue()));
                return;
            }
            case VERSIONED_ENTRIES: {
                VersionedEntry evict = new VersionedEntry(this.nextTimestamp());
                this.removeEntries(inTransaction, entry -> this.localCache.put(entry.getKey(), (Object)evict, this.getTombstoneExpiration(), TimeUnit.MILLISECONDS));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntries(boolean inTransaction, Consumer<Map.Entry<Object, Object>> remover) {
        boolean startedTx = false;
        if (!inTransaction && this.requiresTransaction) {
            try {
                this.tm.begin();
                startedTx = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.localCache.entrySet().stream().filter(this.filter).forEach(remover);
        }
        finally {
            if (startedTx) {
                try {
                    this.tm.commit();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Comparator<Object> getComparator(String subclass) {
        return this.metadata.getVersionComparator();
    }

    @Override
    public void destroy() throws CacheException {
        super.destroy();
        if (this.validator != null) {
            this.validator.destroy();
        }
    }

    protected static enum Strategy {
        NONE,
        VALIDATION,
        TOMBSTONES,
        VERSIONED_ENTRIES;

    }
}

