/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v51.naturalid;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.v51.access.AbstractAccess;
import org.infinispan.hibernate.cache.v51.naturalid.NaturalIdRegionImpl;

public class ReadOnlyAccess
extends AbstractAccess
implements NaturalIdRegionAccessStrategy {
    private final NaturalIdRegionImpl region;

    public ReadOnlyAccess(NaturalIdRegionImpl region, AccessDelegate delegate) {
        super(delegate);
        this.region = region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.insert((Object)session, key, value, null);
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get((Object)session, key, txTimestamp);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad((Object)session, key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad((Object)session, key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SessionImplementor session, Object key) throws CacheException {
        this.delegate.remove((Object)session, key);
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem((Object)session, key);
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.afterInsert((Object)session, key, value, null);
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return this.region.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return this.region.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }

    public NaturalIdRegion getRegion() {
        return this.region;
    }
}

