/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;
import org.infinispan.commons.util.ReflectionUtil;

public class RICacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private static final long serialVersionUID = 6515030413069752679L;
    private K key;
    private V value;
    private V oldValue;
    private boolean oldValueAvailable;

    public RICacheEntryEvent(Cache<K, V> source, K key, V value, EventType eventType) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = null;
        this.oldValueAvailable = false;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)((Object)this), clazz);
    }

    public V getOldValue() throws UnsupportedOperationException {
        if (this.isOldValueAvailable()) {
            return this.oldValue;
        }
        throw new UnsupportedOperationException("Old value is not available for key");
    }

    public boolean isOldValueAvailable() {
        return this.oldValueAvailable;
    }
}

