/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.IncompleteCondition;
import org.infinispan.query.dsl.impl.NotCondition;
import org.infinispan.query.dsl.impl.SortCriteria;
import org.infinispan.query.dsl.impl.Visitable;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

public abstract class BaseQueryBuilder
implements QueryBuilder,
Visitable {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)BaseQueryBuilder.class.getName());
    protected final QueryFactory queryFactory;
    protected final String rootTypeName;
    protected Expression[] projection;
    protected String[] groupBy;
    protected BaseCondition filterCondition;
    protected BaseCondition whereFilterCondition;
    protected BaseCondition havingFilterCondition;
    protected List<SortCriteria> sortCriteria;
    protected long startOffset = -1L;
    protected int maxResults = -1;

    protected BaseQueryBuilder(QueryFactory queryFactory, String rootTypeName) {
        if (rootTypeName == null) {
            throw log.argumentCannotBeNull("rootTypeName");
        }
        this.queryFactory = queryFactory;
        this.rootTypeName = rootTypeName;
    }

    protected String getRootTypeName() {
        return this.rootTypeName;
    }

    @Override
    public QueryBuilder orderBy(Expression pathExpression) {
        return this.orderBy(pathExpression, SortOrder.ASC);
    }

    @Override
    public QueryBuilder orderBy(Expression pathExpression, SortOrder sortOrder) {
        if (this.sortCriteria == null) {
            this.sortCriteria = new ArrayList<SortCriteria>();
        }
        this.sortCriteria.add(new SortCriteria(pathExpression, sortOrder));
        return this;
    }

    @Override
    public QueryBuilder orderBy(String attributePath) {
        return this.orderBy(attributePath, SortOrder.ASC);
    }

    @Override
    public QueryBuilder orderBy(String attributePath, SortOrder sortOrder) {
        return this.orderBy(Expression.property(attributePath), sortOrder);
    }

    protected List<SortCriteria> getSortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public QueryBuilder select(String ... attributePath) {
        if (attributePath == null || attributePath.length == 0) {
            throw log.projectionCannotBeNullOrEmpty();
        }
        Expression[] projection = new Expression[attributePath.length];
        for (int i = 0; i < attributePath.length; ++i) {
            projection[i] = Expression.property(attributePath[i]);
        }
        return this.select(projection);
    }

    @Override
    public QueryBuilder select(Expression ... projection) {
        if (projection == null || projection.length == 0) {
            throw log.projectionCannotBeNullOrEmpty();
        }
        if (this.projection != null) {
            throw log.projectionCanBeSpecifiedOnlyOnce();
        }
        this.projection = projection;
        return this;
    }

    protected Expression[] getProjection() {
        return this.projection;
    }

    protected String[] getProjectionPaths() {
        if (this.projection == null) {
            return null;
        }
        String[] _projection = new String[this.projection.length];
        for (int i = 0; i < this.projection.length; ++i) {
            _projection[i] = this.projection[i].toString();
        }
        return _projection;
    }

    @Override
    public QueryBuilder groupBy(String ... groupBy) {
        if (groupBy == null || groupBy.length == 0) {
            throw log.groupingCannotBeNullOrEmpty();
        }
        if (this.groupBy != null) {
            throw log.groupingCanBeSpecifiedOnlyOnce();
        }
        this.groupBy = groupBy;
        this.filterCondition = null;
        return this;
    }

    protected String[] getGroupBy() {
        return this.groupBy;
    }

    @Override
    public QueryBuilder startOffset(long startOffset) {
        if (startOffset < 0L) {
            throw log.startOffsetCannotBeLessThanZero();
        }
        this.startOffset = startOffset;
        return this;
    }

    @Override
    public QueryBuilder maxResults(int maxResults) {
        if (maxResults <= 0) {
            throw log.maxResultMustBeGreaterThanZero();
        }
        this.maxResults = maxResults;
        return this;
    }

    protected BaseCondition getWhereFilterCondition() {
        return this.whereFilterCondition;
    }

    protected BaseCondition getHavingFilterCondition() {
        return this.havingFilterCondition;
    }

    @Override
    public FilterConditionEndContext having(Expression expression) {
        if (this.filterCondition != null) {
            throw log.cannotUseOperatorAgain("having(..)");
        }
        AttributeCondition attributeCondition = new AttributeCondition(this.queryFactory, expression);
        attributeCondition.setQueryBuilder(this);
        this.setFilterCondition(attributeCondition);
        return attributeCondition;
    }

    @Override
    public FilterConditionEndContext having(String attributePath) {
        return this.having(Expression.property(attributePath));
    }

    private void setFilterCondition(BaseCondition filterCondition) {
        this.filterCondition = filterCondition;
        if (this.groupBy == null) {
            this.whereFilterCondition = filterCondition;
        } else {
            this.havingFilterCondition = filterCondition;
        }
    }

    @Override
    public BaseCondition not() {
        if (this.filterCondition != null) {
            throw log.cannotUseOperatorAgain("not()");
        }
        IncompleteCondition incompleteCondition = new IncompleteCondition(this.queryFactory);
        incompleteCondition.setQueryBuilder(this);
        this.setFilterCondition(incompleteCondition);
        return incompleteCondition.not();
    }

    @Override
    public BaseCondition not(FilterConditionContext fcc) {
        if (fcc == null) {
            throw log.argumentCannotBeNull();
        }
        if (this.filterCondition != null) {
            throw log.cannotUseOperatorAgain("not(..)");
        }
        BaseCondition baseCondition = ((BaseCondition)fcc).getRoot();
        if (baseCondition.queryFactory != this.queryFactory) {
            throw log.conditionWasCreatedByAnotherFactory();
        }
        if (baseCondition.queryBuilder != null) {
            throw log.conditionIsAlreadyInUseByAnotherBuilder();
        }
        NotCondition notCondition = new NotCondition(this.queryFactory, baseCondition);
        notCondition.setQueryBuilder(this);
        this.setFilterCondition(notCondition);
        return this.filterCondition;
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }
}

