/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.hibernate.search.analyzer.Discriminator;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.logging.Log;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.util.logging.LogFactory;

public final class ProtobufValueWrapperAnalyzerDiscriminator
implements Discriminator {
    private static final Log log = (Log)LogFactory.getLog(ProtobufValueWrapperAnalyzerDiscriminator.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();

    public String getAnalyzerDefinitionName(Object value, Object entity, String field) {
        if (entity instanceof ProtobufValueWrapper) {
            ProtobufValueWrapper wrapper = (ProtobufValueWrapper)entity;
            Descriptor messageDescriptor = wrapper.getMessageDescriptor();
            if (messageDescriptor != null) {
                return this.getAnalyzerForField(messageDescriptor, field);
            }
            throw new IllegalStateException("Message descriptor not initialized for " + wrapper);
        }
        return null;
    }

    private String getAnalyzerForField(Descriptor messageDescriptor, String fieldName) {
        FieldMapping fieldMapping;
        IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
        if (indexingMetadata != null && (fieldMapping = indexingMetadata.getFieldMapping(fieldName)) != null && fieldMapping.analyze()) {
            String analyzerName = fieldMapping.analyzer();
            if (analyzerName == null || analyzerName.isEmpty()) {
                analyzerName = indexingMetadata.analyzer();
            }
            if (analyzerName != null && !analyzerName.isEmpty()) {
                if (trace) {
                    log.tracef("Using analyzer %s for field %s of type %s", (Object)analyzerName, (Object)fieldName, (Object)messageDescriptor.getFullName());
                }
                return analyzerName;
            }
        }
        return null;
    }
}

