/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.AnnotationLiteral;
import org.infinispan.cdi.Remote;
import org.infinispan.cdi.RemoteCacheProducer;
import org.infinispan.cdi.util.BeanBuilder;
import org.infinispan.cdi.util.ContextualLifecycle;
import org.infinispan.cdi.util.Reflections;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;

public class InfinispanExtensionRemote
implements Extension {
    private final Map<Type, Set<Annotation>> remoteCacheInjectionPoints;
    private Producer<RemoteCache<?, ?>> remoteCacheProducer;

    public InfinispanExtensionRemote() {
        new ConfigurationBuilder();
        this.remoteCacheInjectionPoints = new HashMap<Type, Set<Annotation>>();
    }

    void processProducers(@Observes ProcessProducer<?, ?> event) {
        AnnotatedMember member = event.getAnnotatedMember();
        if (RemoteCacheProducer.class.equals((Object)member.getDeclaringType().getBaseType())) {
            this.remoteCacheProducer = event.getProducer();
        }
    }

    <T> void saveRemoteInjectionPoints(@Observes ProcessInjectionTarget<T> event, BeanManager beanManager) {
        InjectionTarget injectionTarget = event.getInjectionTarget();
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            Annotated annotated = injectionPoint.getAnnotated();
            Type type = annotated.getBaseType();
            Class rawType = Reflections.getRawType(annotated.getBaseType());
            Set<Annotation> qualifiers = Reflections.getQualifiers(beanManager, (Iterable<Annotation>)annotated.getAnnotations());
            if (rawType.equals(RemoteCache.class) && qualifiers.isEmpty()) {
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                this.addRemoteCacheInjectionPoint(type, qualifiers);
                continue;
            }
            if (annotated.isAnnotationPresent(Remote.class) || Reflections.getMetaAnnotation(annotated, Remote.class) == null || !rawType.isAssignableFrom(RemoteCache.class)) continue;
            this.addRemoteCacheInjectionPoint(type, qualifiers);
        }
    }

    private void addRemoteCacheInjectionPoint(Type type, Set<Annotation> qualifiers) {
        Set<Annotation> currentQualifiers = this.remoteCacheInjectionPoints.get(type);
        if (currentQualifiers == null) {
            this.remoteCacheInjectionPoints.put(type, qualifiers);
        } else {
            currentQualifiers.addAll(qualifiers);
        }
    }

    <T, X> void registerCacheBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (Map.Entry<Type, Set<Annotation>> entry : this.remoteCacheInjectionPoints.entrySet()) {
            event.addBean(new BeanBuilder(beanManager).readFromType(beanManager.createAnnotatedType(Reflections.getRawType(entry.getKey()))).addType(entry.getKey()).addQualifiers((Collection<Annotation>)entry.getValue()).beanLifecycle(new ContextualLifecycle<RemoteCache<?, ?>>(){

                @Override
                public RemoteCache<?, ?> create(Bean<RemoteCache<?, ?>> bean, CreationalContext<RemoteCache<?, ?>> ctx) {
                    return (RemoteCache)InfinispanExtensionRemote.this.remoteCacheProducer.produce(ctx);
                }

                @Override
                public void destroy(Bean<RemoteCache<?, ?>> bean, RemoteCache<?, ?> instance, CreationalContext<RemoteCache<?, ?>> ctx) {
                    InfinispanExtensionRemote.this.remoteCacheProducer.dispose(instance);
                }
            }).create());
        }
    }
}

