/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfigurationBuilder;

public class SslConfigurationBuilder<T extends ProtocolServerConfiguration, S extends ProtocolServerConfigurationChildBuilder<T, S>>
extends AbstractProtocolServerConfigurationChildBuilder<T, S>
implements Builder<SslConfiguration> {
    private boolean enabled = false;
    private boolean requireClientAuth = false;
    private SslEngineConfigurationBuilder defaultDomainConfigurationBuilder = new SslEngineConfigurationBuilder(this);
    private Map<String, SslEngineConfigurationBuilder> sniDomains = new HashMap<String, SslEngineConfigurationBuilder>();

    public SslConfigurationBuilder(ProtocolServerConfigurationChildBuilder<T, S> builder) {
        super(builder);
        this.defaultDomainConfigurationBuilder = new SslEngineConfigurationBuilder(this);
        this.sniDomains.put("*", this.defaultDomainConfigurationBuilder);
    }

    public SslConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SslConfigurationBuilder requireClientAuth(boolean requireClientAuth) {
        this.requireClientAuth = requireClientAuth;
        return this;
    }

    public SslEngineConfigurationBuilder sniHostName(String domain) {
        return this.sniDomains.computeIfAbsent(domain, v -> new SslEngineConfigurationBuilder(this));
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.defaultDomainConfigurationBuilder.sslContext(sslContext);
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.defaultDomainConfigurationBuilder.keyStoreFileName(keyStoreFileName);
        return this;
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.defaultDomainConfigurationBuilder.keyStoreType(keyStoreType);
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.defaultDomainConfigurationBuilder.keyStorePassword(keyStorePassword);
        return this;
    }

    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.defaultDomainConfigurationBuilder.keyStoreCertificatePassword(keyStoreCertificatePassword);
        return this;
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.defaultDomainConfigurationBuilder.keyAlias(keyAlias);
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.defaultDomainConfigurationBuilder.trustStoreFileName(trustStoreFileName);
        return this;
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.defaultDomainConfigurationBuilder.trustStoreType(trustStoreType);
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.defaultDomainConfigurationBuilder.trustStorePassword(trustStorePassword);
        return this;
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.defaultDomainConfigurationBuilder.protocol(protocol);
        return this;
    }

    public void validate() {
        if (this.enabled) {
            this.sniDomains.forEach((domainName, config) -> config.validate());
        }
    }

    public SslConfiguration create() {
        Map<String, SslEngineConfiguration> producedSniConfigurations = this.sniDomains.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SslEngineConfigurationBuilder)e.getValue()).create()));
        return new SslConfiguration(this.enabled, this.requireClientAuth, producedSniConfigurations);
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.enabled = template.enabled();
        this.requireClientAuth = template.requireClientAuth();
        this.sniDomains = new HashMap<String, SslEngineConfigurationBuilder>();
        template.sniDomainsConfiguration().entrySet().forEach(e -> this.sniDomains.put((String)e.getKey(), new SslEngineConfigurationBuilder(this).read((SslEngineConfiguration)e.getValue())));
        this.defaultDomainConfigurationBuilder = this.sniDomains.computeIfAbsent("*", v -> new SslEngineConfigurationBuilder(this));
        return this;
    }

    public S self() {
        return (S)this;
    }
}

