package org.infinispan.server.core.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import io.netty.channel.Channel;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.xml.stream.XMLStreamException;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.dataconversion.TranscodingException;
import java.net.SocketAddress;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-20T13:33:51+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverDidNotUnbind() {
        super.log.logf(FQCN, WARN, null, serverDidNotUnbind$str());
    }
    private static final String serverDidNotUnbind = "ISPN005004: Server channel group did not completely unbind";
    protected String serverDidNotUnbind$str() {
        return serverDidNotUnbind;
    }
    @Override
    public final void channelStillBound(final Channel ch, final SocketAddress address) {
        super.log.logf(FQCN, WARN, null, channelStillBound$str(), ch, address);
    }
    private static final String channelStillBound = "ISPN005005: %s is still bound to %s";
    protected String channelStillBound$str() {
        return channelStillBound;
    }
    @Override
    public final void serverDidNotClose() {
        super.log.logf(FQCN, WARN, null, serverDidNotClose$str());
    }
    private static final String serverDidNotClose = "ISPN005006: Channel group did not completely close";
    protected String serverDidNotClose$str() {
        return serverDidNotClose;
    }
    @Override
    public final void channelStillConnected(final Channel ch, final SocketAddress address) {
        super.log.logf(FQCN, WARN, null, channelStillConnected$str(), ch, address);
    }
    private static final String channelStillConnected = "ISPN005007: %s is still connected to %s";
    protected String channelStillConnected$str() {
        return channelStillConnected;
    }
    private static final String illegalWorkerThreads = "ISPN005010: Illegal number of workerThreads: %d";
    protected String illegalWorkerThreads$str() {
        return illegalWorkerThreads;
    }
    @Override
    public final IllegalArgumentException illegalWorkerThreads(final int workerThreads) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalWorkerThreads$str(), workerThreads));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalIdleTimeout = "ISPN005011: Idle timeout can't be lower than -1: %d";
    protected String illegalIdleTimeout$str() {
        return illegalIdleTimeout;
    }
    @Override
    public final IllegalArgumentException illegalIdleTimeout(final int idleTimeout) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalIdleTimeout$str(), idleTimeout));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalReceiveBufferSize = "ISPN005012: Receive Buffer Size can't be lower than 0: %d";
    protected String illegalReceiveBufferSize$str() {
        return illegalReceiveBufferSize;
    }
    @Override
    public final IllegalArgumentException illegalReceiveBufferSize(final int recvBufSize) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalReceiveBufferSize$str(), recvBufSize));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalSendBufferSize = "ISPN005013: Send Buffer Size can't be lower than 0: %d";
    protected String illegalSendBufferSize$str() {
        return illegalSendBufferSize;
    }
    @Override
    public final IllegalArgumentException illegalSendBufferSize(final int sendBufSize) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalSendBufferSize$str(), sendBufSize));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSSLKeyManagerConfiguration = "ISPN005014: SSL Enabled but no KeyStore specified";
    protected String noSSLKeyManagerConfiguration$str() {
        return noSSLKeyManagerConfiguration;
    }
    @Override
    public final CacheConfigurationException noSSLKeyManagerConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSSLKeyManagerConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingKeyStorePassword = "ISPN005016: A password is required to open the KeyStore '%s'";
    protected String missingKeyStorePassword$str() {
        return missingKeyStorePassword;
    }
    @Override
    public final CacheConfigurationException missingKeyStorePassword(final String keyStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingKeyStorePassword$str(), keyStore));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingTrustStorePassword = "ISPN005017: A password is required to open the TrustStore '%s'";
    protected String missingTrustStorePassword$str() {
        return missingTrustStorePassword;
    }
    @Override
    public final CacheConfigurationException missingTrustStorePassword(final String trustStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingTrustStorePassword$str(), trustStore));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xorSSLContext = "ISPN005018: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    protected String xorSSLContext$str() {
        return xorSSLContext;
    }
    @Override
    public final CacheConfigurationException xorSSLContext() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xorSSLContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void createdSocketChannel(final String channelClassName, final String configuration) {
        super.log.logf(FQCN, DEBUG, null, createdSocketChannel$str(), channelClassName, configuration);
    }
    private static final String createdSocketChannel = "ISPN005025: Using Netty SocketChannel %s for %s";
    protected String createdSocketChannel$str() {
        return createdSocketChannel;
    }
    @Override
    public final void createdNettyEventLoop(final String eventLoopClassName, final String configuration) {
        super.log.logf(FQCN, DEBUG, null, createdNettyEventLoop$str(), eventLoopClassName, configuration);
    }
    private static final String createdNettyEventLoop = "ISPN005026: Using Netty EventLoop %s for %s";
    protected String createdNettyEventLoop$str() {
        return createdNettyEventLoop;
    }
    private static final String noSniDomainConfigured = "ISPN005027: SSL Enabled but no SNI domain configured";
    protected String noSniDomainConfigured$str() {
        return noSniDomainConfigured;
    }
    @Override
    public final CacheConfigurationException noSniDomainConfigured() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSniDomainConfigured$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void epollNotAvailable(final String message) {
        super.log.logf(FQCN, WARN, null, epollNotAvailable$str(), message);
    }
    private static final String epollNotAvailable = "ISPN005028: Native Epoll transport not available, using NIO instead: %s";
    protected String epollNotAvailable$str() {
        return epollNotAvailable;
    }
    private static final String cannotRegisterAdminOperationsHandler = "ISPN005029: No task manager available to register the admin operations handler";
    protected String cannotRegisterAdminOperationsHandler$str() {
        return cannotRegisterAdminOperationsHandler;
    }
    @Override
    public final CacheConfigurationException cannotRegisterAdminOperationsHandler() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotRegisterAdminOperationsHandler$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredAdminTaskParameter = "ISPN005030: Administration task '%s' invoked without required parameter '%s'";
    protected String missingRequiredAdminTaskParameter$str() {
        return missingRequiredAdminTaskParameter;
    }
    @Override
    public final NullPointerException missingRequiredAdminTaskParameter(final String name, final String parameter) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), missingRequiredAdminTaskParameter$str(), name, parameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCacheConfiguration = "ISPN005031: The supplied configuration for cache '%s' is missing a named configuration for it: %s";
    protected String missingCacheConfiguration$str() {
        return missingCacheConfiguration;
    }
    @Override
    public final CacheConfigurationException missingCacheConfiguration(final String name, final String configuration) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingCacheConfiguration$str(), name, configuration));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDuringTranscoding = "ISPN005032: Error during transcoding";
    protected String errorDuringTranscoding$str() {
        return errorDuringTranscoding;
    }
    @Override
    public final TranscodingException errorDuringTranscoding(final Throwable e) {
        final TranscodingException result = new TranscodingException(String.format(getLoggingLocale(), errorDuringTranscoding$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedDataFormat = "ISPN005033: Data format '%s' not supported";
    protected String unsupportedDataFormat$str() {
        return unsupportedDataFormat;
    }
    @Override
    public final TranscodingException unsupportedDataFormat(final MediaType contentFormat) {
        final TranscodingException result = new TranscodingException(String.format(getLoggingLocale(), unsupportedDataFormat$str(), contentFormat));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateClusteredCache = "ISPN005034: Cannot create clustered caches in non-clustered servers";
    protected String cannotCreateClusteredCache$str() {
        return cannotCreateClusteredCache;
    }
    @Override
    public final UnsupportedOperationException cannotCreateClusteredCache() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), cannotCreateClusteredCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDeserializing = "ISPN005035: Class '%s' blocked by deserialization white list. Include the class name in the server cache manager white list to authorize.";
    protected String errorDeserializing$str() {
        return errorDeserializing;
    }
    @Override
    public final CacheException errorDeserializing(final String className) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorDeserializing$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalIOThreads = "ISPN005036: Illegal number of ioThreads: %d";
    protected String illegalIOThreads$str() {
        return illegalIOThreads;
    }
    @Override
    public final IllegalArgumentException illegalIOThreads(final int ioThreads) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalIOThreads$str(), ioThreads));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProviderForAuthorizationRealm = "ISPN005037: No provider for authorization realm";
    protected String noProviderForAuthorizationRealm$str() {
        return noProviderForAuthorizationRealm;
    }
    @Override
    public final XMLStreamException noProviderForAuthorizationRealm() {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), noProviderForAuthorizationRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
