/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.server.core.CacheIgnoreAware;

public class AbstractCacheIgnoreAware
implements CacheIgnoreAware {
    private Set<String> ignoredCaches = ConcurrentHashMap.newKeySet();

    @Override
    public void setIgnoredCaches(Set<String> cacheNames) {
        this.ignoredCaches.clear();
        cacheNames.forEach(this.ignoredCaches::add);
    }

    @Override
    public void unignore(String cacheName) {
        this.ignoredCaches.remove(cacheName);
    }

    @Override
    public void ignoreCache(String cacheName) {
        this.ignoredCaches.add(cacheName);
    }

    @Override
    public boolean isCacheIgnored(String cacheName) {
        return this.ignoredCaches.contains(cacheName);
    }
}

