/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractCacheIgnoreAware;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.SecurityActions;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.utils.ManageableThreadPoolExecutorService;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;

public abstract class AbstractProtocolServer<A extends ProtocolServerConfiguration>
extends AbstractCacheIgnoreAware
implements ProtocolServer<A> {
    private static final Log log = (Log)LogFactory.getLog(AbstractProtocolServer.class, Log.class);
    private final String protocolName;
    protected NettyTransport transport;
    protected EmbeddedCacheManager cacheManager;
    protected A configuration;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;
    private ThreadPoolExecutor executor;
    private ObjectName executorObjName;
    private ThreadPoolExecutor.AbortPolicy abortPolicy = new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (AbstractProtocolServer.this.executor.isShutdown()) {
                throw new IllegalLifecycleStateException("Server has been stopped");
            }
            super.rejectedExecution(r, e);
        }
    };

    protected AbstractProtocolServer(String protocolName) {
        this.protocolName = protocolName;
    }

    @Override
    public String getName() {
        return this.protocolName;
    }

    protected void startInternal(A configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        if (log.isDebugEnabled()) {
            log.debugf("Starting server with configuration: %s", configuration);
        }
        this.registerAdminOperationsHandler();
        this.startDefaultCache();
        if (((ProtocolServerConfiguration)configuration).startTransport()) {
            this.startTransport();
        }
    }

    private void registerAdminOperationsHandler() {
        if (((ProtocolServerConfiguration)this.configuration).adminOperationsHandler() != null) {
            TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(TaskManager.class);
            if (taskManager != null) {
                taskManager.registerTaskEngine((TaskEngine)((ProtocolServerConfiguration)this.configuration).adminOperationsHandler());
            } else {
                throw log.cannotRegisterAdminOperationsHandler();
            }
        }
    }

    @Override
    public final void start(A configuration, EmbeddedCacheManager cacheManager) {
        try {
            ((ProtocolServerConfiguration)configuration).ignoredCaches().forEach(this::ignoreCache);
            this.startInternal(configuration, cacheManager);
        }
        catch (RuntimeException t) {
            this.stop();
            throw t;
        }
    }

    protected void startTransport() {
        InetSocketAddress address = new InetSocketAddress(((ProtocolServerConfiguration)this.configuration).host(), ((ProtocolServerConfiguration)this.configuration).port());
        this.transport = new NettyTransport(address, (ProtocolServerConfiguration)this.configuration, this.getQualifiedName(), this.cacheManager);
        this.transport.initializeHandler(this.getInitializer());
        this.registerServerMBeans();
        try {
            this.transport.start();
        }
        catch (Throwable re) {
            try {
                this.unregisterServerMBeans();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            throw re;
        }
    }

    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            DefaultThreadFactory factory = new DefaultThreadFactory(this.getQualifiedName() + "-ServerHandler");
            int workerThreads = this.getWorkerThreads();
            this.executor = new ThreadPoolExecutor(workerThreads, workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)factory, this.abortPolicy);
        }
        return this.executor;
    }

    protected void registerServerMBeans() {
        GlobalConfiguration globalCfg = this.cacheManager.getCacheManagerConfiguration();
        GlobalJmxStatisticsConfiguration jmxConfig = globalCfg.globalJmxStatistics();
        if (jmxConfig.enabled()) {
            this.mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
            String groupName = String.format("type=Server,name=%s", this.getQualifiedName());
            String jmxDomain = JmxUtil.buildJmxDomain((String)jmxConfig.domain(), (MBeanServer)this.mbeanServer, (String)groupName);
            try {
                this.transportObjName = this.registerMBean(this.transport, jmxDomain, groupName, null);
                this.executorObjName = this.registerMBean((Object)new ManageableThreadPoolExecutorService(this.getExecutor()), jmxDomain, groupName, "WorkerExecutor");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ObjectName registerMBean(Object instance, String jmxDomain, String groupName, String name) throws Exception {
        CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)this.cacheManager.getGlobalComponentRegistry().getComponent(CacheManagerJmxRegistration.class);
        return jmxRegistration.registerExternalMBean(instance, jmxDomain, groupName, name);
    }

    protected void unregisterServerMBeans() throws Exception {
        if (this.transportObjName != null) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName, (MBeanServer)this.mbeanServer);
        }
        if (this.executorObjName != null) {
            JmxUtil.unregisterMBean((ObjectName)this.executorObjName, (MBeanServer)this.mbeanServer);
        }
    }

    public String getQualifiedName() {
        return this.protocolName + (((ProtocolServerConfiguration)this.configuration).name().length() > 0 ? "-" : "") + ((ProtocolServerConfiguration)this.configuration).name();
    }

    @Override
    public void stop() {
        boolean isDebug = log.isDebugEnabled();
        if (isDebug && this.configuration != null) {
            log.debugf("Stopping server %s listening at %s:%d", this.getQualifiedName(), ((ProtocolServerConfiguration)this.configuration).host(), ((ProtocolServerConfiguration)this.configuration).port());
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.transport != null) {
            this.transport.stop();
        }
        try {
            this.unregisterServerMBeans();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        if (isDebug) {
            log.debug("Server stopped");
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getHost() {
        return ((ProtocolServerConfiguration)this.configuration).host();
    }

    public Integer getPort() {
        if (this.transport != null) {
            return this.transport.getPort();
        }
        return ((ProtocolServerConfiguration)this.configuration).port();
    }

    @Override
    public A getConfiguration() {
        return this.configuration;
    }

    protected void startDefaultCache() {
        String name = this.defaultCacheName();
        if (name != null) {
            this.cacheManager.getCache(name);
        }
    }

    public String defaultCacheName() {
        if (((ProtocolServerConfiguration)this.configuration).defaultCacheName() != null) {
            return ((ProtocolServerConfiguration)this.configuration).defaultCacheName();
        }
        return this.cacheManager.getCacheManagerConfiguration().defaultCacheName().orElse(null);
    }

    public boolean isTransportEnabled() {
        return this.transport != null;
    }

    public NettyTransport getTransport() {
        return this.transport;
    }

    @Deprecated
    public abstract int getWorkerThreads();
}

