/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.util.logging.Log;

public class ProtostreamObjectTranscoder
implements Transcoder {
    private static final Log log = (Log)LogFactory.getLog(ProtostreamObjectTranscoder.class, Log.class);
    private final Set<MediaType> supportedTypes;
    private final SerializationContext ctx;
    private final ClassLoader classLoader;

    public ProtostreamObjectTranscoder(SerializationContext ctx, ClassLoader classLoader) {
        this.ctx = ctx;
        this.classLoader = classLoader;
        this.supportedTypes = new HashSet<MediaType>();
        this.supportedTypes.add(MediaType.APPLICATION_OBJECT);
        this.supportedTypes.add(MediaType.APPLICATION_PROTOSTREAM);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                String type = destinationType.getClassType();
                if (type == null) {
                    return ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.ctx, (byte[])((byte[])content));
                }
                Class destination = Util.loadClass((String)type, (ClassLoader)this.classLoader);
                byte[] bytes = (byte[])content;
                return ProtobufUtil.fromByteArray((ImmutableSerializationContext)this.ctx, (byte[])bytes, (int)0, (int)bytes.length, (Class)destination);
            }
            if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                Object decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
                Optional wrappedParam = destinationType.getParameter("wrapped");
                if (!wrappedParam.isPresent() || !((String)wrappedParam.get()).equals("false")) {
                    return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)decoded);
                }
                return ProtobufUtil.toByteArray((ImmutableSerializationContext)this.ctx, (Object)decoded);
            }
        }
        catch (IOException e) {
            throw log.errorTranscoding((Throwable)e);
        }
        throw log.unsupportedContent(content);
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supportedTypes;
    }
}

