package org.infinispan.server.core.logging;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.net.InetSocketAddress;
import io.netty.channel.Channel;
import java.lang.String;
import org.jboss.logging.Logger;
import io.netty.handler.ipfilter.IpFilterRule;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import org.infinispan.commons.dataconversion.MediaType;
import java.lang.Throwable;
import org.infinispan.server.core.dataconversion.TranscodingException;
import java.lang.Class;
import java.net.SocketAddress;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-12-16T10:00:51-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void channelStillBound(final Channel ch, final SocketAddress address) {
        super.log.logf(FQCN, WARN, null, channelStillBound$str(), ch, address);
    }
    protected String channelStillBound$str() {
        return "ISPN005005: %s is still bound to %s";
    }
    @Override
    public final void channelStillConnected(final Channel ch, final SocketAddress address) {
        super.log.logf(FQCN, WARN, null, channelStillConnected$str(), ch, address);
    }
    protected String channelStillConnected$str() {
        return "ISPN005007: %s is still connected to %s";
    }
    protected String illegalWorkerThreads$str() {
        return "ISPN005010: Illegal number of workerThreads: %d";
    }
    @Override
    public final IllegalArgumentException illegalWorkerThreads(final int workerThreads) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalWorkerThreads$str(), workerThreads));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalIdleTimeout$str() {
        return "ISPN005011: Idle timeout can't be lower than -1: %d";
    }
    @Override
    public final IllegalArgumentException illegalIdleTimeout(final int idleTimeout) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalIdleTimeout$str(), idleTimeout));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalReceiveBufferSize$str() {
        return "ISPN005012: Receive Buffer Size can't be lower than 0: %d";
    }
    @Override
    public final IllegalArgumentException illegalReceiveBufferSize(final int recvBufSize) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalReceiveBufferSize$str(), recvBufSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalSendBufferSize$str() {
        return "ISPN005013: Send Buffer Size can't be lower than 0: %d";
    }
    @Override
    public final IllegalArgumentException illegalSendBufferSize(final int sendBufSize) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalSendBufferSize$str(), sendBufSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSSLKeyManagerConfiguration$str() {
        return "ISPN005014: SSL Enabled but no KeyStore specified";
    }
    @Override
    public final CacheConfigurationException noSSLKeyManagerConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSSLKeyManagerConfiguration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingKeyStorePassword$str() {
        return "ISPN005016: A password is required to open the KeyStore '%s'";
    }
    @Override
    public final CacheConfigurationException missingKeyStorePassword(final String keyStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingKeyStorePassword$str(), keyStore));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTrustStorePassword$str() {
        return "ISPN005017: A password is required to open the TrustStore '%s'";
    }
    @Override
    public final CacheConfigurationException missingTrustStorePassword(final String trustStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingTrustStorePassword$str(), trustStore));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xorSSLContext$str() {
        return "ISPN005018: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    }
    @Override
    public final CacheConfigurationException xorSSLContext() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xorSSLContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void createdSocketChannel(final String channelClassName, final String configuration) {
        super.log.logf(FQCN, DEBUG, null, createdSocketChannel$str(), channelClassName, configuration);
    }
    protected String createdSocketChannel$str() {
        return "ISPN005025: Using Netty SocketChannel %s for %s";
    }
    @Override
    public final void createdNettyEventLoop(final String eventLoopClassName, final String configuration) {
        super.log.logf(FQCN, DEBUG, null, createdNettyEventLoop$str(), eventLoopClassName, configuration);
    }
    protected String createdNettyEventLoop$str() {
        return "ISPN005026: Using Netty EventLoop %s for %s";
    }
    protected String noSniDomainConfigured$str() {
        return "ISPN005027: SSL Enabled but no SNI domain configured";
    }
    @Override
    public final CacheConfigurationException noSniDomainConfigured() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSniDomainConfigured$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void epollNotAvailable(final String message) {
        super.log.logf(FQCN, INFO, null, epollNotAvailable$str(), message);
    }
    protected String epollNotAvailable$str() {
        return "ISPN005028: Native Epoll transport not available, using NIO instead: %s";
    }
    protected String cannotRegisterAdminOperationsHandler$str() {
        return "ISPN005029: No task manager available to register the admin operations handler";
    }
    @Override
    public final CacheConfigurationException cannotRegisterAdminOperationsHandler() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotRegisterAdminOperationsHandler$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingRequiredAdminTaskParameter$str() {
        return "ISPN005030: Administration task '%s' invoked without required parameter '%s'";
    }
    @Override
    public final NullPointerException missingRequiredAdminTaskParameter(final String name, final String parameter) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), missingRequiredAdminTaskParameter$str(), name, parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingCacheConfiguration$str() {
        return "ISPN005031: The supplied configuration for cache '%s' is missing a named configuration for it: %s";
    }
    @Override
    public final CacheConfigurationException missingCacheConfiguration(final String name, final String configuration) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingCacheConfiguration$str(), name, configuration));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedDataFormat$str() {
        return "ISPN005033: Data format '%s' not supported";
    }
    @Override
    public final TranscodingException unsupportedDataFormat(final MediaType contentFormat) {
        final TranscodingException result = new TranscodingException(String.format(getLoggingLocale(), unsupportedDataFormat$str(), contentFormat));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateClusteredCache$str() {
        return "ISPN005034: Cannot create clustered caches in non-clustered servers";
    }
    @Override
    public final UnsupportedOperationException cannotCreateClusteredCache() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), cannotCreateClusteredCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorDeserializing$str() {
        return "ISPN005035: Class '%s' blocked by deserialization allow list. Include the class name in the server cache manager allow list to authorize.";
    }
    @Override
    public final CacheException errorDeserializing(final String className) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorDeserializing$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalIOThreads$str() {
        return "ISPN005036: Illegal number of ioThreads: %d";
    }
    @Override
    public final IllegalArgumentException illegalIOThreads(final int ioThreads) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalIOThreads$str(), ioThreads));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalParameterType$str() {
        return "ISPN005038: Illegal type for parameter '%s': %s";
    }
    @Override
    public final IllegalArgumentException illegalParameterType(final String parameter, final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalParameterType$str(), parameter, type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingBackup$str() {
        return "ISPN005039: Cannot create cluster backup";
    }
    @Override
    public final CacheException errorCreatingBackup(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorCreatingBackup$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRestoringBackup$str() {
        return "ISPN005040: Cannot restore cluster backup '%s'";
    }
    @Override
    public final CacheException errorRestoringBackup(final Path path, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorRestoringBackup$str(), path), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupInProgress$str() {
        return "ISPN005041: Cannot perform backup, backup currently in progress";
    }
    @Override
    public final CacheException backupInProgress() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), backupInProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String restoreInProgress$str() {
        return "ISPN005042: Cannot restore content, restore currently in progress";
    }
    @Override
    public final CacheException restoreInProgress() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), restoreInProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void initiatingBackup(final String name) {
        super.log.logf(FQCN, INFO, null, initiatingBackup$str(), name);
    }
    protected String initiatingBackup$str() {
        return "ISPN005043: Starting backup '%s'";
    }
    @Override
    public final void backupComplete(final String backupName) {
        super.log.logf(FQCN, INFO, null, backupComplete$str(), backupName);
    }
    protected String backupComplete$str() {
        return "ISPN005044: Backup file created '%s'";
    }
    @Override
    public final void initiatingRestore(final String name, final Path backup) {
        super.log.logf(FQCN, INFO, null, initiatingRestore$str(), name, backup);
    }
    protected String initiatingRestore$str() {
        return "ISPN005045: Starting restore '%s' of '%s'";
    }
    @Override
    public final void restoreComplete(final String name) {
        super.log.logf(FQCN, INFO, null, restoreComplete$str(), name);
    }
    protected String restoreComplete$str() {
        return "ISPN005046: Restore '%s' complete";
    }
    protected String unableToFindBackupResource$str() {
        return "ISPN005047: %s '%s' not found in the backup archive";
    }
    @Override
    public final CacheException unableToFindBackupResource(final String resource, final Set<String> resourceNames) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToFindBackupResource$str(), resource, resourceNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindResource$str() {
        return "ISPN005048: %s '%s' does not exist";
    }
    @Override
    public final CacheException unableToFindResource(final String resource, final String resourceName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToFindResource$str(), resource, resourceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupAlreadyExists$str() {
        return "ISPN005049: Cannot perform backup, backup already exists with name '%s'";
    }
    @Override
    public final CacheException backupAlreadyExists(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), backupAlreadyExists$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void backupDeleted(final String name) {
        super.log.logf(FQCN, INFO, null, backupDeleted$str(), name);
    }
    protected String backupDeleted$str() {
        return "ISPN005050: Deleted backup '%s'";
    }
    protected String restoreAlreadyExists$str() {
        return "ISPN005051: Cannot perform restore, restore already exists with name '%s'";
    }
    @Override
    public final CacheException restoreAlreadyExists(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), restoreAlreadyExists$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ipFilterConnectionRejection(final InetSocketAddress remoteAddress, final IpFilterRule rule) {
        super.log.logf(FQCN, INFO, null, ipFilterConnectionRejection$str(), remoteAddress, rule);
    }
    protected String ipFilterConnectionRejection$str() {
        return "ISPN005052: Rejected connection from '%s' using rule '%s'";
    }
    protected String configurationMustContainSingleCache$str() {
        return "ISPN005053: The supplied configuration for cache '%s' must contain a single cache configuration for it: %s";
    }
    @Override
    public final CacheConfigurationException configurationMustContainSingleCache(final String name, final String configuration) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configurationMustContainSingleCache$str(), name, configuration));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ioUringNotAvailable(final String message) {
        super.log.logf(FQCN, INFO, null, ioUringNotAvailable$str(), message);
    }
    protected String ioUringNotAvailable$str() {
        return "ISPN005054: Native IOUring transport not available, using NIO instead: %s";
    }
    @Override
    public final void usingTransport(final String transportName) {
        super.log.logf(FQCN, INFO, null, usingTransport$str(), transportName);
    }
    protected String usingTransport$str() {
        return "Using transport: %s";
    }
}
