/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport.netty;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.core.transport.netty.NettyChannelPipelineFactory;
import org.infinispan.server.core.transport.netty.NettyTransport$;
import org.infinispan.util.logging.Log;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\b\u0003\u001d9+G\u000f^=Ue\u0006t7\u000f]8si*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\rM,'O^3s\u0015\tYA\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005!\u0011BA\n\u0005\u0005%!&/\u00198ta>\u0014H\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0005\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0011\u0005qiR\"\u0001\u0004\n\u0005y1!A\u0004)s_R|7m\u001c7TKJ4XM\u001d\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u00059QM\\2pI\u0016\u0014\bC\u0001\u0012)\u001b\u0005\u0019#B\u0001\u0013&\u0003\u001d\u0019\u0007.\u00198oK2T!a\u0001\u0014\u000b\u0005\u001db\u0011!\u00026c_N\u001c\u0018BA\u0015$\u0005a\u0019\u0005.\u00198oK2$un\u001e8tiJ,\u0017-\u001c%b]\u0012dWM\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u00059\u0011\r\u001a3sKN\u001c\bCA\u00173\u001b\u0005q#BA\u00181\u0003\rqW\r\u001e\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dFA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005iQ.Y:uKJ$\u0006N]3bIN\u0004\"!F\u001c\n\u0005a2\"aA%oi\"A!\b\u0001B\u0001B\u0003%a'A\u0007x_J\\WM\u001d+ie\u0016\fGm\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005m\u0005Y\u0011\u000e\u001a7f)&lWm\\;u\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\t\u00015I\u0004\u0002\u0016\u0003&\u0011!IF\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C-!)q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"\u0002\"S&M\u001b:{\u0005+\u0015\t\u0003\u0015\u0002i\u0011A\u0001\u0005\u0006\u0013\u0019\u0003\ra\u0007\u0005\u0006A\u0019\u0003\r!\t\u0005\u0006W\u0019\u0003\r\u0001\f\u0005\u0006k\u0019\u0003\rA\u000e\u0005\u0006u\u0019\u0003\rA\u000e\u0005\u0006y\u0019\u0003\rA\u000e\u0005\u0006}\u0019\u0003\ra\u0010\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u00039\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYN,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031\u000e\nQa\u001a:pkBL!AW,\u0003'\u0011+g-Y;mi\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\rq\u0003\u0001\u0015!\u0003V\u0003=\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYN\u0004\u0003b\u00020\u0001\u0005\u0004%\t\u0001V\u0001\u0011C\u000e\u001cW\r\u001d;fI\u000eC\u0017M\u001c8fYNDa\u0001\u0019\u0001!\u0002\u0013)\u0016!E1dG\u0016\u0004H/\u001a3DQ\u0006tg.\u001a7tA!9!\r\u0001b\u0001\n\u0013\u0019\u0017\u0001\u00039ja\u0016d\u0017N\\3\u0016\u0003\u0011\u0004\"AS3\n\u0005\u0019\u0014!a\u0007(fiRL8\t[1o]\u0016d\u0007+\u001b9fY&tWMR1di>\u0014\u0018\u0010\u0003\u0004i\u0001\u0001\u0006I\u0001Z\u0001\na&\u0004X\r\\5oK\u0002BqA\u001b\u0001C\u0002\u0013%1.A\u0004gC\u000e$xN]=\u0016\u00031\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u00079LwN\u0003\u0002rG\u000511o\\2lKRL!a\u001d8\u0003;9KwnU3sm\u0016\u00148k\\2lKR\u001c\u0005.\u00198oK24\u0015m\u0019;pefDa!\u001e\u0001!\u0002\u0013a\u0017\u0001\u00034bGR|'/\u001f\u0011\t\u0011]\u0004\u0001R1A\u0005\na\fa\"\\1ti\u0016\u0014X\t_3dkR|'/F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0006d_:\u001cWO\u001d:f]RT!A \u0019\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0003Y(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0013\u0005\u0015\u0001\u0001#A!B\u0013I\u0018aD7bgR,'/\u0012=fGV$xN\u001d\u0011\t\u0013\u0005%\u0001\u0001#b\u0001\n\u0013A\u0018AD<pe.,'/\u0012=fGV$xN\u001d\u0005\n\u0003\u001b\u0001\u0001\u0012!Q!\ne\fqb^8sW\u0016\u0014X\t_3dkR|'\u000f\t\u0005\b\u0003#\u0001A\u0011IA\n\u0003\u0015\u0019H/\u0019:u+\t\t)\u0002E\u0002\u0016\u0003/I1!!\u0007\u0017\u0005\u0011)f.\u001b;\t\u000f\u0005u\u0001\u0001\"\u0011\u0002\u0014\u0005!1\u000f^8q\u000f\u001d\t\tC\u0001E\u0003\u0003G\taBT3uif$&/\u00198ta>\u0014H\u000fE\u0002K\u0003K1\u0011\"\u0001\u0002\u0005\u0002\u0003E)!a\n\u0014\u000f\u0005\u0015\u0012\u0011FA\u001b)A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020A\nA\u0001\\1oO&!\u00111GA\u0017\u0005\u0019y%M[3diB\u0019A$a\u000e\n\u0007\u0005ebAA\u0004M_\u001e<\u0017N\\4\t\u000f\u001d\u000b)\u0003\"\u0001\u0002>Q\u0011\u00111\u0005")
public class NettyTransport
extends Transport
implements ScalaObject {
    private final SocketAddress address;
    private final int masterThreads;
    private final int workerThreads;
    public final String org$infinispan$server$core$transport$netty$NettyTransport$$threadNamePrefix;
    private final DefaultChannelGroup serverChannels;
    private final DefaultChannelGroup acceptedChannels;
    private final NettyChannelPipelineFactory pipeline;
    private final NioServerSocketChannelFactory factory;
    private ExecutorService masterExecutor;
    private ExecutorService workerExecutor;
    public volatile int bitmap$0;

    public static final void error(Function0 function0, Throwable throwable) {
        NettyTransport$.MODULE$.error(function0, throwable);
    }

    public static final void error(Function0 function0) {
        NettyTransport$.MODULE$.error(function0);
    }

    public static final void warn(Function0 function0, Throwable throwable) {
        NettyTransport$.MODULE$.warn(function0, throwable);
    }

    public static final void warn(Function0 function0, Seq seq) {
        NettyTransport$.MODULE$.warn(function0, seq);
    }

    public static final void trace(Function0 function0, Seq seq) {
        NettyTransport$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Function0 function0, Seq seq) {
        NettyTransport$.MODULE$.debug(function0, seq);
    }

    public static final void info(Function0 function0, Seq seq) {
        NettyTransport$.MODULE$.info(function0, seq);
    }

    public static final Log org$infinispan$server$core$Logging$$log() {
        return NettyTransport$.MODULE$.org$infinispan$server$core$Logging$$log();
    }

    private DefaultChannelGroup serverChannels() {
        return this.serverChannels;
    }

    public DefaultChannelGroup acceptedChannels() {
        return this.acceptedChannels;
    }

    private NettyChannelPipelineFactory pipeline() {
        return this.pipeline;
    }

    private NioServerSocketChannelFactory factory() {
        return this.factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService masterExecutor() {
        if ((this.bitmap$0 & 1) != 0) return this.masterExecutor;
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if ((this.bitmap$0 & 1) == 0) {
                ExecutorService executorService;
                if (this.masterThreads == 0) {
                    NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$masterExecutor$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    executorService = Executors.newCachedThreadPool();
                } else {
                    NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$masterExecutor$2(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.masterThreads)}));
                    executorService = Executors.newFixedThreadPool(this.masterThreads);
                }
                this.masterExecutor = executorService;
                this.bitmap$0 |= 1;
            }
            return this.masterExecutor;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService workerExecutor() {
        if ((this.bitmap$0 & 4) != 0) return this.workerExecutor;
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if ((this.bitmap$0 & 4) == 0) {
                ExecutorService executorService;
                if (this.workerThreads == 0) {
                    NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$workerExecutor$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    executorService = Executors.newCachedThreadPool();
                } else {
                    NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$workerExecutor$2(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.workerThreads)}));
                    executorService = Executors.newFixedThreadPool(this.masterThreads);
                }
                this.workerExecutor = executorService;
                this.bitmap$0 |= 4;
            }
            return this.workerExecutor;
        }
    }

    public void start() {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)new $anon$1(this));
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.factory());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipeline());
        Channel ch = bootstrap.bind(this.address);
        this.serverChannels().add(ch);
    }

    public void stop() {
        ChannelGroupFuture future = this.serverChannels().unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            NettyTransport$.MODULE$.warn((Function0<String>)new $anonfun$stop$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            JavaConversions$.MODULE$.asIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$2(this));
        }
        this.workerExecutor().shutdown();
        this.serverChannels().close().awaitUninterruptibly();
        future = this.acceptedChannels().close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            NettyTransport$.MODULE$.warn((Function0<String>)new $anonfun$stop$3(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            JavaConversions$.MODULE$.asIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$4(this));
        }
        this.pipeline().stop();
        NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$stop$5(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.factory().releaseExternalResources();
    }

    public NettyTransport(ProtocolServer server, ChannelDownstreamHandler encoder, SocketAddress address, int masterThreads, int workerThreads, int idleTimeout, String threadNamePrefix) {
        this.address = address;
        this.masterThreads = masterThreads;
        this.workerThreads = workerThreads;
        this.org$infinispan$server$core$transport$netty$NettyTransport$$threadNamePrefix = threadNamePrefix;
        this.serverChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Channels").toString());
        this.acceptedChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Accepted").toString());
        this.pipeline = new NettyChannelPipelineFactory(server, encoder, this, idleTimeout);
        this.factory = workerThreads == 0 ? new NioServerSocketChannelFactory((Executor)this.masterExecutor(), (Executor)this.workerExecutor()) : new NioServerSocketChannelFactory((Executor)this.masterExecutor(), (Executor)this.workerExecutor(), workerThreads);
    }
}

