/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer$;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.util.ClusterIdGenerator;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.TypedProperties;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001C\u0001\u0003\t\u0003\u0005\u0019\u0011A\u0006\u0003-\u0005\u00137\u000f\u001e:bGR\u0004&o\u001c;pG>d7+\u001a:wKJT!a\u0001\u0003\u0002\t\r|'/\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0004\u000b\u0019=A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tq\u0001K]8u_\u000e|GnU3sm\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0003\u0003\u001dawnZ4j]\u001eL!!\b\u000e\u0003\u00071{w\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bCA\u0014+\u001d\ty\u0002&\u0003\u0002*A\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tI\u0003\u0005C\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0003aE\u0002\"!\u0006\u0001\t\u000b\u0015j\u0003\u0019\u0001\u0014\t\u000fM\u0002\u0001\u0019!C\ti\u0005!\u0001n\\:u+\u00051\u0003b\u0002\u001c\u0001\u0001\u0004%\tbN\u0001\tQ>\u001cHo\u0018\u0013fcR\u0011\u0001h\u000f\t\u0003?eJ!A\u000f\u0011\u0003\tUs\u0017\u000e\u001e\u0005\byU\n\t\u00111\u0001'\u0003\rAH%\r\u0005\u0007}\u0001\u0001\u000b\u0015\u0002\u0014\u0002\u000b!|7\u000f\u001e\u0011\t\u000f\u0001\u0003\u0001\u0019!C\t\u0003\u0006!\u0001o\u001c:u+\u0005\u0011\u0005CA\u0010D\u0013\t!\u0005EA\u0002J]RDqA\u0012\u0001A\u0002\u0013Eq)\u0001\u0005q_J$x\fJ3r)\tA\u0004\nC\u0004=\u000b\u0006\u0005\t\u0019\u0001\"\t\r)\u0003\u0001\u0015)\u0003C\u0003\u0015\u0001xN\u001d;!\u0011\u001da\u0005\u00011A\u0005\u0012\u0005\u000bQb^8sW\u0016\u0014H\u000b\u001b:fC\u0012\u001c\bb\u0002(\u0001\u0001\u0004%\tbT\u0001\u0012o>\u00148.\u001a:UQJ,\u0017\rZ:`I\u0015\fHC\u0001\u001dQ\u0011\u001daT*!AA\u0002\tCaA\u0015\u0001!B\u0013\u0011\u0015AD<pe.,'\u000f\u00165sK\u0006$7\u000f\t\u0005\b)\u0002\u0001\r\u0011\"\u0005V\u0003%!(/\u00198ta>\u0014H/F\u0001W!\t9\u0016,D\u0001Y\u0015\t!&!\u0003\u0002[1\nqa*\u001a;usR\u0013\u0018M\\:q_J$\bb\u0002/\u0001\u0001\u0004%\t\"X\u0001\u000eiJ\fgn\u001d9peR|F%Z9\u0015\u0005ar\u0006b\u0002\u001f\\\u0003\u0003\u0005\rA\u0016\u0005\u0007A\u0002\u0001\u000b\u0015\u0002,\u0002\u0015Q\u0014\u0018M\\:q_J$\b\u0005C\u0004c\u0001\u0001\u0007I\u0011C2\u0002\u0019\r\f7\r[3NC:\fw-\u001a:\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0004\u0002\u000f5\fg.Y4fe&\u0011\u0011N\u001a\u0002\u0015\u000b6\u0014W\r\u001a3fI\u000e\u000b7\r[3NC:\fw-\u001a:\t\u000f-\u0004\u0001\u0019!C\tY\u0006\u00012-Y2iK6\u000bg.Y4fe~#S-\u001d\u000b\u0003q5Dq\u0001\u00106\u0002\u0002\u0003\u0007A\r\u0003\u0004p\u0001\u0001\u0006K\u0001Z\u0001\u000eG\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0011\t\u000fE\u0004\u0001\u0019!C\te\u0006\u0001b/\u001a:tS>tw)\u001a8fe\u0006$xN]\u000b\u0002gB\u0011Ao^\u0007\u0002k*\u0011aOB\u0001\u0005kRLG.\u0003\u0002yk\n\u00112\t\\;ti\u0016\u0014\u0018\nZ$f]\u0016\u0014\u0018\r^8s\u0011\u001dQ\b\u00011A\u0005\u0012m\fAC^3sg&|gnR3oKJ\fGo\u001c:`I\u0015\fHC\u0001\u001d}\u0011\u001da\u00140!AA\u0002MDaA \u0001!B\u0013\u0019\u0018!\u0005<feNLwN\\$f]\u0016\u0014\u0018\r^8sA!I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111A\u0001\u0011iJ\fgn\u001d9peR|%M\u001b(b[\u0016,\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005QQ.\u00198bO\u0016lWM\u001c;\u000b\u0005\u0005=\u0011!\u00026bm\u0006D\u0018\u0002BA\n\u0003\u0013\u0011!b\u00142kK\u000e$h*Y7f\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\"\u0001\u000bue\u0006t7\u000f]8si>\u0013'NT1nK~#S-\u001d\u000b\u0004q\u0005m\u0001\"\u0003\u001f\u0002\u0016\u0005\u0005\t\u0019AA\u0003\u0011!\ty\u0002\u0001Q!\n\u0005\u0015\u0011!\u0005;sC:\u001c\bo\u001c:u\u001f\nTg*Y7fA!I\u00111\u0005\u0001A\u0002\u0013%\u0011QE\u0001\f[\n,\u0017M\\*feZ,'/\u0006\u0002\u0002(A!\u0011qAA\u0015\u0013\u0011\tY#!\u0003\u0003\u00175\u0013U-\u00198TKJ4XM\u001d\u0005\n\u0003_\u0001\u0001\u0019!C\u0005\u0003c\tq\"\u001c2fC:\u001cVM\u001d<fe~#S-\u001d\u000b\u0004q\u0005M\u0002\"\u0003\u001f\u0002.\u0005\u0005\t\u0019AA\u0014\u0011!\t9\u0004\u0001Q!\n\u0005\u001d\u0012\u0001D7cK\u0006t7+\u001a:wKJ\u0004\u0003\"CA\u001e\u0001\u0001\u0007I\u0011BA\u001f\u0003QI7o\u00127pE\u0006d7\u000b^1ug\u0016s\u0017M\u00197fIV\u0011\u0011q\b\t\u0004?\u0005\u0005\u0013bAA\"A\t9!i\\8mK\u0006t\u0007\"CA$\u0001\u0001\u0007I\u0011BA%\u0003aI7o\u00127pE\u0006d7\u000b^1ug\u0016s\u0017M\u00197fI~#S-\u001d\u000b\u0004q\u0005-\u0003\"\u0003\u001f\u0002F\u0005\u0005\t\u0019AA \u0011!\ty\u0005\u0001Q!\n\u0005}\u0012!F5t\u000f2|'-\u00197Ti\u0006$8/\u00128bE2,G\r\t\u0005\b\u0003'\u0002A\u0011AA+\u0003\u0015\u0019H/\u0019:u)\u001dA\u0014qKA3\u0003OB\u0001\"!\u0017\u0002R\u0001\u0007\u00111L\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003BA/\u0003Cj!!a\u0018\u000b\u0005Y\u0004\u0012\u0002BA2\u0003?\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\u0011\u0017\u0011\u000ba\u0001I\"9\u0011\u0011NA)\u0001\u0004\u0011\u0015a\u00033fM\u0006,H\u000e\u001e)peRDq!!\u001c\u0001\t\u0003\ty'\u0001\bti\u0006\u0014H\u000f\u0016:b]N\u0004xN\u001d;\u0015\u0017a\n\t(!\u001e\u0002z\u0005u\u0014\u0011\u0011\u0005\b\u0003g\nY\u00071\u0001C\u0003-IG\r\\3US6,w.\u001e;\t\u0011\u0005]\u00141\u000ea\u0001\u0003\u007f\t!\u0002^2q\u001d>$U\r\\1z\u0011\u001d\tY(a\u001bA\u0002\t\u000b1b]3oI\n+hmU5{K\"9\u0011qPA6\u0001\u0004\u0011\u0015a\u0003:fGZ\u0014UOZ*ju\u0016D\u0001\"a!\u0002l\u0001\u0007\u0011QQ\u0001\u000bif\u0004X\r\u001a)s_B\u001c\bc\u0001;\u0002\b&\u0019\u0011\u0011R;\u0003\u001fQK\b/\u001a3Qe>\u0004XM\u001d;jKNDq!a\u0015\u0001\t\u0003\ti\tF\u00039\u0003\u001f\u000b\u0019\nC\u0004\u0002\u0012\u0006-\u0005\u0019\u0001\u0014\u0002%A\u0014x\u000e]3si&,7OR5mK:\u000bW.\u001a\u0005\u0007E\u0006-\u0005\u0019\u00013\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\u0006!1\u000f^8q+\u0005A\u0004BBAO\u0001\u0011\u00051-A\bhKR\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0011\u0019\t\t\u000b\u0001C\u0001i\u00059q-\u001a;I_N$\bBBAS\u0001\u0011\u0005\u0011)A\u0004hKR\u0004vN\u001d;\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006\t2\u000f^1si\u0012+g-Y;mi\u000e\u000b7\r[3\u0016\u0005\u00055\u0006\u0003CAX\u0003c\u000b),!.\u000e\u0003\u0019I1!a-\u0007\u0005\u0015\u0019\u0015m\u00195f!\ry\u0012qW\u0005\u0004\u0003s\u0003#a\u0002(pi\"Lgn\u001a")
public abstract class AbstractProtocolServer
implements ProtocolServer,
Log,
ScalaObject {
    private final String threadNamePrefix;
    private String host;
    private int port;
    private int workerThreads;
    private NettyTransport transport;
    private EmbeddedCacheManager cacheManager;
    private ClusterIdGenerator versionGenerator;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;
    private boolean isGlobalStatsEnabled;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final JavaLog org$infinispan$server$core$logging$Log$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$logging$Log$$log;
        AbstractProtocolServer abstractProtocolServer = this;
        synchronized (abstractProtocolServer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug(this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String string) {
        this.host = string;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int n) {
        this.port = n;
    }

    public int workerThreads() {
        return this.workerThreads;
    }

    public void workerThreads_$eq(int n) {
        this.workerThreads = n;
    }

    public NettyTransport transport() {
        return this.transport;
    }

    public void transport_$eq(NettyTransport nettyTransport) {
        this.transport = nettyTransport;
    }

    public EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    public void cacheManager_$eq(EmbeddedCacheManager embeddedCacheManager) {
        this.cacheManager = embeddedCacheManager;
    }

    public ClusterIdGenerator versionGenerator() {
        return this.versionGenerator;
    }

    public void versionGenerator_$eq(ClusterIdGenerator clusterIdGenerator) {
        this.versionGenerator = clusterIdGenerator;
    }

    private ObjectName transportObjName() {
        return this.transportObjName;
    }

    private void transportObjName_$eq(ObjectName objectName) {
        this.transportObjName = objectName;
    }

    private MBeanServer mbeanServer() {
        return this.mbeanServer;
    }

    private void mbeanServer_$eq(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    private boolean isGlobalStatsEnabled() {
        return this.isGlobalStatsEnabled;
    }

    private void isGlobalStatsEnabled_$eq(boolean bl) {
        this.isGlobalStatsEnabled = bl;
    }

    public void start(Properties properties, EmbeddedCacheManager cacheManager, int defaultPort) {
        TypedProperties typedProps = TypedProperties.toTypedProperties((Properties)properties);
        boolean toStart = typedProps.getBooleanProperty("enabled", true, true);
        if (toStart) {
            this.host_$eq(typedProps.getProperty(Main$.MODULE$.PROP_KEY_HOST(), Main$.MODULE$.HOST_DEFAULT(), true));
            this.port_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_PORT(), defaultPort, true));
            int masterThreads = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_MASTER_THREADS(), -1, true);
            if (masterThreads != -1) {
                this.logSettingMasterThreadsNotSupported();
            }
            this.workerThreads_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_WORKER_THREADS(), Main$.MODULE$.WORKER_THREADS_DEFAULT(), true));
            if (this.workerThreads() < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Worker threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)masterThreads)).toString());
            }
            this.cacheManager_$eq(cacheManager);
            this.isGlobalStatsEnabled_$eq(cacheManager.getGlobalConfiguration().isExposeGlobalJmxStatistics());
            int idleTimeout = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_IDLE_TIMEOUT(), Main$.MODULE$.IDLE_TIMEOUT_DEFAULT(), true);
            if (idleTimeout < -1) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Idle timeout can't be lower than -1: ").append((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
            }
            boolean tcpNoDelay = typedProps.getBooleanProperty(Main$.MODULE$.PROP_KEY_TCP_NO_DELAY(), Main$.MODULE$.TCP_NO_DELAY_DEFAULT(), true);
            int sendBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_SEND_BUF_SIZE(), Main$.MODULE$.SEND_BUF_SIZE_DEFAULT(), true);
            if (sendBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            int recvBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_RECV_BUF_SIZE(), Main$.MODULE$.RECV_BUF_SIZE_DEFAULT(), true);
            if (recvBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            if (this.isDebugEnabled()) {
                this.debugf((Function0<String>)new $anonfun$start$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.port()), BoxesRunTime.boxToInteger((int)masterThreads), BoxesRunTime.boxToInteger((int)this.workerThreads()), BoxesRunTime.boxToInteger((int)idleTimeout), BoxesRunTime.boxToBoolean((boolean)tcpNoDelay), BoxesRunTime.boxToInteger((int)sendBufSize), BoxesRunTime.boxToInteger((int)recvBufSize)}));
            }
            this.startDefaultCache();
            this.versionGenerator_$eq(new ClusterIdGenerator(cacheManager, cacheManager.getCache().getAdvancedCache().getRpcManager()));
            this.startTransport(idleTimeout, tcpNoDelay, sendBufSize, recvBufSize, typedProps);
        }
    }

    public void startTransport(int idleTimeout, boolean tcpNoDelay, int sendBufSize, int recvBufSize, TypedProperties typedProps) {
        InetSocketAddress address = new InetSocketAddress(this.host(), this.port());
        this.transport_$eq(new NettyTransport(this, (ChannelDownstreamHandler)this.getEncoder(), address, this.workerThreads(), idleTimeout, this.threadNamePrefix, tcpNoDelay, sendBufSize, recvBufSize, this.isGlobalStatsEnabled()));
        if (this.isGlobalStatsEnabled()) {
            GlobalConfiguration globalCfg = this.cacheManager().getGlobalConfiguration();
            this.mbeanServer_$eq(JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg));
            String groupName = Predef$.MODULE$.augmentString("type=Server,name=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.threadNamePrefix}));
            String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer(), (String)groupName);
            ResourceDMBean dynamicMBean = new ResourceDMBean((Object)this.transport());
            this.transportObjName_$eq(new ObjectName(Predef$.MODULE$.augmentString("%s:%s,component=Transport").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jmxDomain, groupName}))));
            JmxUtil.registerMBean((ResourceDMBean)dynamicMBean, (ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
        }
        this.transport().start();
    }

    @Override
    public void start(String propertiesFileName, EmbeddedCacheManager cacheManager) {
        TypedProperties propsObject = new TypedProperties();
        InputStream stream = FileLookupFactory.newInstance().lookupFile(propertiesFileName, Thread.currentThread().getContextClassLoader());
        propsObject.load(stream);
        this.start((Properties)propsObject, cacheManager);
    }

    @Override
    public void stop() {
        boolean isDebug = this.isDebugEnabled();
        if (isDebug) {
            this.debug((Function0<String>)new $anonfun$stop$1(this), this.host(), (Object)BoxesRunTime.boxToInteger((int)this.port()));
        }
        if (this.transport() != null) {
            this.transport().stop();
        }
        if (this.isGlobalStatsEnabled()) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
        }
        if (isDebug) {
            this.debug((Function0<String>)new $anonfun$stop$2(this));
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    public String getHost() {
        return this.host();
    }

    public int getPort() {
        return this.port();
    }

    public Cache<Nothing$, Nothing$> startDefaultCache() {
        return this.cacheManager().getCache();
    }

    public AbstractProtocolServer(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        Log$class.$init$(this);
    }
}

