/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.NettyChannelPipelineFactory;
import org.infinispan.server.core.transport.NettyTransport$;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.util.Util;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="Transport", description="Transport component manages read and write operations to/from server.")
@ScalaSignature(bytes="\u0006\u0001\t5f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0007\u0003\u001d9+G\u000f^=Ue\u0006t7\u000f]8si*\u00111\u0001B\u0001\niJ\fgn\u001d9peRT!!\u0002\u0004\u0002\t\r|'/\u001a\u0006\u0003\u000f!\taa]3sm\u0016\u0014(BA\u0005\u000b\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u0019!\ty\u0001#D\u0001\u0003\u0013\t\t\"AA\u0005Ue\u0006t7\u000f]8siB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\bY><w-\u001b8h\u0013\t9BCA\u0002M_\u001e\u0004\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u00111bU2bY\u0006|%M[3di\"Aq\u0001\u0001B\u0001B\u0003%q\u0004\u0005\u0002!C5\tA!\u0003\u0002#\t\tq\u0001K]8u_\u000e|GnU3sm\u0016\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u000f\u0015t7m\u001c3feB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\bG\"\fgN\\3m\u0015\tQ3&A\u0003oKR$\u0018P\u0003\u0002-\u0015\u0005)!NY8tg&\u0011af\n\u0002\u0019\u0007\"\fgN\\3m\t><hn\u001d;sK\u0006l\u0007*\u00198eY\u0016\u0014\b\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u000f\u0005$GM]3tgB\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0004]\u0016$(\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011!Q\u0004A!A!\u0002\u0013Y\u0014!D<pe.,'\u000f\u00165sK\u0006$7\u000f\u0005\u0002\u001ay%\u0011QH\u0007\u0002\u0004\u0013:$\b\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u0017%$G.\u001a+j[\u0016|W\u000f\u001e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0003\u0007\u001as!!\u0007#\n\u0005\u0015S\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\u000e\t\u0011)\u0003!\u0011!Q\u0001\n-\u000b!\u0002^2q\u001d>$U\r\\1z!\tIB*\u0003\u0002N5\t9!i\\8mK\u0006t\u0007\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u0017M,g\u000e\u001a\"vMNK'0\u001a\u0005\t#\u0002\u0011\t\u0011)A\u0005w\u0005Y!/Z2w\u0005V47+\u001b>f\u0011!\u0019\u0006A!A!\u0002\u0013Y\u0015\u0001F5t\u000f2|'-\u00197Ti\u0006$8/\u00128bE2,G\rC\u0003V\u0001\u0011\u0005a+\u0001\u0004=S:LGO\u0010\u000b\f/bK&l\u0017/^=~\u0003\u0017\r\u0005\u0002\u0010\u0001!)q\u0001\u0016a\u0001?!)A\u0005\u0016a\u0001K!)\u0001\u0007\u0016a\u0001c!)!\b\u0016a\u0001w!)q\b\u0016a\u0001w!)\u0011\t\u0016a\u0001\u0005\")!\n\u0016a\u0001\u0017\")q\n\u0016a\u0001w!)\u0011\u000b\u0016a\u0001w!)1\u000b\u0016a\u0001\u0017\"91\r\u0001b\u0001\n\u0013!\u0017AD:feZ,'o\u00115b]:,Gn]\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001nJ\u0001\u0006OJ|W\u000f]\u0005\u0003U\u001e\u00141\u0003R3gCVdGo\u00115b]:,Gn\u0012:pkBDa\u0001\u001c\u0001!\u0002\u0013)\u0017aD:feZ,'o\u00115b]:,Gn\u001d\u0011\t\u000f9\u0004!\u0019!C\u0001I\u0006\u0001\u0012mY2faR,Gm\u00115b]:,Gn\u001d\u0005\u0007a\u0002\u0001\u000b\u0011B3\u0002#\u0005\u001c7-\u001a9uK\u0012\u001c\u0005.\u00198oK2\u001c\b\u0005C\u0004s\u0001\t\u0007I\u0011B:\u0002\u0011AL\u0007/\u001a7j]\u0016,\u0012\u0001\u001e\t\u0003\u001fUL!A\u001e\u0002\u000379+G\u000f^=DQ\u0006tg.\u001a7QSB,G.\u001b8f\r\u0006\u001cGo\u001c:z\u0011\u0019A\b\u0001)A\u0005i\u0006I\u0001/\u001b9fY&tW\r\t\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u00039i\u0017m\u001d;fe\u0016CXmY;u_J,\u0012\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u00016\u0003\u0011)H/\u001b7\n\u0007\u0005\u001daPA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001d\tY\u0001\u0001Q\u0001\nq\fq\"\\1ti\u0016\u0014X\t_3dkR|'\u000f\t\u0005\t\u0003\u001f\u0001!\u0019!C\u0005w\u0006qqo\u001c:lKJ,\u00050Z2vi>\u0014\bbBA\n\u0001\u0001\u0006I\u0001`\u0001\u0010o>\u00148.\u001a:Fq\u0016\u001cW\u000f^8sA!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011D\u0001\bM\u0006\u001cGo\u001c:z+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u00079LwNC\u0002\u0002&\u001d\naa]8dW\u0016$\u0018\u0002BA\u0015\u0003?\u0011QDT5p'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\u001c$bGR|'/\u001f\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u001c\u0005Aa-Y2u_JL\b\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005\tBo\u001c;bY\nKH/Z:Xe&$H/\u001a8\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mb0\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003\u007f\tID\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD\u0001\"a\u0011\u0001A\u0003%\u0011QG\u0001\u0013i>$\u0018\r\u001c\"zi\u0016\u001cxK]5ui\u0016t\u0007\u0005C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u00024\u0005qAo\u001c;bY\nKH/Z:SK\u0006$\u0007\u0002CA&\u0001\u0001\u0006I!!\u000e\u0002\u001fQ|G/\u00197CsR,7OU3bI\u0002B\u0011\"a\u0014\u0001\u0005\u0004%I!a\r\u0002!U\u001cXM\u001d\"zi\u0016\u001cxK]5ui\u0016t\u0007\u0002CA*\u0001\u0001\u0006I!!\u000e\u0002#U\u001cXM\u001d\"zi\u0016\u001cxK]5ui\u0016t\u0007\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0003\u00024\u0005iQo]3s\u0005f$Xm\u001d*fC\u0012D\u0001\"a\u0017\u0001A\u0003%\u0011QG\u0001\u000fkN,'OQ=uKN\u0014V-\u00193!\u0011\u001d\ty\u0006\u0001C!\u0003C\nQa\u001d;beR,\"!a\u0019\u0011\u0007e\t)'C\u0002\u0002hi\u0011A!\u00168ji\"9\u00111\u000e\u0001\u0005\n\u00055\u0014\u0001E5t\u0019><GG[!wC&d\u0017M\u00197f)\u0005Y\u0005bBA9\u0001\u0011\u0005\u0013\u0011M\u0001\u0005gR|\u0007\u000fC\u0004\u0002v\u0001!\t!a\u001e\u0002)\u001d,G\u000fV8uC2\u0014\u0015\u0010^3t/JLG\u000f^3o+\u0005\u0011\u0005\u0006EA:\u0003w\n\u0019*!&\u0002\u001a\u0006m\u0015QUAT!\u0011\ti(a$\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000bQ!Y4f]RTA!!\"\u0002\b\u0006\t\u0002\u000f\\;hS:\feN\\8uCRLwN\\:\u000b\t\u0005%\u00151R\u0001\bQ\u0016d\u0007/\u001a:t\u0015\r\tiIC\u0001\u0004e\"\f\u0018\u0002BAI\u0003\u007f\u0012a!T3ue&\u001c\u0017a\u00033jgBd\u0017-\u001f(b[\u0016\f#!a&\u0002O9+XNY3sA=4\u0007\u0005^8uC2\u0004c.^7cKJ\u0004sN\u001a\u0011csR,7\u000fI<sSR$XM\\\u0001\u0010[\u0016\f7/\u001e:f[\u0016tG\u000fV=qK\u0012\u0012\u0011QT\u0005\u0005\u0003?\u000b\t+\u0001\u0005U%\u0016sEiU+Q\u0015\u0011\t\u0019+a \u0002\u001f5+\u0017m];sK6,g\u000e\u001e+za\u0016\f1\u0002Z5ta2\f\u0017\u0010V=qK\u0012\u0012\u0011\u0011V\u0005\u0005\u0003W\u000bi+A\u0004T+6k\u0015IU-\u000b\t\u0005=\u0016qP\u0001\f\t&\u001c\b\u000f\\1z)f\u0004X\r\u000b\u0005\u0002t\u0005M\u00161YAc!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b1\"\u00198o_R\fG/[8og*\u0019\u0011Q\u0018\u0005\u0002\u0007)l\u00070\u0003\u0003\u0002B\u0006]&\u0001E'b]\u0006<W\rZ!uiJL'-\u001e;f\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005\u001d\u0017A\u001f*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Co\u001c;bY\u0002rW/\u001c2fe\u0002zg\r\t2zi\u0016\u001c\be\u001e:jiR,g\u000e\t2zAQDW\rI:feZ,'\u000f\t2bG.\u0004Co\u001c\u0011dY&,g\u000e^:!o\"L7\r\u001b\u0011j]\u000edW\u000fZ3tA\t|G\u000f\u001b\u0011qe>$xnY8mA\u0005tG\rI;tKJ\u0004\u0013N\u001c4pe6\fG/[8o]!9\u00111\u001a\u0001\u0005\u0002\u0005]\u0014!E4fiR{G/\u00197CsR,7OU3bI\"\u0002\u0012\u0011ZA>\u0003'\u000by-!'\u0002\u001c\u0006\u0015\u0016qU\u0011\u0003\u0003#\fAET;nE\u0016\u0014\be\u001c4!i>$\u0018\r\u001c\u0011ok6\u0014WM\u001d\u0011pM\u0002\u0012\u0017\u0010^3tAI,\u0017\r\u001a\u0015\t\u0003\u0013\f\u0019,a1\u0002V\u0006\u0012\u0011q[\u0001u%\u0016$XO\u001d8tAQDW\r\t;pi\u0006d\u0007E\\;nE\u0016\u0014\be\u001c4!Ef$Xm\u001d\u0011sK\u0006$\u0007EY=!i\",\u0007e]3sm\u0016\u0014\bE\u001a:p[\u0002\u001aG.[3oiN\u0004s\u000f[5dQ\u0002Jgn\u00197vI\u0016\u001c\bEY8uQ\u0002\u0002(o\u001c;pG>d\u0007%\u00198eAU\u001cXM\u001d\u0011j]\u001a|'/\\1uS>tg\u0006C\u0004\u0002\\\u0002!\t!!8\u0002\u0017\u001d,G\u000fS8ti:\u000bW.Z\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003K,\u0014\u0001\u00027b]\u001eL1aRArQA\tI.a\u001f\u0002\u0014\u0006-\u0018q^Ay\u0003K\u000b9+\t\u0002\u0002n\u0006I\u0001j\\:uA9\fW.Z\u0001\tI\u0006$\u0018\rV=qK\u0012\u0012\u00111_\u0005\u0005\u0003k\f90A\u0003U%\u0006KEK\u0003\u0003\u0002z\u0006}\u0014\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0011\u0005e\u00171WAb\u0003{\f#!a@\u0002]I+G/\u001e:og\u0002\"\b.\u001a\u0011i_N$\b\u0005^8!o\"L7\r\u001b\u0011uQ\u0016\u0004CO]1ogB|'\u000f\u001e\u0011cS:$7O\f\u0005\b\u0005\u0007\u0001A\u0011AAo\u0003\u001d9W\r\u001e)peRD\u0003C!\u0001\u0002|\u0005M%qAAx\u0003c\f)+a*\"\u0005\t%\u0011\u0001\u0002)peRD\u0003B!\u0001\u00024\u0006\r'QB\u0011\u0003\u0005\u001f\taFU3ukJt7\u000f\t;iK\u0002\u0002xN\u001d;!i>\u0004s\u000f[5dQ\u0002\"\b.\u001a\u0011ue\u0006t7\u000f]8si\u0002\u0012\u0017N\u001c3t]!9!1\u0003\u0001\u0005\u0002\u0005u\u0017AF4fi:+XNY3s/>\u00148.\u001a:UQJ,\u0017\rZ:)!\tE\u00111PAJ\u0005/\ty/!=\u0002&\u0006\u001d\u0016E\u0001B\r\u0003aqU/\u001c2fe\u0002zg\rI<pe.,'\u000f\t;ie\u0016\fGm\u001d\u0015\t\u0005#\t\u0019,a1\u0003\u001e\u0005\u0012!qD\u0001&%\u0016$XO\u001d8tAQDW\r\t8v[\n,'\u000fI8gA]|'o[3sAQD'/Z1eg:BqAa\t\u0001\t\u0003\ti.\u0001\bhKRLE\r\\3US6,w.\u001e;)!\t\u0005\u00121PAJ\u0005O\ty/!=\u0002&\u0006\u001d\u0016E\u0001B\u0015\u00031IE\r\\3!i&lWm\\;uQ!\u0011\t#a-\u0002D\n5\u0012E\u0001B\u0018\u0003e\u0011V\r^;s]N\u0004C\u000f[3!S\u0012dW\r\t;j[\u0016|W\u000f\u001e\u0018\t\u000f\tM\u0002\u0001\"\u0001\u0002^\u0006iq-\u001a;Ua\u000etu\u000eR3mCfD\u0003C!\r\u0002|\u0005M%qGAx\u0003c\f)+a*\"\u0005\te\u0012\u0001\u0004+D!\u0002rw\u000e\t3fY\u0006L\b\u0006\u0003B\u0019\u0003g\u000b\u0019M!\u0010\"\u0005\t}\u0012a\r*fiV\u0014hn\u001d\u0011xQ\u0016$\b.\u001a:!)\u000e\u0003\u0006E\\8!I\u0016d\u0017-\u001f\u0011xCN\u00043m\u001c8gS\u001e,(/\u001a3!_J\u0004cn\u001c;/\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003;\f\u0011cZ3u'\u0016tGMQ;gM\u0016\u00148+\u001b>fQA\u0011\t%a\u001f\u0002\u0014\n\u001d\u0013q^Ay\u0003K\u000b9+\t\u0002\u0003J\u0005\u00012+\u001a8eA\t,hMZ3sAML'0\u001a\u0015\t\u0005\u0003\n\u0019,a1\u0003N\u0005\u0012!qJ\u0001\u001e%\u0016$XO\u001d8tAQDW\rI:f]\u0012\u0004#-\u001e4gKJ\u00043/\u001b>f]!9!1\u000b\u0001\u0005\u0002\u0005u\u0017\u0001F4fiJ+7-Z5wK\n+hMZ3s'&TX\r\u000b\t\u0003R\u0005m\u00141\u0013B,\u0003_\f\t0!*\u0002(\u0006\u0012!\u0011L\u0001\u0014%\u0016\u001cW-\u001b<fA\t,hMZ3sAML'0\u001a\u0015\t\u0005#\n\u0019,a1\u0003^\u0005\u0012!qL\u0001!%\u0016$XO\u001d8tAQDW\r\t:fG\u0016Lg/\u001a\u0011ck\u001a4WM\u001d\u0011tSj,g\u0006\u0003\u0005\u0003d\u0001!\t\u0001\u0002B3\u0003])\b\u000fZ1uKR{G/\u00197CsR,7o\u0016:jiR,g\u000e\u0006\u0003\u0003h\t5\u0004cA\r\u0003j%\u0019!1\u000e\u000e\u0003\r\u0005s\u0017PV1m\u0011!\u0011yG!\u0019A\u0002\tE\u0014!A3\u0011\u0007\u0019\u0012\u0019(C\u0002\u0003v\u001d\u0012Ac\u0016:ji\u0016\u001cu.\u001c9mKRLwN\\#wK:$\bb\u0002B=\u0001\u0011%!1P\u0001\u001bS:\u001c'/Z7f]R$v\u000e^1m\u0005f$Xm],sSR$XM\u001c\u000b\u0007\u0005O\u0012iH!!\t\u0011\t}$q\u000fa\u0001\u0003k\tAAY1tK\"A!q\u000eB<\u0001\u0004\u0011\t\b\u0003\u0005\u0003\u0006\u0002!\t\u0001\u0002BD\u0003Q)\b\u000fZ1uKR{G/\u00197CsR,7OU3bIR!!q\rBE\u0011!\u0011yGa!A\u0002\t-\u0005c\u0001\u0014\u0003\u000e&\u0019!qR\u0014\u0003\u00195+7o]1hK\u00163XM\u001c;\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\u00069\u0012N\\2sK6,g\u000e\u001e+pi\u0006d')\u001f;fgJ+\u0017\r\u001a\u000b\u0007\u0005O\u00129J!'\t\u0011\t}$\u0011\u0013a\u0001\u0003kA\u0001Ba\u001c\u0003\u0012\u0002\u0007!1\u0012\u0015\f\u0001\tu%1\u0015BS\u0003\u0007\u0014I\u000b\u0005\u0003\u00026\n}\u0015\u0002\u0002BQ\u0003o\u0013Q!\u0014\"fC:\f!b\u001c2kK\u000e$h*Y7fC\t\u00119+A\u0005Ue\u0006t7\u000f]8si\u0006\u0012!1V\u0001F)J\fgn\u001d9peR\u00043m\\7q_:,g\u000e\u001e\u0011nC:\fw-Z:!e\u0016\fG\rI1oI\u0002:(/\u001b;fA=\u0004XM]1uS>t7\u000f\t;p_\u0019\u0014x.\u001c\u0011tKJ4XM\u001d\u0018")
public class NettyTransport
extends Transport
implements Log,
ScalaObject {
    private final InetSocketAddress address;
    private final int workerThreads;
    private final int idleTimeout;
    public final String org$infinispan$server$core$transport$NettyTransport$$threadNamePrefix;
    private final boolean tcpNoDelay;
    private final int sendBufSize;
    private final int recvBufSize;
    private final boolean isGlobalStatsEnabled;
    private final DefaultChannelGroup serverChannels;
    private final DefaultChannelGroup acceptedChannels;
    private final NettyChannelPipelineFactory pipeline;
    private final ExecutorService masterExecutor;
    private final ExecutorService workerExecutor;
    private final NioServerSocketChannelFactory factory;
    private final AtomicLong totalBytesWritten;
    private final AtomicLong totalBytesRead;
    private final AtomicLong userBytesWritten;
    private final AtomicLong userBytesRead;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final JavaLog org$infinispan$server$core$logging$Log$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$logging$Log$$log;
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug(this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    private DefaultChannelGroup serverChannels() {
        return this.serverChannels;
    }

    public DefaultChannelGroup acceptedChannels() {
        return this.acceptedChannels;
    }

    private NettyChannelPipelineFactory pipeline() {
        return this.pipeline;
    }

    private ExecutorService masterExecutor() {
        return this.masterExecutor;
    }

    private ExecutorService workerExecutor() {
        return this.workerExecutor;
    }

    private NioServerSocketChannelFactory factory() {
        return this.factory;
    }

    private AtomicLong totalBytesWritten() {
        return this.totalBytesWritten;
    }

    private AtomicLong totalBytesRead() {
        return this.totalBytesRead;
    }

    private AtomicLong userBytesWritten() {
        return this.userBytesWritten;
    }

    private AtomicLong userBytesRead() {
        return this.userBytesRead;
    }

    @Override
    public void start() {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)new $anon$1(this));
        if (this.isLog4jAvailable()) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        }
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.factory());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipeline());
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.tcpNoDelay));
        if (this.sendBufSize > 0) {
            bootstrap.setOption("child.sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.sendBufSize));
        }
        if (this.recvBufSize > 0) {
            bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.recvBufSize));
        }
        Channel ch = bootstrap.bind((SocketAddress)this.address);
        this.serverChannels().add(ch);
    }

    private boolean isLog4jAvailable() {
        try {
            Util.loadClassStrict((String)"org.apache.log4j.Logger", (ClassLoader)Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public void stop() {
        ChannelGroupFuture future = this.serverChannels().unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            this.logServerDidNotUnbind();
            JavaConversions$.MODULE$.asScalaIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$1(this));
        }
        this.workerExecutor().shutdown();
        this.serverChannels().close().awaitUninterruptibly();
        future = this.acceptedChannels().close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            this.logServerDidNotClose();
            JavaConversions$.MODULE$.asScalaIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$2(this));
        }
        this.pipeline().stop();
        if (this.isDebugEnabled()) {
            this.debug((Function0<String>)new $anonfun$stop$3(this));
        }
        this.factory().releaseExternalResources();
    }

    @ManagedAttribute(description="Returns the total number of bytes written by the server back to clients which includes both protocol and user information.")
    @Metric(displayName="Number of total number of bytes written", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public String getTotalBytesWritten() {
        return this.totalBytesWritten().toString();
    }

    @ManagedAttribute(description="Returns the total number of bytes read by the server from clients which includes both protocol and user information.")
    @Metric(displayName="Number of total number of bytes read", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public String getTotalBytesRead() {
        return this.totalBytesRead().toString();
    }

    @ManagedAttribute(description="Returns the host to which the transport binds.")
    @Metric(displayName="Host name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getHostName() {
        return this.address.getHostName().toString();
    }

    @ManagedAttribute(description="Returns the port to which the transport binds.")
    @Metric(displayName="Port", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getPort() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.address.getPort())).toString();
    }

    @ManagedAttribute(description="Returns the number of worker threads.")
    @Metric(displayName="Number of worker threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getNumberWorkerThreads() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.workerThreads)).toString();
    }

    @ManagedAttribute(description="Returns the idle timeout.")
    @Metric(displayName="Idle timeout", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getIdleTimeout() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.idleTimeout)).toString();
    }

    @ManagedAttribute(description="Returns whether TCP no delay was configured or not.")
    @Metric(displayName="TCP no delay", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getTpcNoDelay() {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)this.tcpNoDelay)).toString();
    }

    @ManagedAttribute(description="Returns the send buffer size.")
    @Metric(displayName="Send buffer size", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getSendBufferSize() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.sendBufSize)).toString();
    }

    @ManagedAttribute(description="Returns the receive buffer size.")
    @Metric(displayName="Receive buffer size", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getReceiveBufferSize() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.recvBufSize)).toString();
    }

    public Object updateTotalBytesWritten(WriteCompletionEvent e) {
        return this.incrementTotalBytesWritten(this.totalBytesWritten(), e);
    }

    private Object incrementTotalBytesWritten(AtomicLong base, WriteCompletionEvent e) {
        return this.isGlobalStatsEnabled ? BoxesRunTime.boxToLong((long)base.addAndGet(e.getWrittenAmount())) : BoxedUnit.UNIT;
    }

    public Object updateTotalBytesRead(MessageEvent e) {
        return this.incrementTotalBytesRead(this.totalBytesRead(), e);
    }

    private Object incrementTotalBytesRead(AtomicLong base, MessageEvent e) {
        return this.isGlobalStatsEnabled ? BoxesRunTime.boxToLong((long)base.addAndGet(((ChannelBuffer)e.getMessage()).readableBytes())) : BoxedUnit.UNIT;
    }

    public NettyTransport(ProtocolServer server, ChannelDownstreamHandler encoder, InetSocketAddress address, int workerThreads, int idleTimeout, String threadNamePrefix, boolean tcpNoDelay, int sendBufSize, int recvBufSize, boolean isGlobalStatsEnabled) {
        this.address = address;
        this.workerThreads = workerThreads;
        this.idleTimeout = idleTimeout;
        this.org$infinispan$server$core$transport$NettyTransport$$threadNamePrefix = threadNamePrefix;
        this.tcpNoDelay = tcpNoDelay;
        this.sendBufSize = sendBufSize;
        this.recvBufSize = recvBufSize;
        this.isGlobalStatsEnabled = isGlobalStatsEnabled;
        Log$class.$init$(this);
        this.serverChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Channels").toString());
        this.acceptedChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Accepted").toString());
        this.pipeline = new NettyChannelPipelineFactory(server, encoder, this, idleTimeout);
        this.masterExecutor = Executors.newCachedThreadPool();
        this.workerExecutor = Executors.newCachedThreadPool();
        this.factory = new NioServerSocketChannelFactory((Executor)this.masterExecutor(), (Executor)this.workerExecutor(), workerThreads);
        this.totalBytesWritten = new AtomicLong();
        this.totalBytesRead = new AtomicLong();
        this.userBytesWritten = new AtomicLong();
        this.userBytesRead = new AtomicLong();
    }
}

