/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.LifecycleCallbacks$;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.util.ClusterIdGenerator;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.TypedProperties;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0003\u0003Y!AF!cgR\u0014\u0018m\u0019;Qe>$xnY8m'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011\u0001B2pe\u0016T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011!\u0002\u0004\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\bQe>$xnY8m'\u0016\u0014h/\u001a:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0011\u0011a\u00027pO\u001eLgnZ\u0005\u0003;i\u00111\u0001T8h\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\t\tsE\u0004\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014$\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\u0011QF\f\t\u0003+\u0001AQa\b\u0016A\u0002\u0001B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011C\u0019\u0002\t!|7\u000f^\u000b\u0002A!I1\u0007\u0001a\u0001\u0002\u0004%\t\u0002N\u0001\tQ>\u001cHo\u0018\u0013fcR\u0011Q\u0007\u000f\t\u0003EYJ!aN\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bsI\n\t\u00111\u0001!\u0003\rAH%\r\u0005\u0007w\u0001\u0001\u000b\u0015\u0002\u0011\u0002\u000b!|7\u000f\u001e\u0011\t\u0013u\u0002\u0001\u0019!a\u0001\n#q\u0014\u0001\u00029peR,\u0012a\u0010\t\u0003E\u0001K!!Q\u0012\u0003\u0007%sG\u000fC\u0005D\u0001\u0001\u0007\t\u0019!C\t\t\u0006A\u0001o\u001c:u?\u0012*\u0017\u000f\u0006\u00026\u000b\"9\u0011HQA\u0001\u0002\u0004y\u0004BB$\u0001A\u0003&q(A\u0003q_J$\b\u0005C\u0005J\u0001\u0001\u0007\t\u0019!C\t}\u0005iqo\u001c:lKJ$\u0006N]3bIND\u0011b\u0013\u0001A\u0002\u0003\u0007I\u0011\u0003'\u0002#]|'o[3s)\"\u0014X-\u00193t?\u0012*\u0017\u000f\u0006\u00026\u001b\"9\u0011HSA\u0001\u0002\u0004y\u0004BB(\u0001A\u0003&q(\u0001\bx_J\\WM\u001d+ie\u0016\fGm\u001d\u0011\t\u0013E\u0003\u0001\u0019!a\u0001\n#\u0011\u0016!\u0003;sC:\u001c\bo\u001c:u+\u0005\u0019\u0006C\u0001+W\u001b\u0005)&BA)\u0003\u0013\t9VK\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u0013e\u0003\u0001\u0019!a\u0001\n#Q\u0016!\u0004;sC:\u001c\bo\u001c:u?\u0012*\u0017\u000f\u0006\u000267\"9\u0011\bWA\u0001\u0002\u0004\u0019\u0006BB/\u0001A\u0003&1+\u0001\u0006ue\u0006t7\u000f]8si\u0002B\u0011b\u0018\u0001A\u0002\u0003\u0007I\u0011\u00031\u0002\u0019\r\f7\r[3NC:\fw-\u001a:\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0004\u0002\u000f5\fg.Y4fe&\u0011am\u0019\u0002\u0015\u000b6\u0014W\r\u001a3fI\u000e\u000b7\r[3NC:\fw-\u001a:\t\u0013!\u0004\u0001\u0019!a\u0001\n#I\u0017\u0001E2bG\",W*\u00198bO\u0016\u0014x\fJ3r)\t)$\u000eC\u0004:O\u0006\u0005\t\u0019A1\t\r1\u0004\u0001\u0015)\u0003b\u00035\u0019\u0017m\u00195f\u001b\u0006t\u0017mZ3sA!Ia\u000e\u0001a\u0001\u0002\u0004%\tb\\\u0001\u0011m\u0016\u00148/[8o\u000f\u0016tWM]1u_J,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\u001a\tA!\u001e;jY&\u0011QO\u001d\u0002\u0013\u00072,8\u000f^3s\u0013\u0012<UM\\3sCR|'\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\tq\u0006!b/\u001a:tS>tw)\u001a8fe\u0006$xN]0%KF$\"!N=\t\u000fe2\u0018\u0011!a\u0001a\"11\u0010\u0001Q!\nA\f\u0011C^3sg&|gnR3oKJ\fGo\u001c:!\u0011%i\b\u00011AA\u0002\u0013%a0\u0001\tue\u0006t7\u000f]8si>\u0013'NT1nKV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u00155\fg.Y4f[\u0016tGO\u0003\u0002\u0002\n\u0005)!.\u0019<bq&!\u0011QBA\u0002\u0005)y%M[3di:\u000bW.\u001a\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\"\u0001\u000bue\u0006t7\u000f]8si>\u0013'NT1nK~#S-\u001d\u000b\u0004k\u0005U\u0001\u0002C\u001d\u0002\u0010\u0005\u0005\t\u0019A@\t\u000f\u0005e\u0001\u0001)Q\u0005\u007f\u0006\tBO]1ogB|'\u000f^(cU:\u000bW.\u001a\u0011\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011qD\u0001\f[\n,\u0017M\\*feZ,'/\u0006\u0002\u0002\"A!\u0011\u0011AA\u0012\u0013\u0011\t)#a\u0001\u0003\u00175\u0013U-\u00198TKJ4XM\u001d\u0005\f\u0003S\u0001\u0001\u0019!a\u0001\n\u0013\tY#A\bnE\u0016\fgnU3sm\u0016\u0014x\fJ3r)\r)\u0014Q\u0006\u0005\ns\u0005\u001d\u0012\u0011!a\u0001\u0003CA\u0001\"!\r\u0001A\u0003&\u0011\u0011E\u0001\r[\n,\u0017M\\*feZ,'\u000f\t\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9$\u0001\u000bjg\u001ecwNY1m'R\fGo]#oC\ndW\rZ\u000b\u0003\u0003s\u00012AIA\u001e\u0013\r\tid\t\u0002\b\u0005>|G.Z1o\u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%I!a\u0011\u00021%\u001cx\t\\8cC2\u001cF/\u0019;t\u000b:\f'\r\\3e?\u0012*\u0017\u000fF\u00026\u0003\u000bB\u0011\"OA \u0003\u0003\u0005\r!!\u000f\t\u0011\u0005%\u0003\u0001)Q\u0005\u0003s\tQ#[:HY>\u0014\u0017\r\\*uCR\u001cXI\\1cY\u0016$\u0007\u0005C\u0004\u0002N\u0001!\t!a\u0014\u0002\u000bM$\u0018M\u001d;\u0015\u000fU\n\t&a\u0018\u0002b!A\u00111KA&\u0001\u0004\t)&\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!a\u0016\u0002\\5\u0011\u0011\u0011\f\u0006\u0003gBIA!!\u0018\u0002Z\tQ\u0001K]8qKJ$\u0018.Z:\t\r}\u000bY\u00051\u0001b\u0011\u001d\t\u0019'a\u0013A\u0002}\n1\u0002Z3gCVdG\u000fU8si\"9\u0011q\r\u0001\u0005\u0002\u0005%\u0014AD:uCJ$HK]1ogB|'\u000f\u001e\u000b\fk\u0005-\u0014qNA:\u0003o\nY\bC\u0004\u0002n\u0005\u0015\u0004\u0019A \u0002\u0017%$G.\u001a+j[\u0016|W\u000f\u001e\u0005\t\u0003c\n)\u00071\u0001\u0002:\u0005QAo\u00199O_\u0012+G.Y=\t\u000f\u0005U\u0014Q\ra\u0001\u007f\u0005Y1/\u001a8e\u0005V47+\u001b>f\u0011\u001d\tI(!\u001aA\u0002}\n1B]3dm\n+hmU5{K\"A\u0011QPA3\u0001\u0004\ty(\u0001\u0006usB,G\r\u0015:paN\u00042!]AA\u0013\r\t\u0019I\u001d\u0002\u0010)f\u0004X\r\u001a)s_B,'\u000f^5fg\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015A\u0006:fO&\u001cH/\u001a:Ue\u0006t7\u000f]8si6\u0013U-\u00198\u0015\u0003UBq!!\u0014\u0001\t\u0003\ti\tF\u00036\u0003\u001f\u000b\u0019\nC\u0004\u0002\u0012\u0006-\u0005\u0019\u0001\u0011\u0002%A\u0014x\u000e]3si&,7OR5mK:\u000bW.\u001a\u0005\u0007?\u0006-\u0005\u0019A1\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\u0006!1\u000f^8q+\u0005)\u0004BBAO\u0001\u0011\u0005\u0001-A\bhKR\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0011\u0019\t\t\u000b\u0001C\u0001c\u00059q-\u001a;I_N$\bBBAS\u0001\u0011\u0005a(A\u0004hKR\u0004vN\u001d;\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006\t2\u000f^1si\u0012+g-Y;mi\u000e\u000b7\r[3\u0016\u0005\u00055\u0006\u0003CAX\u0003c\u000b),!.\u000e\u0003\u0019I1!a-\u0007\u0005\u0015\u0019\u0015m\u00195f!\r\u0011\u0013qW\u0005\u0004\u0003s\u001b#AB!osJ+g\r")
public abstract class AbstractProtocolServer
implements ProtocolServer,
Log {
    private final String threadNamePrefix;
    private String host;
    private int port;
    private int workerThreads;
    private NettyTransport transport;
    private EmbeddedCacheManager cacheManager;
    private ClusterIdGenerator versionGenerator;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;
    private boolean isGlobalStatsEnabled;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        AbstractProtocolServer abstractProtocolServer = this;
        synchronized (abstractProtocolServer) {
            if (!this.bitmap$0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public JavaLog org$infinispan$server$core$logging$Log$$log() {
        return this.bitmap$0 ? this.org$infinispan$server$core$logging$Log$$log : this.org$infinispan$server$core$logging$Log$$log$lzycompute();
    }

    @Override
    public void info(Function0<String> msg) {
        Log$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Object param1) {
        Log$class.info(this, msg, param1);
    }

    @Override
    public void error(Function0<String> msg, Throwable t) {
        Log$class.error(this, msg, t);
    }

    @Override
    public void warn(Function0<String> msg, Throwable t) {
        Log$class.warn(this, msg, t);
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg) {
        Log$class.debug((Log)this, t, msg);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log$class.tracef(this, msg, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    @Override
    public void logErrorBeforeReadingRequest(Throwable t) {
        Log$class.logErrorBeforeReadingRequest(this, t);
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public int workerThreads() {
        return this.workerThreads;
    }

    public void workerThreads_$eq(int x$1) {
        this.workerThreads = x$1;
    }

    public NettyTransport transport() {
        return this.transport;
    }

    public void transport_$eq(NettyTransport x$1) {
        this.transport = x$1;
    }

    public EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    public void cacheManager_$eq(EmbeddedCacheManager x$1) {
        this.cacheManager = x$1;
    }

    public ClusterIdGenerator versionGenerator() {
        return this.versionGenerator;
    }

    public void versionGenerator_$eq(ClusterIdGenerator x$1) {
        this.versionGenerator = x$1;
    }

    private ObjectName transportObjName() {
        return this.transportObjName;
    }

    private void transportObjName_$eq(ObjectName x$1) {
        this.transportObjName = x$1;
    }

    private MBeanServer mbeanServer() {
        return this.mbeanServer;
    }

    private void mbeanServer_$eq(MBeanServer x$1) {
        this.mbeanServer = x$1;
    }

    private boolean isGlobalStatsEnabled() {
        return this.isGlobalStatsEnabled;
    }

    private void isGlobalStatsEnabled_$eq(boolean x$1) {
        this.isGlobalStatsEnabled = x$1;
    }

    public void start(Properties properties, EmbeddedCacheManager cacheManager, int defaultPort) {
        TypedProperties typedProps = TypedProperties.toTypedProperties((Properties)properties);
        boolean toStart = typedProps.getBooleanProperty("enabled", true, true);
        if (toStart) {
            this.host_$eq(typedProps.getProperty(Main$.MODULE$.PROP_KEY_HOST(), Main$.MODULE$.HOST_DEFAULT(), true));
            this.port_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_PORT(), defaultPort, true));
            int masterThreads = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_MASTER_THREADS(), -1, true);
            if (masterThreads != -1) {
                this.logSettingMasterThreadsNotSupported();
            }
            this.workerThreads_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_WORKER_THREADS(), Main$.MODULE$.WORKER_THREADS_DEFAULT(), true));
            if (this.workerThreads() < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Worker threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)this.workerThreads())).toString());
            }
            this.cacheManager_$eq(cacheManager);
            this.isGlobalStatsEnabled_$eq(cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
            int idleTimeout = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_IDLE_TIMEOUT(), Main$.MODULE$.IDLE_TIMEOUT_DEFAULT(), true);
            if (idleTimeout < -1) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Idle timeout can't be lower than -1: ").append((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
            }
            boolean tcpNoDelay = typedProps.getBooleanProperty(Main$.MODULE$.PROP_KEY_TCP_NO_DELAY(), Main$.MODULE$.TCP_NO_DELAY_DEFAULT(), true);
            int sendBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_SEND_BUF_SIZE(), Main$.MODULE$.SEND_BUF_SIZE_DEFAULT(), true);
            if (sendBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            int recvBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_RECV_BUF_SIZE(), Main$.MODULE$.RECV_BUF_SIZE_DEFAULT(), true);
            if (recvBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            if (this.isDebugEnabled()) {
                this.debugf((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting server with basic settings: host=%s, port=%d, masterThreads=%s, workerThreads=%d, idleTimeout=%d, tcpNoDelay=%b, sendBufSize=%d, recvBufSize=%d";
                    }
                }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.port()), BoxesRunTime.boxToInteger((int)masterThreads), BoxesRunTime.boxToInteger((int)this.workerThreads()), BoxesRunTime.boxToInteger((int)idleTimeout), BoxesRunTime.boxToBoolean((boolean)tcpNoDelay), BoxesRunTime.boxToInteger((int)sendBufSize), BoxesRunTime.boxToInteger((int)recvBufSize)}));
            }
            this.startDefaultCache();
            this.versionGenerator_$eq(new ClusterIdGenerator(cacheManager, cacheManager.getTransport()));
            this.startTransport(idleTimeout, tcpNoDelay, sendBufSize, recvBufSize, typedProps);
        }
    }

    public void startTransport(int idleTimeout, boolean tcpNoDelay, int sendBufSize, int recvBufSize, TypedProperties typedProps) {
        InetSocketAddress address = new InetSocketAddress(this.host(), this.port());
        this.transport_$eq(new NettyTransport(this, (ChannelDownstreamHandler)this.getEncoder(), address, this.workerThreads(), idleTimeout, this.threadNamePrefix, tcpNoDelay, sendBufSize, recvBufSize, this.cacheManager()));
        this.registerTransportMBean();
        this.transport().start();
    }

    private void registerTransportMBean() {
        GlobalConfiguration globalCfg = this.cacheManager().getCacheManagerConfiguration();
        this.mbeanServer_$eq(JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg));
        String groupName = new StringOps(Predef$.MODULE$.augmentString("type=Server,name=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.threadNamePrefix}));
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer(), (String)groupName);
        ManageableComponentMetadata meta = LifecycleCallbacks$.MODULE$.componentMetadataRepo().findComponentMetadata(this.transport().getClass()).toManageableComponentMetadata();
        ResourceDMBean dynamicMBean = new ResourceDMBean((Object)this.transport(), meta);
        this.transportObjName_$eq(new ObjectName(new StringOps(Predef$.MODULE$.augmentString("%s:%s,component=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jmxDomain, groupName, meta.getJmxObjectName()}))));
        JmxUtil.registerMBean((Object)dynamicMBean, (ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
    }

    @Override
    public void start(String propertiesFileName, EmbeddedCacheManager cacheManager) {
        TypedProperties propsObject = new TypedProperties();
        if (propertiesFileName != null) {
            InputStream stream = FileLookupFactory.newInstance().lookupFile(propertiesFileName, Thread.currentThread().getContextClassLoader());
            propsObject.load(stream);
        }
        this.start((Properties)propsObject, cacheManager);
    }

    @Override
    public void stop() {
        boolean isDebug = this.isDebugEnabled();
        if (isDebug) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping server listening in %s:%d";
                }
            }, this.host(), (Object)BoxesRunTime.boxToInteger((int)this.port()));
        }
        if (this.transport() != null) {
            this.transport().stop();
        }
        if (this.mbeanServer() != null && this.transportObjName() != null) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
        }
        if (isDebug) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Server stopped";
                }
            });
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    public String getHost() {
        return this.host();
    }

    public int getPort() {
        return this.port();
    }

    public Cache<Object, Object> startDefaultCache() {
        return this.cacheManager().getCache();
    }

    public AbstractProtocolServer(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        Log$class.$init$(this);
    }
}

