/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.LifecycleCallbacks$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.LifecycleChannelPipelineFactory;
import org.infinispan.server.core.transport.NettyChannelPipelineFactory;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.TimeoutEnabledChannelPipelineFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0001\u0003\u0003\u0003Y!AF!cgR\u0014\u0018m\u0019;Qe>$xnY8m'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011\u0001B2pe\u0016T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0011b\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a\u0002\u0015:pi>\u001cw\u000e\\*feZ,'\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0005\u00059An\\4hS:<\u0017BA\u000e\u0019\u0005\raun\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005a\u0001O]8u_\u000e|GNT1nKB\u0011qD\t\b\u0003\u001b\u0001J!!\t\b\u0002\rA\u0013X\rZ3g\u0013\t\u0019CE\u0001\u0004TiJLgn\u001a\u0006\u0003C9AQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDC\u0001\u0015*!\t\u0019\u0002\u0001C\u0003\u001eK\u0001\u0007a\u0004C\u0005,\u0001\u0001\u0007\t\u0019!C\tY\u0005IAO]1ogB|'\u000f^\u000b\u0002[A\u0011a\u0006M\u0007\u0002_)\u00111FA\u0005\u0003c=\u0012aBT3uif$&/\u00198ta>\u0014H\u000fC\u00054\u0001\u0001\u0007\t\u0019!C\ti\u0005iAO]1ogB|'\u000f^0%KF$\"!\u000e\u001d\u0011\u000551\u0014BA\u001c\u000f\u0005\u0011)f.\u001b;\t\u000fe\u0012\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u0003.\u0003)!(/\u00198ta>\u0014H\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0012y\nAbY1dQ\u0016l\u0015M\\1hKJ,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001a\tq!\\1oC\u001e,'/\u0003\u0002E\u0003\n!R)\u001c2fI\u0012,GmQ1dQ\u0016l\u0015M\\1hKJD\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011C$\u0002!\r\f7\r[3NC:\fw-\u001a:`I\u0015\fHCA\u001bI\u0011\u001dIT)!AA\u0002}BaA\u0013\u0001!B\u0013y\u0014!D2bG\",W*\u00198bO\u0016\u0014\b\u0005C\u0004M\u0001\u0001\u0007I\u0011C'\u0002\u001b\r|gNZ5hkJ\fG/[8o+\u0005q\u0005CA(Q\u001b\u0005\u0001\u0011BA)\u0015\u0005U\u0019V/\u001b;bE2,7i\u001c8gS\u001e,(/\u0019;j_:Dqa\u0015\u0001A\u0002\u0013EA+A\td_:4\u0017nZ;sCRLwN\\0%KF$\"!N+\t\u000fe\u0012\u0016\u0011!a\u0001\u001d\"1q\u000b\u0001Q!\n9\u000babY8oM&<WO]1uS>t\u0007\u0005C\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\u0006\u0001BO]1ogB|'\u000f^(cU:\u000bW.Z\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u000b[\u0006t\u0017mZ3nK:$(\"\u00011\u0002\u000b)\fg/\u0019=\n\u0005\tl&AC(cU\u0016\u001cGOT1nK\"IA\r\u0001a\u0001\u0002\u0004%I!Z\u0001\u0015iJ\fgn\u001d9peR|%M\u001b(b[\u0016|F%Z9\u0015\u0005U2\u0007bB\u001dd\u0003\u0003\u0005\ra\u0017\u0005\u0007Q\u0002\u0001\u000b\u0015B.\u0002#Q\u0014\u0018M\\:q_J$xJ\u00196OC6,\u0007\u0005C\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\u0006YQNY3b]N+'O^3s+\u0005a\u0007C\u0001/n\u0013\tqWLA\u0006N\u0005\u0016\fgnU3sm\u0016\u0014\b\"\u00039\u0001\u0001\u0004\u0005\r\u0011\"\u0003r\u0003=i'-Z1o'\u0016\u0014h/\u001a:`I\u0015\fHCA\u001bs\u0011\u001dIt.!AA\u00021Da\u0001\u001e\u0001!B\u0013a\u0017\u0001D7cK\u0006t7+\u001a:wKJ\u0004\u0003\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0003QI7o\u00127pE\u0006d7\u000b^1ug\u0016s\u0017M\u00197fIV\t\u0001\u0010\u0005\u0002\u000es&\u0011!P\u0004\u0002\b\u0005>|G.Z1o\u0011%a\b\u00011AA\u0002\u0013%Q0\u0001\rjg\u001ecwNY1m'R\fGo]#oC\ndW\rZ0%KF$\"!\u000e@\t\u000feZ\u0018\u0011!a\u0001q\"9\u0011\u0011\u0001\u0001!B\u0013A\u0018!F5t\u000f2|'-\u00197Ti\u0006$8/\u00128bE2,G\r\t\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003\u0015\u0019H/\u0019:u)\u0015)\u0014\u0011BA\u0006\u0011\u0019a\u00151\u0001a\u0001\u001d\"1Q(a\u0001A\u0002}Bq!a\u0004\u0001\t\u0003\t\t\"\u0001\bti\u0006\u0014H\u000f\u0016:b]N\u0004xN\u001d;\u0015\u0003UBq!!\u0006\u0001\t\u0003\n9\"A\u0006hKR\u0004\u0016\u000e]3mS:,WCAA\r!\rq\u00131D\u0005\u0004\u0003;y#a\b'jM\u0016\u001c\u0017p\u00197f\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u001a\u000b7\r^8ss\"9\u0011\u0011\u0005\u0001\u0005\u0012\u0005E\u0011A\u0006:fO&\u001cH/\u001a:Ue\u0006t7\u000f]8si6\u0013U-\u00198\t\u000f\u0005\u0015\u0002\u0001\"\u0005\u0002\u0012\u0005ARO\u001c:fO&\u001cH/\u001a:Ue\u0006t7\u000f]8si6\u0013U-\u00198\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\u0005\u0001r-\u001a;Rk\u0006d\u0017NZ5fI:\u000bW.\u001a\u000b\u0002=!9\u0011q\u0006\u0001\u0005B\u0005E\u0012\u0001B:u_B,\u0012!\u000e\u0005\u0007\u0003k\u0001A\u0011\u0001 \u0002\u001f\u001d,GoQ1dQ\u0016l\u0015M\\1hKJDa!!\u000f\u0001\t\u0003i\u0015\u0001E4fi\u000e{gNZ5hkJ\fG/[8o\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\tqaZ3u\u0011>\u001cH/\u0006\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00027b]\u001eT!!a\u0013\u0002\t)\fg/Y\u0005\u0004G\u0005\u0015\u0003bBA)\u0001\u0011\u0005\u00111K\u0001\bO\u0016$\bk\u001c:u+\t\t)\u0006E\u0002\u000e\u0003/J1!!\u0017\u000f\u0005\rIe\u000e\u001e\u0005\b\u0003;\u0002A\u0011AA0\u0003E\u0019H/\u0019:u\t\u00164\u0017-\u001e7u\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003C\u0002b!a\u0019\u0002f1aQ\"\u0001\u0004\n\u0007\u0005\u001ddAA\u0003DC\u000eDW\r")
public abstract class AbstractProtocolServer
implements ProtocolServer,
Log {
    private final String protocolName;
    private NettyTransport transport;
    private EmbeddedCacheManager cacheManager;
    private ProtocolServerConfiguration configuration;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;
    private boolean isGlobalStatsEnabled;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        AbstractProtocolServer abstractProtocolServer = this;
        synchronized (abstractProtocolServer) {
            if (!this.bitmap$0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public JavaLog org$infinispan$server$core$logging$Log$$log() {
        return this.bitmap$0 ? this.org$infinispan$server$core$logging$Log$$log : this.org$infinispan$server$core$logging$Log$$log$lzycompute();
    }

    @Override
    public void info(Function0<String> msg) {
        Log$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Object param1) {
        Log$class.info(this, msg, param1);
    }

    @Override
    public void error(Function0<String> msg, Throwable t) {
        Log$class.error(this, msg, t);
    }

    @Override
    public void warn(Function0<String> msg, Throwable t) {
        Log$class.warn(this, msg, t);
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg) {
        Log$class.debug((Log)this, t, msg);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log$class.tracef(this, msg, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    @Override
    public void logErrorBeforeReadingRequest(Throwable t) {
        Log$class.logErrorBeforeReadingRequest(this, t);
    }

    public NettyTransport transport() {
        return this.transport;
    }

    public void transport_$eq(NettyTransport x$1) {
        this.transport = x$1;
    }

    public EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    public void cacheManager_$eq(EmbeddedCacheManager x$1) {
        this.cacheManager = x$1;
    }

    public ProtocolServerConfiguration configuration() {
        return this.configuration;
    }

    public void configuration_$eq(ProtocolServerConfiguration x$1) {
        this.configuration = x$1;
    }

    private ObjectName transportObjName() {
        return this.transportObjName;
    }

    private void transportObjName_$eq(ObjectName x$1) {
        this.transportObjName = x$1;
    }

    private MBeanServer mbeanServer() {
        return this.mbeanServer;
    }

    private void mbeanServer_$eq(MBeanServer x$1) {
        this.mbeanServer = x$1;
    }

    private boolean isGlobalStatsEnabled() {
        return this.isGlobalStatsEnabled;
    }

    private void isGlobalStatsEnabled_$eq(boolean x$1) {
        this.isGlobalStatsEnabled = x$1;
    }

    @Override
    public void start(ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        this.configuration_$eq(configuration);
        this.cacheManager_$eq(cacheManager);
        this.isGlobalStatsEnabled_$eq(cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
        if (this.isDebugEnabled()) {
            this.debugf((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting server with configuration: %s";
                }
            }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration}));
        }
        this.startDefaultCache();
        this.startTransport();
    }

    public void startTransport() {
        InetSocketAddress address = new InetSocketAddress(this.configuration().host(), this.configuration().port());
        this.transport_$eq(new NettyTransport(this, this.getPipeline(), address, this.configuration(), this.getQualifiedName(), this.cacheManager()));
        this.registerTransportMBean();
        this.transport().start();
    }

    @Override
    public LifecycleChannelPipelineFactory getPipeline() {
        return this.configuration().idleTimeout() > 0 ? new TimeoutEnabledChannelPipelineFactory(this, (ChannelDownstreamHandler)this.getEncoder()) : new NettyChannelPipelineFactory(this, (ChannelDownstreamHandler)this.getEncoder());
    }

    public void registerTransportMBean() {
        GlobalConfiguration globalCfg = this.cacheManager().getCacheManagerConfiguration();
        this.mbeanServer_$eq(JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg));
        String groupName = new StringOps(Predef$.MODULE$.augmentString("type=Server,name=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getQualifiedName()}));
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer(), (String)groupName);
        ManageableComponentMetadata meta = LifecycleCallbacks$.MODULE$.componentMetadataRepo().findComponentMetadata(this.transport().getClass()).toManageableComponentMetadata();
        ResourceDMBean dynamicMBean = new ResourceDMBean((Object)this.transport(), meta);
        this.transportObjName_$eq(new ObjectName(new StringOps(Predef$.MODULE$.augmentString("%s:%s,component=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jmxDomain, groupName, meta.getJmxObjectName()}))));
        JmxUtil.registerMBean((Object)dynamicMBean, (ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
    }

    public void unregisterTransportMBean() {
        if (this.mbeanServer() != null && this.transportObjName() != null) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName(), (MBeanServer)this.mbeanServer());
        }
    }

    private String getQualifiedName() {
        return new StringBuilder().append((Object)this.protocolName).append((Object)(this.configuration().name().length() > 0 ? "-" : "")).append((Object)this.configuration().name()).toString();
    }

    @Override
    public void stop() {
        boolean isDebug = this.isDebugEnabled();
        if (isDebug && this.configuration() != null) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping server listening in %s:%d";
                }
            }, this.configuration().host(), (Object)BoxesRunTime.boxToInteger((int)this.configuration().port()));
        }
        if (this.transport() != null) {
            this.transport().stop();
        }
        this.unregisterTransportMBean();
        if (isDebug) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Server stopped";
                }
            });
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    @Override
    public ProtocolServerConfiguration getConfiguration() {
        return this.configuration();
    }

    public String getHost() {
        return this.configuration().host();
    }

    public int getPort() {
        return this.configuration().port();
    }

    public Cache<Object, Object> startDefaultCache() {
        return this.cacheManager().getCache();
    }

    public AbstractProtocolServer(String protocolName) {
        this.protocolName = protocolName;
        Log$class.$init$(this);
        this.configuration = null;
    }
}

