/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.transport.LifecycleChannelPipelineFactory;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\tYb*\u001a;us\u000eC\u0017M\u001c8fYBK\u0007/\u001a7j]\u00164\u0015m\u0019;pefT!a\u0001\u0003\u0002\u0013Q\u0014\u0018M\\:q_J$(BA\u0003\u0007\u0003\u0011\u0019wN]3\u000b\u0005\u001dA\u0011AB:feZ,'O\u0003\u0002\n\u0015\u0005Q\u0011N\u001c4j]&\u001c\b/\u00198\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!a\b'jM\u0016\u001c\u0017p\u00197f\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u001a\u000b7\r^8ss\"Aq\u0001\u0001B\u0001B\u0003%1\u0003\u0005\u0002\u0015+5\tA!\u0003\u0002\u0017\t\tq\u0001K]8u_\u000e|GnU3sm\u0016\u0014\b\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u000f\u0015t7m\u001c3feB\u0011!$I\u0007\u00027)\u0011A$H\u0001\bG\"\fgN\\3m\u0015\tqr$A\u0003oKR$\u0018P\u0003\u0002!\u0015\u0005)!NY8tg&\u0011!e\u0007\u0002\u0019\u0007\"\fgN\\3m\t><hn\u001d;sK\u0006l\u0007*\u00198eY\u0016\u0014\b\"\u0002\u0013\u0001\t\u0003)\u0013A\u0002\u001fj]&$h\bF\u0002'O!\u0002\"a\u0004\u0001\t\u000b\u001d\u0019\u0003\u0019A\n\t\u000ba\u0019\u0003\u0019A\r\t\u000b)\u0002A\u0011I\u0016\u0002\u0017\u001d,G\u000fU5qK2Lg.\u001a\u000b\u0002YA\u0011!$L\u0005\u0003]m\u0011qb\u00115b]:,G\u000eU5qK2Lg.\u001a\u0005\u0006a\u0001!\t%M\u0001\u0005gR|\u0007\u000fF\u00013!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0011)f.\u001b;\t\u000be\u0002A\u0011\u0001\u001e\u0002\u001f\r\u0014X-\u0019;f'NdWI\\4j]\u0016$\"aO#\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014aA:tY*\u0011\u0001)Q\u0001\u0004]\u0016$(\"\u0001\"\u0002\u000b)\fg/\u0019=\n\u0005\u0011k$!C*T\u0019\u0016sw-\u001b8f\u0011\u0015q\u0004\b1\u0001G!\t9%*D\u0001I\u0015\tIE!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003\u0017\"\u0013\u0001cU:m\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public class NettyChannelPipelineFactory
extends LifecycleChannelPipelineFactory {
    private final ProtocolServer server;
    private final ChannelDownstreamHandler encoder;

    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        SslConfiguration ssl = this.server.getConfiguration().ssl();
        if (ssl.enabled()) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.createSslEngine(ssl)));
        }
        pipeline.addLast("decoder", this.server.getDecoder());
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
        return pipeline;
    }

    @Override
    public void stop() {
    }

    public SSLEngine createSslEngine(SslConfiguration ssl) {
        SSLContext sslContext = ssl.sslContext() == null ? SslContextFactory.getContext((String)ssl.keyStoreFileName(), (char[])ssl.keyStorePassword(), (String)ssl.trustStoreFileName(), (char[])ssl.trustStorePassword()) : ssl.sslContext();
        return SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (boolean)ssl.requireClientAuth());
    }

    public NettyChannelPipelineFactory(ProtocolServer server, ChannelDownstreamHandler encoder) {
        this.server = server;
        this.encoder = encoder;
    }
}

