/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;

public class InetAddressPrincipal
implements Principal {
    private final InetAddress address;

    public InetAddressPrincipal(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        try {
            this.address = InetAddress.getByAddress(address.getHostAddress(), address.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        return this.address.getHostAddress();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressPrincipal other = (InetAddressPrincipal)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    @Override
    public String toString() {
        return "InetAddressPrincipal [address=" + this.address + "]";
    }
}

