/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security.simple;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.infinispan.server.core.security.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.SubjectUserInfo;
import org.infinispan.server.core.security.simple.SimpleGroupPrincipal;
import org.infinispan.server.core.security.simple.SimpleSubjectUserInfo;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;

public final class SimpleServerAuthenticationProvider
implements ServerAuthenticationProvider {
    private final Map<String, Map<String, Entry>> map = new HashMap<String, Map<String, Entry>>();

    @Override
    public AuthorizingCallbackHandler getCallbackHandler(String mechanismName, Map<String, String> mechanismProperties) {
        return new AuthorizingCallbackHandler(){
            Subject subject = new Subject();
            Principal userPrincipal;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                String userName = null;
                String realmName = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        String defaultName = nameCallback.getDefaultName();
                        userName = defaultName.toLowerCase().trim();
                        nameCallback.setName(userName);
                        this.userPrincipal = new SimpleUserPrincipal(userName);
                        this.subject.getPrincipals().add(this.userPrincipal);
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        RealmCallback realmCallback = (RealmCallback)callback;
                        String defaultRealm = realmCallback.getDefaultText();
                        if (defaultRealm == null) continue;
                        realmName = defaultRealm.toLowerCase().trim();
                        realmCallback.setText(realmName);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        String[] stringArray;
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        Entry entry = null;
                        if (realmName == null) {
                            stringArray = SimpleServerAuthenticationProvider.this.map;
                            synchronized (stringArray) {
                                for (Map realmMap : SimpleServerAuthenticationProvider.this.map.values()) {
                                    if (!realmMap.containsKey(userName)) continue;
                                    entry = (Entry)realmMap.get(userName);
                                    break;
                                }
                            }
                        }
                        stringArray = SimpleServerAuthenticationProvider.this.map;
                        synchronized (stringArray) {
                            Map realmMap = (Map)SimpleServerAuthenticationProvider.this.map.get(realmName);
                            if (realmMap != null) {
                                entry = (Entry)realmMap.get(userName);
                            }
                        }
                        if (entry == null) {
                            throw new AuthenticationException("No matching user found");
                        }
                        for (String group : entry.getGroups()) {
                            this.subject.getPrincipals().add((Principal)((Object)new SimpleGroupPrincipal(group)));
                        }
                        passwordCallback.setPassword(entry.getPassword());
                        continue;
                    }
                    if (callback instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Callback not supported: " + callback);
                }
            }

            @Override
            public SubjectUserInfo getSubjectUserInfo(Collection<Principal> principals) {
                if (principals != null) {
                    this.subject.getPrincipals().addAll(principals);
                }
                return new SimpleSubjectUserInfo(this.userPrincipal.getName(), this.subject);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userName, String userRealm, char[] password, String ... groups) {
        if (userName == null) {
            throw new IllegalArgumentException("userName is null");
        }
        if (userRealm == null) {
            throw new IllegalArgumentException("userRealm is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        String canonUserRealm = userRealm.toLowerCase().trim();
        String canonUserName = userName.toLowerCase().trim();
        Map<String, Map<String, Entry>> map = this.map;
        synchronized (map) {
            Map<String, Entry> realmMap = this.map.get(canonUserRealm);
            if (realmMap == null) {
                realmMap = new HashMap<String, Entry>();
                this.map.put(canonUserRealm, realmMap);
            }
            realmMap.put(canonUserName, new Entry(canonUserName, canonUserRealm, password, groups != null ? groups : new String[]{}));
        }
    }

    private static final class Entry {
        private final String userName;
        private final String userRealm;
        private final char[] password;
        private final String[] groups;

        private Entry(String userName, String userRealm, char[] password, String[] groups) {
            this.userName = userName;
            this.userRealm = userRealm;
            this.password = password;
            this.groups = groups;
        }

        String getUserName() {
            return this.userName;
        }

        String getUserRealm() {
            return this.userRealm;
        }

        char[] getPassword() {
            return this.password;
        }

        String[] getGroups() {
            return this.groups;
        }
    }
}

