/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.util.DomainNameMappingBuilder;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;
import org.infinispan.server.core.utils.SslUtils;

public class NettyChannelInitializer<A extends ProtocolServerConfiguration>
implements NettyInitializer {
    protected final ProtocolServer<A> server;
    protected final NettyTransport transport;
    protected final ChannelOutboundHandler encoder;

    public NettyChannelInitializer(ProtocolServer<A> server, NettyTransport transport, ChannelOutboundHandler encoder) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
    }

    @Override
    public void initializeChannel(Channel ch) throws Exception {
        SslConfiguration ssl;
        ChannelPipeline pipeline = ch.pipeline();
        if (this.transport != null) {
            pipeline.addLast("stats", (ChannelHandler)new StatsChannelHandler(this.transport));
        }
        if ((ssl = ((ProtocolServerConfiguration)this.server.getConfiguration()).ssl()).enabled()) {
            JdkSslContext defaultNettySslContext = SslUtils.createNettySslContext(ssl, ssl.sniDomainsConfiguration().get("*"));
            DomainNameMappingBuilder domainMappingBuilder = new DomainNameMappingBuilder((Object)defaultNettySslContext);
            ssl.sniDomainsConfiguration().forEach((k, v) -> {
                if (!"*".equals(k)) {
                    domainMappingBuilder.add(k, (Object)SslUtils.createNettySslContext(ssl, v));
                }
            });
            pipeline.addLast("sni", (ChannelHandler)new SniHandler(domainMappingBuilder.build()));
        }
        pipeline.addLast("decoder", (ChannelHandler)this.server.getDecoder());
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }
}

