/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ALPNHackSSLEngine;
import java.io.ByteArrayOutputStream;
import javax.net.ssl.SSLEngine;

class ALPNHackClientByteArrayOutputStream
extends ByteArrayOutputStream {
    private final SSLEngine sslEngine;
    private boolean ready = true;
    private byte[] receivedServerHello;
    private byte[] sentClientHello;

    ALPNHackClientByteArrayOutputStream(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.ready && b[off] == 2) {
            byte[] newData;
            this.ready = false;
            if (this.receivedServerHello != null) {
                byte b1 = b[off + 1];
                byte b2 = b[off + 2];
                byte b3 = b[off + 3];
                int length = (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
                if (length + 4 == len) {
                    newData = this.receivedServerHello;
                } else {
                    newData = new byte[this.receivedServerHello.length + len - 4 - length];
                    System.arraycopy(this.receivedServerHello, 0, newData, 0, this.receivedServerHello.length);
                    System.arraycopy(b, length + 4, newData, this.receivedServerHello.length, len - 4 - length);
                }
            } else {
                newData = new byte[len];
                System.arraycopy(b, off, newData, 0, len);
            }
            ALPNHackSSLEngine.regenerateHashes(this.sslEngine, this, this.sentClientHello, newData);
            return;
        }
        super.write(b, off, len);
    }

    byte[] getSentClientHello() {
        return this.sentClientHello;
    }

    void setSentClientHello(byte[] sentClientHello) {
        this.sentClientHello = sentClientHello;
    }

    byte[] getReceivedServerHello() {
        return this.receivedServerHello;
    }

    void setReceivedServerHello(byte[] receivedServerHello) {
        this.receivedServerHello = receivedServerHello;
    }
}

