/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.io.Serializable;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.core.admin.AdminServerTask;
import org.infinispan.util.function.SerializableFunction;

public class CacheCreateTask
extends AdminServerTask<Void> {
    @Override
    public String getTaskContextName() {
        return "cache";
    }

    @Override
    public String getTaskOperationName() {
        return "create";
    }

    public Void call() throws Exception {
        if (this.isPersistent()) {
            throw new UnsupportedOperationException();
        }
        String name = this.requireParameter("name");
        String template = this.getParameter("template");
        this.cacheManager.executor().submitConsumer((SerializableFunction & Serializable)localManager -> {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (template != null) {
                builder.read(localManager.getCacheConfiguration(template));
            } else {
                Configuration parent = localManager.getDefaultCacheConfiguration();
                if (parent != null) {
                    builder.read(parent);
                }
            }
            builder.template(false);
            localManager.defineConfiguration(name, builder.build());
            localManager.getCache(name);
            return null;
        }, (address, value, throwable) -> {
            if (throwable != null) {
                this.log.fatal("Cache startup encountered exception on node " + address, (Throwable)throwable);
            }
        }).join();
        return null;
    }
}

