/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.admin.AdminServerTask;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.spi.TaskEngine;

public abstract class AdminOperationsHandler
implements TaskEngine {
    final Map<String, AdminServerTask> tasks;

    protected AdminOperationsHandler(Class<? extends AdminServerTask> ... taskClasses) {
        this.tasks = new HashMap<String, AdminServerTask>(taskClasses.length);
        for (Class<? extends AdminServerTask> taskClass : taskClasses) {
            AdminServerTask task = (AdminServerTask)Util.getInstance(taskClass);
            this.tasks.put(task.getName(), task);
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public List<Task> getTasks() {
        return new ArrayList<Task>(this.tasks.values());
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context, Executor executor) {
        AdminServerTask task = this.tasks.get(taskName);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.execute(context);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }, executor);
    }

    public boolean handles(String taskName) {
        return this.tasks.containsKey(taskName);
    }
}

