/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminFlag;
import org.infinispan.server.core.admin.AdminServerTask;
import org.infinispan.util.function.SerializableFunction;

public class CacheCreateTask
extends AdminServerTask<Void> {
    private static Set<String> PARAMETERS = new HashSet<String>();

    @Override
    public String getTaskContextName() {
        return "cache";
    }

    @Override
    public String getTaskOperationName() {
        return "create";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected Void execute(EmbeddedCacheManager cacheManager, Map<String, String> parameters, EnumSet<AdminFlag> flags) {
        if (this.isPersistent(flags)) {
            throw new UnsupportedOperationException();
        }
        String name = this.requireParameter(parameters, "name");
        String template = this.getParameter(parameters, "template");
        cacheManager.executor().submitConsumer((SerializableFunction & Serializable)localManager -> {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (template != null) {
                builder.read(localManager.getCacheConfiguration(template));
            } else {
                Configuration parent = localManager.getDefaultCacheConfiguration();
                if (parent != null) {
                    builder.read(parent);
                }
            }
            builder.template(false);
            localManager.defineConfiguration(name, builder.build());
            localManager.getCache(name);
            return null;
        }, (address, value, throwable) -> {
            if (throwable != null) {
                this.log.fatal("Cache startup encountered exception on node " + address, (Throwable)throwable);
            }
        }).join();
        return null;
    }

    static {
        PARAMETERS.add("name");
        PARAMETERS.add("template");
    }
}

