/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.server.core.dataconversion.json.SecureTypeResolverBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JsonTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JsonTranscoder.class, Log.class);
    public static final String TYPE_PROPERTY = "_type";
    private final ObjectMapper objectMapper;

    public JsonTranscoder() {
        this(JsonTranscoder.class.getClassLoader(), new ClassWhiteList(Collections.emptyList()));
    }

    public JsonTranscoder(ClassWhiteList whiteList) {
        this(JsonTranscoder.class.getClassLoader(), whiteList);
    }

    public JsonTranscoder(ClassLoader classLoader, ClassWhiteList whiteList) {
        super(MediaType.APPLICATION_JSON, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_UNKNOWN});
        this.objectMapper = new ObjectMapper().setDefaultTyping((TypeResolverBuilder)new SecureTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, whiteList){
            {
                this.init(JsonTypeInfo.Id.CLASS, null);
                this.inclusion(JsonTypeInfo.As.PROPERTY);
                this.typeProperty(JsonTranscoder.TYPE_PROPERTY);
            }

            public boolean useForType(JavaType t) {
                return !t.isContainerType() && super.useForType(t);
            }
        });
        TypeFactory typeFactory = TypeFactory.defaultInstance().withClassLoader(classLoader);
        this.objectMapper.setTypeFactory(typeFactory);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM) || destinationType.match(MediaType.APPLICATION_UNKNOWN)) {
            return StandardConversions.convertTextToOctetStream((Object)content, (MediaType)contentType);
        }
        if (destinationType.match(MediaType.APPLICATION_JSON)) {
            if (contentType.match(MediaType.APPLICATION_JSON)) {
                Charset destinationCharset;
                Charset sourceCharset = contentType.getCharset();
                if (!sourceCharset.equals(destinationCharset = destinationType.getCharset())) {
                    return StandardConversions.convertCharset((Object)content, (Charset)sourceCharset, (Charset)destinationCharset);
                }
                return content;
            }
            try {
                if (content instanceof byte[]) {
                    try {
                        return this.objectMapper.readTree((byte[])content).toString().getBytes(destinationType.getCharset());
                    }
                    catch (IOException e) {
                        String contentAsString = new String((byte[])content, destinationType.getCharset());
                        return this.objectMapper.writeValueAsBytes((Object)contentAsString);
                    }
                }
                return this.objectMapper.writeValueAsBytes(content);
            }
            catch (IOException e) {
                throw logger.cannotConvertContent(content, contentType, destinationType);
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                if (content instanceof byte[]) {
                    return this.objectMapper.readValue((byte[])content, Object.class);
                }
                return this.objectMapper.readValue((String)content, Object.class);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            Optional optDestinationCharset = destinationType.getParameter("charset");
            if (!optDestinationCharset.isPresent()) {
                return content;
            }
            if (content instanceof byte[]) {
                Charset sourceCharset = contentType.getParameter("charset").map(Charset::forName).orElse(Charset.defaultCharset());
                Charset destinationCharset = Charset.forName((String)optDestinationCharset.get());
                byte[] byteContent = (byte[])content;
                return StandardConversions.convertCharset((Object)byteContent, (Charset)sourceCharset, (Charset)destinationCharset);
            }
        }
        throw logger.unsupportedContent(content);
    }
}

