/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.logging;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.dataconversion.TranscodingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Server channel group did not completely unbind", id=5004)
    public void serverDidNotUnbind();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s is still bound to %s", id=5005)
    public void channelStillBound(Channel var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Channel group did not completely close", id=5006)
    public void serverDidNotClose();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s is still connected to %s", id=5007)
    public void channelStillConnected(Channel var1, SocketAddress var2);

    @Message(value="Illegal number of workerThreads: %d", id=5010)
    public IllegalArgumentException illegalWorkerThreads(int var1);

    @Message(value="Idle timeout can't be lower than -1: %d", id=5011)
    public IllegalArgumentException illegalIdleTimeout(int var1);

    @Message(value="Receive Buffer Size can't be lower than 0: %d", id=5012)
    public IllegalArgumentException illegalReceiveBufferSize(int var1);

    @Message(value="Send Buffer Size can't be lower than 0: %d", id=5013)
    public IllegalArgumentException illegalSendBufferSize(int var1);

    @Message(value="SSL Enabled but no KeyStore specified", id=5014)
    public CacheConfigurationException noSSLKeyManagerConfiguration();

    @Message(value="A password is required to open the KeyStore '%s'", id=5016)
    public CacheConfigurationException missingKeyStorePassword(String var1);

    @Message(value="A password is required to open the TrustStore '%s'", id=5017)
    public CacheConfigurationException missingTrustStorePassword(String var1);

    @Message(value="Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext", id=5018)
    public CacheConfigurationException xorSSLContext();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using Netty SocketChannel %s for %s", id=5025)
    public void createdSocketChannel(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using Netty EventLoop %s for %s", id=5026)
    public void createdNettyEventLoop(String var1, String var2);

    @Message(value="SSL Enabled but no SNI domain configured", id=5027)
    public CacheConfigurationException noSniDomainConfigured();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Native Epoll transport not available, using NIO instead: %s", id=5028)
    public void epollNotAvailable(String var1);

    @Message(value="No task manager available to register the admin operations handler", id=5029)
    public CacheConfigurationException cannotRegisterAdminOperationsHandler();

    @Message(value="Administration task '%s' invoked without required parameter '%s'", id=5030)
    public NullPointerException missingRequiredAdminTaskParameter(String var1, String var2);

    @Message(value="The supplied configuration for cache '%s' is missing a named configuration for it: %s", id=5031)
    public CacheConfigurationException missingCacheConfiguration(String var1, String var2);

    @Message(value="Error during transcoding", id=5032)
    public TranscodingException errorDuringTranscoding(@Cause Throwable var1);

    @Message(value="Data format '%s' not supported", id=5033)
    public TranscodingException unsupportedDataFormat(MediaType var1);

    @Message(value="Cannot create clustered caches in non-clustered servers", id=5034)
    public UnsupportedOperationException cannotCreateClusteredCache();

    @Message(value="Class '%s' blocked by deserialization white list. Include the class name in the server cache manager white list to authorize.", id=5035)
    public CacheException errorDeserializing(String var1);
}

