/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.logging;

import io.netty.channel.Channel;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.dataconversion.TranscodingException;
import org.infinispan.server.core.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String serverDidNotUnbind = "ISPN005004: Server channel group did not completely unbind";
    private static final String channelStillBound = "ISPN005005: %s is still bound to %s";
    private static final String serverDidNotClose = "ISPN005006: Channel group did not completely close";
    private static final String channelStillConnected = "ISPN005007: %s is still connected to %s";
    private static final String illegalWorkerThreads = "ISPN005010: Illegal number of workerThreads: %d";
    private static final String illegalIdleTimeout = "ISPN005011: Idle timeout can't be lower than -1: %d";
    private static final String illegalReceiveBufferSize = "ISPN005012: Receive Buffer Size can't be lower than 0: %d";
    private static final String illegalSendBufferSize = "ISPN005013: Send Buffer Size can't be lower than 0: %d";
    private static final String noSSLKeyManagerConfiguration = "ISPN005014: SSL Enabled but no KeyStore specified";
    private static final String missingKeyStorePassword = "ISPN005016: A password is required to open the KeyStore '%s'";
    private static final String missingTrustStorePassword = "ISPN005017: A password is required to open the TrustStore '%s'";
    private static final String xorSSLContext = "ISPN005018: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    private static final String createdSocketChannel = "ISPN005025: Using Netty SocketChannel %s for %s";
    private static final String createdNettyEventLoop = "ISPN005026: Using Netty EventLoop %s for %s";
    private static final String noSniDomainConfigured = "ISPN005027: SSL Enabled but no SNI domain configured";
    private static final String epollNotAvailable = "ISPN005028: Native Epoll transport not available, using NIO instead: %s";
    private static final String cannotRegisterAdminOperationsHandler = "ISPN005029: No task manager available to register the admin operations handler";
    private static final String missingRequiredAdminTaskParameter = "ISPN005030: Administration task '%s' invoked without required parameter '%s'";
    private static final String missingCacheConfiguration = "ISPN005031: The supplied configuration for cache '%s' is missing a named configuration for it: %s";
    private static final String errorDuringTranscoding = "ISPN005032: Error during transcoding";
    private static final String unsupportedDataFormat = "ISPN005033: Data format '%s' not supported";
    private static final String cannotCreateClusteredCache = "ISPN005034: Cannot create clustered caches in non-clustered servers";
    private static final String errorDeserializing = "ISPN005035: Class '%s' blocked by deserialization white list. Include the class name in the server cache manager white list to authorize.";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void serverDidNotUnbind() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serverDidNotUnbind$str(), new Object[0]);
    }

    protected String serverDidNotUnbind$str() {
        return serverDidNotUnbind;
    }

    @Override
    public final void channelStillBound(Channel ch, SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.channelStillBound$str(), (Object)ch, (Object)address);
    }

    protected String channelStillBound$str() {
        return channelStillBound;
    }

    @Override
    public final void serverDidNotClose() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serverDidNotClose$str(), new Object[0]);
    }

    protected String serverDidNotClose$str() {
        return serverDidNotClose;
    }

    @Override
    public final void channelStillConnected(Channel ch, SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.channelStillConnected$str(), (Object)ch, (Object)address);
    }

    protected String channelStillConnected$str() {
        return channelStillConnected;
    }

    @Override
    public final IllegalArgumentException illegalWorkerThreads(int workerThreads) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.illegalWorkerThreads$str(), workerThreads));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalWorkerThreads$str() {
        return illegalWorkerThreads;
    }

    @Override
    public final IllegalArgumentException illegalIdleTimeout(int idleTimeout) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.illegalIdleTimeout$str(), idleTimeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalIdleTimeout$str() {
        return illegalIdleTimeout;
    }

    @Override
    public final IllegalArgumentException illegalReceiveBufferSize(int recvBufSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.illegalReceiveBufferSize$str(), recvBufSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalReceiveBufferSize$str() {
        return illegalReceiveBufferSize;
    }

    @Override
    public final IllegalArgumentException illegalSendBufferSize(int sendBufSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.illegalSendBufferSize$str(), sendBufSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalSendBufferSize$str() {
        return illegalSendBufferSize;
    }

    @Override
    public final CacheConfigurationException noSSLKeyManagerConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.noSSLKeyManagerConfiguration$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSSLKeyManagerConfiguration$str() {
        return noSSLKeyManagerConfiguration;
    }

    @Override
    public final CacheConfigurationException missingKeyStorePassword(String keyStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.missingKeyStorePassword$str(), keyStore));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingKeyStorePassword$str() {
        return missingKeyStorePassword;
    }

    @Override
    public final CacheConfigurationException missingTrustStorePassword(String trustStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.missingTrustStorePassword$str(), trustStore));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingTrustStorePassword$str() {
        return missingTrustStorePassword;
    }

    @Override
    public final CacheConfigurationException xorSSLContext() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.xorSSLContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String xorSSLContext$str() {
        return xorSSLContext;
    }

    @Override
    public final void createdSocketChannel(String channelClassName, String configuration) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdSocketChannel$str(), (Object)channelClassName, (Object)configuration);
    }

    protected String createdSocketChannel$str() {
        return createdSocketChannel;
    }

    @Override
    public final void createdNettyEventLoop(String eventLoopClassName, String configuration) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdNettyEventLoop$str(), (Object)eventLoopClassName, (Object)configuration);
    }

    protected String createdNettyEventLoop$str() {
        return createdNettyEventLoop;
    }

    @Override
    public final CacheConfigurationException noSniDomainConfigured() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.noSniDomainConfigured$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSniDomainConfigured$str() {
        return noSniDomainConfigured;
    }

    @Override
    public final void epollNotAvailable(String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.epollNotAvailable$str(), (Object)message);
    }

    protected String epollNotAvailable$str() {
        return epollNotAvailable;
    }

    @Override
    public final CacheConfigurationException cannotRegisterAdminOperationsHandler() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.cannotRegisterAdminOperationsHandler$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRegisterAdminOperationsHandler$str() {
        return cannotRegisterAdminOperationsHandler;
    }

    @Override
    public final NullPointerException missingRequiredAdminTaskParameter(String name, String parameter) {
        NullPointerException result = new NullPointerException(String.format(this.missingRequiredAdminTaskParameter$str(), name, parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingRequiredAdminTaskParameter$str() {
        return missingRequiredAdminTaskParameter;
    }

    @Override
    public final CacheConfigurationException missingCacheConfiguration(String name, String configuration) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.missingCacheConfiguration$str(), name, configuration));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCacheConfiguration$str() {
        return missingCacheConfiguration;
    }

    @Override
    public final TranscodingException errorDuringTranscoding(Throwable e) {
        TranscodingException result = new TranscodingException(String.format(this.errorDuringTranscoding$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorDuringTranscoding$str() {
        return errorDuringTranscoding;
    }

    @Override
    public final TranscodingException unsupportedDataFormat(MediaType contentFormat) {
        TranscodingException result = new TranscodingException(String.format(this.unsupportedDataFormat$str(), contentFormat));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedDataFormat$str() {
        return unsupportedDataFormat;
    }

    @Override
    public final UnsupportedOperationException cannotCreateClusteredCache() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.cannotCreateClusteredCache$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateClusteredCache$str() {
        return cannotCreateClusteredCache;
    }

    @Override
    public final CacheException errorDeserializing(String className) {
        CacheException result = new CacheException(String.format(this.errorDeserializing$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorDeserializing$str() {
        return errorDeserializing;
    }
}

