/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyTransportConnectionStats;
import org.infinispan.server.core.transport.Transport;

public class NettyTransport
implements Transport {
    private static final Log log;
    private static final boolean isLog4jAvailable;
    private static final String USE_EPOLL_PROPERTY = "infinispan.server.channel.epoll";
    private static final boolean IS_LINUX;
    private static final boolean EPOLL_DISABLED;
    private static final boolean USE_NATIVE_EPOLL;
    private ChannelInitializer<Channel> handler;
    private final InetSocketAddress address;
    private final ProtocolServerConfiguration configuration;
    private final ChannelGroup serverChannels;
    final ChannelGroup acceptedChannels;
    private final EventLoopGroup masterGroup;
    private final EventLoopGroup workerGroup;
    private final NettyTransportConnectionStats connectionStats;
    private Optional<Integer> nettyPort = Optional.empty();

    public NettyTransport(InetSocketAddress address, ProtocolServerConfiguration configuration, String threadNamePrefix, EmbeddedCacheManager cacheManager) {
        this.address = address;
        this.configuration = configuration;
        this.masterGroup = this.buildEventLoop(1, new DefaultThreadFactory(threadNamePrefix + "-ServerMaster"));
        this.workerGroup = this.buildEventLoop(0, new DefaultThreadFactory(threadNamePrefix + "-ServerWorker"));
        this.serverChannels = new DefaultChannelGroup(threadNamePrefix + "-Channels", (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.acceptedChannels = new DefaultChannelGroup(threadNamePrefix + "-Accepted", (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.connectionStats = new NettyTransportConnectionStats(cacheManager, this.acceptedChannels, threadNamePrefix);
    }

    public void initializeHandler(ChannelInitializer<Channel> handler) {
        this.handler = handler;
    }

    @Override
    public void start() {
        Channel ch;
        if (isLog4jAvailable) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.masterGroup, this.workerGroup);
        bootstrap.channel(this.getServerSocketChannel());
        bootstrap.childHandler(this.handler);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.configuration.tcpNoDelay());
        if (this.configuration.sendBufSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.configuration.sendBufSize());
        }
        if (this.configuration.recvBufSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.configuration.recvBufSize());
        }
        try {
            ch = bootstrap.bind((SocketAddress)this.address).sync().channel();
            this.nettyPort = Optional.of(((InetSocketAddress)ch.localAddress()).getPort());
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
        this.serverChannels.add((Object)ch);
    }

    @Override
    public void stop() {
        Future masterTerminationFuture = this.masterGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
        Future workerTerminationFuture = this.workerGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
        masterTerminationFuture.awaitUninterruptibly();
        workerTerminationFuture.awaitUninterruptibly();
        ChannelGroupFuture serverChannelsTerminationFuture = this.serverChannels.close();
        ChannelGroupFuture acceptedChannelsTerminationFuture = this.acceptedChannels.close();
        ChannelGroupFuture future = serverChannelsTerminationFuture.awaitUninterruptibly();
        if (!future.isSuccess()) {
            log.serverDidNotUnbind();
            future.forEach(fut -> {
                Channel ch = fut.channel();
                if (ch.isActive()) {
                    log.channelStillBound(ch, ch.remoteAddress());
                }
            });
        }
        if (!(future = acceptedChannelsTerminationFuture.awaitUninterruptibly()).isSuccess()) {
            log.serverDidNotClose();
            future.forEach(fut -> {
                Channel ch = fut.channel();
                if (ch.isActive()) {
                    log.channelStillConnected(ch, ch.remoteAddress());
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug("Channel group completely closed, external resources released");
        }
        this.nettyPort = Optional.empty();
    }

    @Override
    public String getTotalBytesWritten() {
        return Long.toString(this.connectionStats.getTotalBytesWritten());
    }

    @Override
    public String getTotalBytesRead() {
        return Long.toString(this.connectionStats.getTotalBytesRead());
    }

    @Override
    public String getHostName() {
        return this.address.getHostName();
    }

    @Override
    public Integer getPort() {
        return this.nettyPort.orElse(this.address.getPort());
    }

    @Override
    public String getNumberWorkerThreads() {
        return Integer.toString(this.configuration.workerThreads());
    }

    @Override
    public String getIdleTimeout() {
        return Integer.toString(this.configuration.idleTimeout());
    }

    @Override
    public String getTcpNoDelay() {
        return Boolean.toString(this.configuration.tcpNoDelay());
    }

    @Override
    public String getSendBufferSize() {
        return Integer.toString(this.configuration.sendBufSize());
    }

    @Override
    public String getReceiveBufferSize() {
        return Integer.toString(this.configuration.recvBufSize());
    }

    @Override
    public Integer getNumberOfLocalConnections() {
        return this.connectionStats.getNumberOfLocalConnections();
    }

    @Override
    public Integer getNumberOfGlobalConnections() {
        return this.connectionStats.getNumberOfGlobalConnections();
    }

    public void updateTotalBytesWritten(int bytes) {
        this.connectionStats.incrementTotalBytesWritten(bytes);
    }

    public void updateTotalBytesRead(int bytes) {
        this.connectionStats.incrementTotalBytesRead(bytes);
    }

    private Class<? extends ServerChannel> getServerSocketChannel() {
        Class channel = USE_NATIVE_EPOLL ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
        log.createdSocketChannel(channel.getName(), this.configuration.toString());
        return channel;
    }

    private EventLoopGroup buildEventLoop(int nThreads, DefaultThreadFactory threadFactory) {
        EpollEventLoopGroup eventLoop = USE_NATIVE_EPOLL ? new EpollEventLoopGroup(nThreads, (ThreadFactory)threadFactory) : new NioEventLoopGroup(nThreads, (ThreadFactory)threadFactory);
        log.createdNettyEventLoop(eventLoop.getClass().getName(), this.configuration.toString());
        return eventLoop;
    }

    static {
        boolean exception;
        log = (Log)LogFactory.getLog(NettyTransport.class, Log.class);
        IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
        EPOLL_DISABLED = System.getProperty(USE_EPOLL_PROPERTY, "true").equalsIgnoreCase("false");
        try {
            Util.loadClassStrict((String)"org.apache.logging.log4j.Logger", (ClassLoader)Thread.currentThread().getContextClassLoader());
            exception = false;
        }
        catch (ClassNotFoundException e) {
            exception = true;
        }
        boolean bl = isLog4jAvailable = !exception;
        if (Epoll.isAvailable()) {
            USE_NATIVE_EPOLL = !EPOLL_DISABLED && IS_LINUX;
        } else {
            if (IS_LINUX) {
                log.epollNotAvailable(Epoll.unavailabilityCause().toString());
            }
            USE_NATIVE_EPOLL = false;
        }
    }
}

