/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.group.ChannelGroup;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

class NettyTransportConnectionStats {
    private final EmbeddedCacheManager cacheManager;
    private final boolean isGlobalStatsEnabled;
    private final ChannelGroup acceptedChannels;
    private final String threadNamePrefix;
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalBytesRead = new AtomicLong();

    public NettyTransportConnectionStats(EmbeddedCacheManager cacheManager, ChannelGroup acceptedChannels, String threadNamePrefix) {
        this.cacheManager = cacheManager;
        this.isGlobalStatsEnabled = cacheManager != null && cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled();
        this.acceptedChannels = acceptedChannels;
        this.threadNamePrefix = threadNamePrefix;
    }

    private void increment(AtomicLong base, long bytes) {
        if (this.isGlobalStatsEnabled) {
            base.addAndGet(bytes);
        }
    }

    public void incrementTotalBytesWritten(long bytes) {
        this.increment(this.totalBytesWritten, bytes);
    }

    public void incrementTotalBytesRead(long bytes) {
        this.increment(this.totalBytesRead, bytes);
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead.get();
    }

    private boolean needDistributedCalculation() {
        if (this.cacheManager != null) {
            Transport transport = this.cacheManager.getTransport();
            return transport != null && transport.getMembers().size() > 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateGlobalConnections() {
        Cache cache = this.cacheManager.getCache();
        DefaultExecutorService exec = new DefaultExecutorService(cache);
        try {
            List results = exec.submitEverywhere((Callable)((Object)new ConnectionAdderTask(this.threadNamePrefix)));
            int n = results.stream().mapToInt(f -> {
                try {
                    return (Integer)f.get(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new CacheException((Throwable)e);
                }
            }).sum();
            return n;
        }
        finally {
            exec.shutdown();
        }
    }

    public Integer getNumberOfLocalConnections() {
        return this.acceptedChannels.size();
    }

    public Integer getNumberOfGlobalConnections() {
        if (this.needDistributedCalculation()) {
            return this.calculateGlobalConnections();
        }
        return this.getNumberOfLocalConnections();
    }

    static class ConnectionAdderTask
    implements Serializable,
    DistributedCallable<Object, Object, Integer> {
        private final String serverName;
        Cache<Object, Object> cache;

        ConnectionAdderTask(String serverName) {
            this.serverName = serverName;
        }

        public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
            this.cache = cache;
        }

        public Integer call() throws Exception {
            GlobalConfiguration globalCfg = this.cache.getCacheManager().getCacheManagerConfiguration();
            String jmxDomain = globalCfg.globalJmxStatistics().domain();
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
            try {
                ObjectName transportMBeanName = new ObjectName(jmxDomain + ":type=Server,component=Transport,name=" + this.serverName);
                return (Integer)mbeanServer.getAttribute(transportMBeanName, "NumberOfLocalConnections");
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

