/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.net.InetSocketAddress;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractCacheIgnoreAware;
import org.infinispan.server.core.LifecycleCallbacks;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.SecurityActions;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;

public abstract class AbstractProtocolServer<A extends ProtocolServerConfiguration>
extends AbstractCacheIgnoreAware
implements ProtocolServer<A> {
    private static final Log log = (Log)LogFactory.getLog(AbstractProtocolServer.class, Log.class);
    private final String protocolName;
    protected NettyTransport transport;
    protected EmbeddedCacheManager cacheManager;
    protected A configuration;
    private ObjectName transportObjName;
    private MBeanServer mbeanServer;

    protected AbstractProtocolServer(String protocolName) {
        this.protocolName = protocolName;
    }

    protected void startInternal(A configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        if (log.isDebugEnabled()) {
            log.debugf("Starting server with configuration: %s", configuration);
        }
        this.registerAdminOperationsHandler();
        this.startDefaultCache();
        if (((ProtocolServerConfiguration)configuration).startTransport()) {
            this.startTransport();
        }
    }

    private void registerAdminOperationsHandler() {
        if (((ProtocolServerConfiguration)this.configuration).adminOperationsHandler() != null) {
            TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(TaskManager.class);
            if (taskManager != null) {
                taskManager.registerTaskEngine((TaskEngine)((ProtocolServerConfiguration)this.configuration).adminOperationsHandler());
            } else {
                throw log.cannotRegisterAdminOperationsHandler();
            }
        }
    }

    @Override
    public final void start(A configuration, EmbeddedCacheManager cacheManager) {
        try {
            ((ProtocolServerConfiguration)configuration).ignoredCaches().forEach(this::ignoreCache);
            this.startInternal(configuration, cacheManager);
        }
        catch (RuntimeException t) {
            this.stop();
            throw t;
        }
    }

    protected void startTransport() {
        InetSocketAddress address = new InetSocketAddress(((ProtocolServerConfiguration)this.configuration).host(), ((ProtocolServerConfiguration)this.configuration).port());
        this.transport = new NettyTransport(address, (ProtocolServerConfiguration)this.configuration, this.getQualifiedName(), this.cacheManager);
        this.transport.initializeHandler(this.getInitializer());
        this.registerTransportMBean();
        try {
            this.transport.start();
        }
        catch (Throwable re) {
            try {
                this.unregisterTransportMBean();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            throw re;
        }
    }

    protected void registerTransportMBean() {
        GlobalConfiguration globalCfg = this.cacheManager.getCacheManagerConfiguration();
        GlobalJmxStatisticsConfiguration jmxConfig = globalCfg.globalJmxStatistics();
        this.mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
        String groupName = String.format("type=Server,name=%s", this.getQualifiedName());
        String jmxDomain = JmxUtil.buildJmxDomain((String)jmxConfig.domain(), (MBeanServer)this.mbeanServer, (String)groupName);
        ManageableComponentMetadata meta = LifecycleCallbacks.componentMetadataRepo.findComponentMetadata(this.transport.getClass()).toManageableComponentMetadata();
        try {
            ResourceDMBean dynamicMBean = new ResourceDMBean((Object)this.transport, meta);
            this.transportObjName = new ObjectName(String.format("%s:%s,component=%s", jmxDomain, groupName, meta.getJmxObjectName()));
            JmxUtil.registerMBean((Object)dynamicMBean, (ObjectName)this.transportObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void unregisterTransportMBean() throws Exception {
        if (this.mbeanServer != null && this.transportObjName != null) {
            JmxUtil.unregisterMBean((ObjectName)this.transportObjName, (MBeanServer)this.mbeanServer);
        }
    }

    public String getQualifiedName() {
        return this.protocolName + (((ProtocolServerConfiguration)this.configuration).name().length() > 0 ? "-" : "") + ((ProtocolServerConfiguration)this.configuration).name();
    }

    @Override
    public void stop() {
        boolean isDebug = log.isDebugEnabled();
        if (isDebug && this.configuration != null) {
            log.debugf("Stopping server listening in %s:%d", ((ProtocolServerConfiguration)this.configuration).host(), ((ProtocolServerConfiguration)this.configuration).port());
        }
        if (this.transport != null) {
            this.transport.stop();
        }
        try {
            this.unregisterTransportMBean();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        if (isDebug) {
            log.debug("Server stopped");
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getHost() {
        return ((ProtocolServerConfiguration)this.configuration).host();
    }

    public Integer getPort() {
        if (this.transport != null) {
            return this.transport.getPort();
        }
        return ((ProtocolServerConfiguration)this.configuration).port();
    }

    @Override
    public A getConfiguration() {
        return this.configuration;
    }

    protected void startDefaultCache() {
        this.cacheManager.getCache(((ProtocolServerConfiguration)this.configuration).defaultCacheName());
    }

    public boolean isTransportEnabled() {
        return this.transport != null;
    }

    public NettyTransport getTransport() {
        return this.transport;
    }

    public abstract int getWorkerThreads();
}

