/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.server.core.dataconversion.json.SecureTypeResolverBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JsonTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JsonTranscoder.class, Log.class);
    public static final String TYPE_PROPERTY = "_type";
    private final ObjectMapper objectMapper;

    public JsonTranscoder() {
        this(JsonTranscoder.class.getClassLoader(), new ClassWhiteList(Collections.emptyList()));
    }

    public JsonTranscoder(ClassWhiteList whiteList) {
        this(JsonTranscoder.class.getClassLoader(), whiteList);
    }

    public JsonTranscoder(ClassLoader classLoader, ClassWhiteList whiteList) {
        super(MediaType.APPLICATION_JSON, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_UNKNOWN});
        this.objectMapper = new ObjectMapper().setDefaultTyping((TypeResolverBuilder)new SecureTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, whiteList){
            {
                this.init(JsonTypeInfo.Id.CLASS, null);
                this.inclusion(JsonTypeInfo.As.PROPERTY);
                this.typeProperty(JsonTranscoder.TYPE_PROPERTY);
            }

            public boolean useForType(JavaType t) {
                return !t.isContainerType() && super.useForType(t);
            }
        });
        TypeFactory typeFactory = TypeFactory.defaultInstance().withClassLoader(classLoader);
        this.objectMapper.setTypeFactory(typeFactory);
    }

    /*
     * Exception decompiling
     */
    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object convertTextToJson(Object content, Charset contentCharset, Charset destinationCharset, boolean asString) throws IOException {
        byte[] bytes = content instanceof byte[] ? (byte[])content : content.toString().getBytes(contentCharset);
        try (InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), contentCharset);){
            String jsonTree = this.objectMapper.readTree((Reader)isr).toString();
            String string = asString ? jsonTree : (Object)jsonTree.getBytes(destinationCharset);
            return string;
        }
        catch (IOException e) {
            Object object;
            String contentAsString = new String(bytes, contentCharset);
            if (asString) {
                object = this.objectMapper.writeValueAsString((Object)contentAsString);
                return object;
            }
            object = this.objectMapper.writeValueAsBytes((Object)contentAsString);
            return object;
        }
    }

    private Object convertCharset(Object content, Charset contentCharset, Charset destinationCharset, boolean outputAsString) {
        Object object;
        byte[] bytes = StandardConversions.convertCharset((Object)content, (Charset)contentCharset, (Charset)destinationCharset);
        if (outputAsString) {
            String string;
            object = string;
            string = new String(bytes, destinationCharset);
        } else {
            object = bytes;
        }
        return object;
    }
}

