/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.security.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.InetAddressPrincipal;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.external.ExternalSaslServerFactory;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.Log;

public class Authentication {
    private static final Log log = (Log)LogFactory.getLog(Authentication.class, Log.class);
    private final Channel channel;
    private final HotRodServer server;
    private final HotRodServerConfiguration serverConfig;
    private final AuthenticationConfiguration authenticationConfig;
    private final boolean enabled;
    private final boolean requireAuthentication;
    private SaslServer saslServer;
    private AuthorizingCallbackHandler callbackHandler;
    private Subject subject = ANONYMOUS;
    private static final Subject ANONYMOUS = new Subject();

    public Authentication(Channel channel, HotRodServer server) {
        this.channel = channel;
        this.server = server;
        this.serverConfig = (HotRodServerConfiguration)server.getConfiguration();
        this.authenticationConfig = this.serverConfig.authentication();
        this.enabled = this.authenticationConfig.enabled();
        this.requireAuthentication = !this.authenticationConfig.mechProperties().containsKey("javax.security.sasl.policy.noanonymous") || this.authenticationConfig.mechProperties().get("javax.security.sasl.policy.noanonymous").equals("true");
    }

    private void writeResponse(HotRodHeader header, ByteBuf response) {
        int responseBytes = response.readableBytes();
        ChannelFuture future = this.channel.writeAndFlush((Object)response);
        if (header instanceof AccessLoggingHeader) {
            this.server.accessLogging().logOK(future, (AccessLoggingHeader)header, responseBytes);
        }
    }

    public void authMechList(HotRodHeader header) {
        this.writeResponse(header, header.encoder().authMechListResponse(header, this.server, this.channel.alloc(), this.authenticationConfig.allowedMechs()));
    }

    public void auth(HotRodHeader header, String mech, byte[] response) throws PrivilegedActionException, SaslException {
        if (!this.enabled) {
            UnsupportedOperationException cause = log.invalidOperation();
            ByteBuf buf = header.encoder().errorResponse(header, this.server, this.channel.alloc(), cause.toString(), OperationStatus.ServerError);
            int responseBytes = buf.readableBytes();
            ChannelFuture future = this.channel.writeAndFlush((Object)buf);
            if (header instanceof AccessLoggingHeader) {
                this.server.accessLogging().logException(future, (AccessLoggingHeader)header, cause.toString(), responseBytes);
            }
        } else {
            if (this.saslServer == null) {
                SaslServerFactory ssf;
                ServerAuthenticationProvider sap = this.authenticationConfig.serverAuthenticationProvider();
                this.callbackHandler = sap.getCallbackHandler(mech, this.authenticationConfig.mechProperties());
                if ("EXTERNAL".equals(mech)) {
                    SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
                    try {
                        if (sslHandler == null) {
                            throw log.externalMechNotAllowedWithoutSSLClientCert();
                        }
                        ssf = new ExternalSaslServerFactory(sslHandler.engine().getSession().getPeerPrincipal());
                    }
                    catch (SSLPeerUnverifiedException e) {
                        throw log.externalMechNotAllowedWithoutSSLClientCert();
                    }
                } else {
                    ssf = this.server.getSaslServerFactory(mech);
                }
                this.saslServer = this.authenticationConfig.serverSubject() != null ? Subject.doAs(this.authenticationConfig.serverSubject(), () -> ssf.createSaslServer(mech, "hotrod", this.authenticationConfig.serverName(), this.authenticationConfig.mechProperties(), (CallbackHandler)this.callbackHandler)) : ssf.createSaslServer(mech, "hotrod", this.authenticationConfig.serverName(), this.authenticationConfig.mechProperties(), (CallbackHandler)this.callbackHandler);
            }
            byte[] serverChallenge = this.saslServer.evaluateResponse(response);
            this.writeResponse(header, header.encoder().authResponse(header, this.server, this.channel.alloc(), serverChallenge));
            if (this.saslServer.isComplete()) {
                ArrayList<Object> extraPrincipals = new ArrayList<Object>();
                String id = this.normalizeAuthorizationId(this.saslServer.getAuthorizationID());
                extraPrincipals.add(new SimpleUserPrincipal(id));
                extraPrincipals.add(new InetAddressPrincipal(((InetSocketAddress)this.channel.remoteAddress()).getAddress()));
                SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
                try {
                    if (sslHandler != null) {
                        extraPrincipals.add(sslHandler.engine().getSession().getPeerPrincipal());
                    }
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
                this.subject = this.callbackHandler.getSubjectUserInfo(extraPrincipals).getSubject();
                String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
                    SaslQopHandler qopHandler = new SaslQopHandler(this.saslServer);
                    this.channel.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
                } else {
                    this.saslServer.dispose();
                    this.callbackHandler = null;
                    this.saslServer = null;
                }
            }
        }
    }

    public Subject getSubject(HotRodOperation operation) {
        return this.getSubject(operation.requiresAuthentication());
    }

    public Subject getSubject(boolean authenticatedOperation) {
        if (!this.enabled || !authenticatedOperation) {
            return null;
        }
        if (this.requireAuthentication && this.subject == ANONYMOUS) {
            throw log.unauthorizedOperation();
        }
        return this.subject;
    }

    String normalizeAuthorizationId(String id) {
        int realm = id.indexOf(64);
        if (realm >= 0) {
            return id.substring(0, realm);
        }
        return id;
    }
}

