/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.SaslUtils;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.NamedFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.notifications.Listenable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.CacheUnavailableException;
import org.infinispan.server.hotrod.CheckAddressTask;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.CrashedMemberDetectorListener;
import org.infinispan.server.hotrod.HotRodDecoder;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodSourceMigrator;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.KeyValueVersionConverterFactory;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.event.KeyValueWithPreviousEventConverterFactory;
import org.infinispan.server.hotrod.iteration.DefaultIterationManager;
import org.infinispan.server.hotrod.iteration.IterationManager;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.TimeoutEnabledChannelInitializer;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.upgrade.SourceMigrator;
import org.infinispan.util.KeyValuePair;

public class HotRodServer
extends AbstractProtocolServer<HotRodServerConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(HotRodServer.class, Log.class);
    private static final long MILLISECONDS_IN_30_DAYS = TimeUnit.DAYS.toMillis(30L);
    public static final int LISTENERS_CHECK_INTERVAL = 10;
    private Address clusterAddress;
    private ServerAddress address;
    private Cache<Address, ServerAddress> addressCache;
    private final Map<String, CacheInfo> knownCaches = new ConcurrentHashMap<String, CacheInfo>();
    private QueryFacade queryFacade;
    private Map<String, SaslServerFactory> saslMechFactories = new ConcurrentHashMap<String, SaslServerFactory>(4, 0.9f, 16);
    private ClientListenerRegistry clientListenerRegistry;
    private Marshaller marshaller;
    private ClusterExecutor clusterExecutor;
    private CrashedMemberDetectorListener viewChangeListener;
    private ReAddMyAddressListener topologyChangeListener;
    private IterationManager iterationManager;
    private RemoveCacheListener removeCacheListener;
    private ClientCounterManagerNotificationManager clientCounterNotificationManager;
    private HotRodAccessLogging accessLogging = new HotRodAccessLogging();
    private ScheduledExecutorService scheduledExecutor;

    public HotRodServer() {
        super("HotRod");
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        return this.queryFacade.query(cache, query);
    }

    public ClientListenerRegistry getClientListenerRegistry() {
        return this.clientListenerRegistry;
    }

    public ClientCounterManagerNotificationManager getClientCounterNotificationManager() {
        return this.clientCounterNotificationManager;
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public HotRodDecoder getDecoder() {
        return new HotRodDecoder(this.cacheManager, this.getExecutor(), this);
    }

    protected void startInternal(HotRodServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        this.iterationManager = new DefaultIterationManager();
        this.setupSasl();
        List<QueryFacade> queryFacades = this.loadQueryFacades();
        this.queryFacade = queryFacades.size() > 0 ? queryFacades.get(0) : null;
        this.clientListenerRegistry = new ClientListenerRegistry((EncoderRegistry)cacheManager.getGlobalComponentRegistry().getComponent(EncoderRegistry.class));
        this.clientCounterNotificationManager = new ClientCounterManagerNotificationManager(EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager));
        this.addKeyValueFilterConverterFactory(ToEmptyBytesKeyValueFilterConverter.class.getName(), (KeyValueFilterConverterFactory)new ToEmptyBytesFactory());
        this.addCacheEventConverterFactory("key-value-with-previous-converter-factory", new KeyValueWithPreviousEventConverterFactory());
        this.addCacheEventConverterFactory("___eager-key-value-version-converter", KeyValueVersionConverterFactory.SINGLETON);
        this.loadFilterConverterFactories(ParamKeyValueFilterConverterFactory.class, this::addKeyValueFilterConverterFactory);
        this.loadFilterConverterFactories(CacheEventFilterConverterFactory.class, this::addCacheEventFilterConverterFactory);
        this.loadFilterConverterFactories(CacheEventConverterFactory.class, this::addCacheEventConverterFactory);
        this.loadFilterConverterFactories(KeyValueFilterConverterFactory.class, this::addKeyValueFilterConverterFactory);
        DefaultThreadFactory factory = new DefaultThreadFactory(this.getQualifiedName() + "-Scheduled");
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)factory);
        this.removeCacheListener = new RemoveCacheListener();
        SecurityActions.addListener(cacheManager, this.removeCacheListener);
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
        if (Configurations.isClustered((GlobalConfiguration)cacheManager.getCacheManagerConfiguration())) {
            this.defineTopologyCacheConfig(cacheManager);
            if (log.isDebugEnabled()) {
                log.debugf("Externally facing address is %s:%d", configuration.proxyHost(), configuration.proxyPort());
            }
            this.addSelfToTopologyView(cacheManager);
        }
    }

    public ChannelInitializer<Channel> getInitializer() {
        if (((HotRodServerConfiguration)this.configuration).idleTimeout() > 0) {
            return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder()), new TimeoutEnabledChannelInitializer(this)});
        }
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder())});
    }

    private <T> void loadFilterConverterFactories(Class<T> c, BiConsumer<String, T> biConsumer) {
        ServiceFinder.load(c, (ClassLoader[])new ClassLoader[0]).forEach(factory -> {
            NamedFactory annotation = factory.getClass().getAnnotation(NamedFactory.class);
            if (annotation != null) {
                String name = annotation.name();
                biConsumer.accept(name, factory);
            }
        });
    }

    private List<QueryFacade> loadQueryFacades() {
        ArrayList<QueryFacade> facades = new ArrayList<QueryFacade>();
        ServiceLoader.load(QueryFacade.class, ((Object)((Object)this)).getClass().getClassLoader()).forEach(facades::add);
        return facades;
    }

    protected void startTransport() {
        this.preStartCaches();
        super.startTransport();
    }

    protected void startDefaultCache() {
        this.getCacheInfo("", (byte)0, 0L, false);
    }

    private void preStartCaches() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.getCacheInfo(cacheName, (byte)0, 0L, false);
        }
        this.scheduledExecutor.scheduleWithFixedDelay(new CacheInfoUpdateTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    private void addSelfToTopologyView(EmbeddedCacheManager cacheManager) {
        this.addressCache = cacheManager.getCache(((HotRodServerConfiguration)this.configuration).topologyCacheName());
        this.clusterAddress = cacheManager.getAddress();
        this.address = new ServerAddress(((HotRodServerConfiguration)this.configuration).publicHost(), ((HotRodServerConfiguration)this.configuration).publicPort());
        this.clusterExecutor = cacheManager.executor();
        this.viewChangeListener = new CrashedMemberDetectorListener(this.addressCache, this);
        cacheManager.addListener((Object)this.viewChangeListener);
        this.topologyChangeListener = new ReAddMyAddressListener(this.addressCache, this.clusterAddress, this.address);
        this.addressCache.addListener((Object)this.topologyChangeListener);
        log.debugf("Map %s cluster address with %s server endpoint in address cache", this.clusterAddress, this.address);
        this.addressCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.GUARANTEED_DELIVERY}).put((Object)this.clusterAddress, (Object)this.address);
    }

    private void defineTopologyCacheConfig(EmbeddedCacheManager cacheManager) {
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache(((HotRodServerConfiguration)this.configuration).topologyCacheName(), this.createTopologyCacheConfig(cacheManager.getCacheManagerConfiguration().transport().distributedSyncTimeout()).build(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
    }

    protected ConfigurationBuilder createTopologyCacheConfig(long distSyncTimeout) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(((HotRodServerConfiguration)this.configuration).topologyReplTimeout()).locking().lockAcquisitionTimeout(((HotRodServerConfiguration)this.configuration).topologyLockTimeout()).clustering().partitionHandling().mergePolicy(null).expiration().lifespan(-1L).maxIdle(-1L);
        if (((HotRodServerConfiguration)this.configuration).topologyStateTransfer()) {
            builder.clustering().stateTransfer().awaitInitialTransfer(((HotRodServerConfiguration)this.configuration).topologyAwaitInitialTransfer()).fetchInMemoryState(true).timeout(distSyncTimeout + ((HotRodServerConfiguration)this.configuration).topologyReplTimeout());
        } else {
            builder.persistence().addClusterLoader().remoteCallTimeout(((HotRodServerConfiguration)this.configuration).topologyReplTimeout());
        }
        return builder;
    }

    public AdvancedCache<byte[], byte[]> cache(CacheInfo cacheInfo, HotRodHeader header, Subject subject) {
        KeyValuePair<MediaType, MediaType> requestMediaTypes = HotRodServer.getRequestMediaTypes(header, cacheInfo.configuration);
        AdvancedCache<byte[], byte[]> cache = cacheInfo.getCache(requestMediaTypes, subject);
        cache = header.getOptimizedCache(cache, cacheInfo.transactional, cacheInfo.clustered);
        return cache;
    }

    public EmbeddedMultimapCache<WrappedByteArray, WrappedByteArray> multimap(HotRodHeader header, Subject subject) {
        return new EmbeddedMultimapCache(this.cache(this.getCacheInfo(header), header, subject));
    }

    boolean hasSyncListener(CacheNotifierImpl<?, ?> cacheNotifier) {
        for (Class annotation : new Class[]{CacheEntryCreated.class, CacheEntryRemoved.class, CacheEntryExpired.class, CacheEntryModified.class}) {
            for (CacheEntryListenerInvocation invocation : cacheNotifier.getListenerCollectionForAnnotation(annotation)) {
                if (!invocation.isSync()) continue;
                return true;
            }
        }
        return false;
    }

    public CacheInfo getCacheInfo(HotRodHeader header) {
        return this.getCacheInfo(header.cacheName, header.version, header.messageId, true);
    }

    public CacheInfo getCacheInfo(String cacheName, byte hotRodVersion, long messageId, boolean checkIgnored) {
        if (checkIgnored && this.isCacheIgnored(cacheName)) {
            throw new CacheUnavailableException();
        }
        CacheInfo info = this.knownCaches.get(cacheName);
        if (info == null) {
            boolean keep = this.checkCacheIsAvailable(cacheName, hotRodVersion, messageId);
            AdvancedCache<byte[], byte[]> cache = this.obtainAnonymizedCache(cacheName);
            Configuration cacheCfg = SecurityActions.getCacheConfiguration(cache);
            info = new CacheInfo(cache, cacheCfg);
            this.updateCacheInfo(info);
            if (keep) {
                this.knownCaches.put(cacheName, info);
            }
        }
        return info;
    }

    private boolean checkCacheIsAvailable(String cacheName, byte hotRodVersion, long messageId) {
        boolean keep;
        InternalCacheRegistry icr = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (icr.isPrivateCache(cacheName)) {
            throw new RequestParsingException(String.format("Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", cacheName), hotRodVersion, messageId);
        }
        if (icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.PROTECTED)) {
            keep = false;
        } else {
            if (!cacheName.isEmpty() && !this.cacheManager.getCacheNames().contains(cacheName)) {
                throw new CacheNotFoundException(String.format("Cache with name '%s' not found amongst the configured caches", cacheName), hotRodVersion, messageId);
            }
            keep = true;
        }
        return keep;
    }

    public void updateCacheInfo(CacheInfo info) {
        if (info.anonymizedCache.getStatus() != ComponentStatus.RUNNING) {
            return;
        }
        ComponentRegistry cr = SecurityActions.getCacheComponentRegistry(info.anonymizedCache);
        PersistenceManager pm = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        boolean hasIndexing = SecurityActions.getCacheConfiguration(info.anonymizedCache).indexing().index().isEnabled();
        CacheNotifierImpl cacheNotifier = (CacheNotifierImpl)cr.getComponent(CacheNotifier.class);
        info.update(pm.isEnabled(), hasIndexing, this.hasSyncListener(cacheNotifier));
    }

    private AdvancedCache<byte[], byte[]> obtainAnonymizedCache(String cacheName) {
        String validCacheName = cacheName.isEmpty() ? this.defaultCacheName() : cacheName;
        Cache cache = SecurityActions.getCache(this.cacheManager, validCacheName);
        AdvancedCache advancedCache = cache.getAdvancedCache();
        this.tryRegisterMigrationManager((AdvancedCache<byte[], byte[]>)advancedCache);
        return advancedCache;
    }

    private void tryRegisterMigrationManager(AdvancedCache<byte[], byte[]> cache) {
        ComponentRegistry cr = SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache());
        RollingUpgradeManager migrationManager = (RollingUpgradeManager)cr.getComponent(RollingUpgradeManager.class);
        if (migrationManager != null) {
            migrationManager.addSourceMigrator((SourceMigrator)new HotRodSourceMigrator(cache));
        }
    }

    private void setupSasl() {
        if (((HotRodServerConfiguration)this.configuration).authentication().enabled()) {
            Iterator saslFactories = SaslUtils.getSaslServerFactories((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)true);
            while (saslFactories.hasNext()) {
                String[] saslFactoryMechs;
                SaslServerFactory saslFactory = (SaslServerFactory)saslFactories.next();
                for (String supportedMech : saslFactoryMechs = saslFactory.getMechanismNames(((HotRodServerConfiguration)this.configuration).authentication().mechProperties())) {
                    for (String mech : ((HotRodServerConfiguration)this.configuration).authentication().allowedMechs()) {
                        if (!supportedMech.equals(mech)) continue;
                        this.saslMechFactories.putIfAbsent(mech, saslFactory);
                    }
                }
            }
        }
    }

    SaslServerFactory getSaslServerFactory(String mech) {
        return this.saslMechFactories.get(mech);
    }

    public Cache<Address, ServerAddress> getAddressCache() {
        return this.addressCache;
    }

    public void addCacheEventFilterFactory(String name, CacheEventFilterFactory factory) {
        this.clientListenerRegistry.addCacheEventFilterFactory(name, factory);
    }

    public void removeCacheEventFilterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventFilterFactory(name);
    }

    public void addCacheEventConverterFactory(String name, CacheEventConverterFactory factory) {
        this.clientListenerRegistry.addCacheEventConverterFactory(name, factory);
    }

    public void removeCacheEventConverterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventConverterFactory(name);
    }

    public void addCacheEventFilterConverterFactory(String name, CacheEventFilterConverterFactory factory) {
        this.clientListenerRegistry.addCacheEventFilterConverterFactory(name, factory);
    }

    public void removeCacheEventFilterConverterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventFilterConverterFactory(name);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        Optional<Marshaller> optMarshaller = Optional.ofNullable(marshaller);
        this.clientListenerRegistry.setEventMarshaller(optMarshaller);
    }

    public void addKeyValueFilterConverterFactory(String name, KeyValueFilterConverterFactory factory) {
        this.iterationManager.addKeyValueFilterConverterFactory(name, factory);
    }

    public void removeKeyValueFilterConverterFactory(String name) {
        this.iterationManager.removeKeyValueFilterConverterFactory(name);
    }

    public IterationManager getIterationManager() {
        return this.iterationManager;
    }

    private static KeyValuePair<MediaType, MediaType> getRequestMediaTypes(HotRodHeader header, Configuration configuration) {
        MediaType valueRequestType;
        MediaType keyRequestType = header == null ? MediaType.APPLICATION_UNKNOWN : header.getKeyMediaType();
        MediaType mediaType = valueRequestType = header == null ? MediaType.APPLICATION_UNKNOWN : header.getValueMediaType();
        if (header != null && HotRodVersion.HOTROD_28.isOlder(header.version)) {
            if (header.cacheName.equals("___protobuf_metadata")) {
                keyRequestType = MediaType.APPLICATION_PROTOSTREAM;
                valueRequestType = MediaType.APPLICATION_PROTOSTREAM;
            } else if (header.op == HotRodOperation.QUERY) {
                boolean objectStorage = MediaType.APPLICATION_OBJECT.match(configuration.encoding().valueDataType().mediaType());
                keyRequestType = objectStorage ? MediaType.APPLICATION_JBOSS_MARSHALLING : MediaType.APPLICATION_PROTOSTREAM;
                valueRequestType = objectStorage ? MediaType.APPLICATION_JBOSS_MARSHALLING : MediaType.APPLICATION_PROTOSTREAM;
            }
        }
        return new KeyValuePair((Object)keyRequestType, (Object)valueRequestType);
    }

    public void stop() {
        InternalCacheRegistry internalCacheRegistry;
        if (this.removeCacheListener != null) {
            SecurityActions.removeListener((Listenable)this.cacheManager, this.removeCacheListener);
        }
        if (this.viewChangeListener != null) {
            SecurityActions.removeListener((Listenable)this.cacheManager, this.viewChangeListener);
        }
        if (this.topologyChangeListener != null) {
            SecurityActions.removeListener(this.addressCache, this.topologyChangeListener);
        }
        if (this.cacheManager != null && Configurations.isClustered((GlobalConfiguration)this.cacheManager.getCacheManagerConfiguration()) && (internalCacheRegistry = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class)) != null) {
            internalCacheRegistry.unregisterInternalCache(((HotRodServerConfiguration)this.configuration).topologyCacheName());
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        if (this.clientListenerRegistry != null) {
            this.clientListenerRegistry.stop();
        }
        if (this.clientCounterNotificationManager != null) {
            this.clientCounterNotificationManager.stop();
        }
        super.stop();
    }

    public HotRodAccessLogging accessLogging() {
        return this.accessLogging;
    }

    public Metadata.Builder buildMetadata(long lifespan, TimeUnitValue lifespanUnit, long maxIdle, TimeUnitValue maxIdleUnit) {
        EmbeddedMetadata.Builder metadata = new EmbeddedMetadata.Builder();
        if (lifespan != -2L && lifespanUnit != TimeUnitValue.DEFAULT) {
            if (lifespanUnit == TimeUnitValue.INFINITE) {
                metadata.lifespan(-1L);
            } else {
                metadata.lifespan(HotRodServer.toMillis(lifespan, lifespanUnit));
            }
        }
        if (maxIdle != -2L && maxIdleUnit != TimeUnitValue.DEFAULT) {
            if (maxIdleUnit == TimeUnitValue.INFINITE) {
                metadata.maxIdle(-1L);
            } else {
                metadata.maxIdle(HotRodServer.toMillis(maxIdle, maxIdleUnit));
            }
        }
        return metadata;
    }

    private static long toMillis(long duration, TimeUnitValue unit) {
        if (duration > 0L) {
            long milliseconds = unit.toTimeUnit().toMillis(duration);
            if (milliseconds > MILLISECONDS_IN_30_DAYS) {
                long unixTimeExpiry = milliseconds - System.currentTimeMillis();
                return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
            }
            return milliseconds;
        }
        return duration;
    }

    public int getWorkerThreads() {
        return Integer.getInteger("infinispan.server.hotrod.workerThreads", ((HotRodServerConfiguration)this.configuration).workerThreads());
    }

    public String toString() {
        return "HotRodServer[configuration=" + this.configuration + ']';
    }

    private class CacheInfoUpdateTask
    implements Runnable {
        private CacheInfoUpdateTask() {
        }

        @Override
        public void run() {
            for (CacheInfo cacheInfo : HotRodServer.this.knownCaches.values()) {
                HotRodServer.this.updateCacheInfo(cacheInfo);
            }
        }
    }

    @Listener
    class RemoveCacheListener {
        RemoveCacheListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            HotRodServer.this.knownCaches.remove(event.getCacheName());
        }
    }

    @Listener(sync=false, observation=Listener.Observation.POST)
    class ReAddMyAddressListener {
        private final Cache<Address, ServerAddress> addressCache;
        private final Address clusterAddress;
        private final ServerAddress address;

        ReAddMyAddressListener(Cache<Address, ServerAddress> addressCache, Address clusterAddress, ServerAddress address) {
            this.addressCache = addressCache;
            this.clusterAddress = clusterAddress;
            this.address = address;
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent<Address, ServerAddress> event) {
            boolean success = false;
            while (!success && this.addressCache.getStatus().allowInvocations()) {
                try {
                    CompletableFuture future = HotRodServer.this.clusterExecutor.submitConsumer((Function)new CheckAddressTask(this.addressCache.getName(), this.clusterAddress), (a, v, t) -> {
                        if (t != null) {
                            throw new CacheException(t);
                        }
                        if (!v.booleanValue()) {
                            log.debugf("Re-adding %s to the topology cache", this.clusterAddress);
                            this.addressCache.putAsync((Object)this.clusterAddress, (Object)this.address);
                        }
                    });
                    future.get();
                    success = true;
                }
                catch (Throwable e) {
                    log.debug("Error re-adding address to topology cache, retrying", e);
                }
            }
        }
    }

    public static class CacheInfo {
        final AdvancedCache<byte[], byte[]> anonymizedCache;
        final Map<KeyValuePair<MediaType, MediaType>, AdvancedCache<byte[], byte[]>> encodedCaches = new ConcurrentHashMap<KeyValuePair<MediaType, MediaType>, AdvancedCache<byte[], byte[]>>();
        final DistributionManager distributionManager;
        final VersionGenerator versionGenerator;
        final Configuration configuration;
        final boolean transactional;
        final boolean clustered;
        volatile boolean persistence;
        volatile boolean indexing;
        volatile boolean syncListener;

        CacheInfo(AdvancedCache<byte[], byte[]> cache, Configuration configuration) {
            this.anonymizedCache = SecurityActions.anonymizeSecureCache(cache);
            this.distributionManager = SecurityActions.getDistributionManager(cache);
            ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry(cache);
            this.versionGenerator = componentRegistry.getVersionGenerator();
            this.configuration = configuration;
            this.transactional = configuration.transaction().transactionMode().isTransactional();
            this.clustered = configuration.clustering().cacheMode().isClustered();
            this.persistence = true;
            this.indexing = true;
            this.syncListener = true;
        }

        AdvancedCache<byte[], byte[]> getCache(KeyValuePair<MediaType, MediaType> requestMediaTypes, Subject subject) {
            AdvancedCache cache = this.encodedCaches.get(requestMediaTypes);
            if (cache == null) {
                cache = this.anonymizedCache.withMediaType(((MediaType)requestMediaTypes.getKey()).getTypeSubtype(), ((MediaType)requestMediaTypes.getValue()).getTypeSubtype());
                this.encodedCaches.put(requestMediaTypes, (AdvancedCache<byte[], byte[]>)cache);
            }
            if (subject == null) {
                return cache;
            }
            return cache.withSubject(subject);
        }

        public void update(boolean enabled, boolean indexing, boolean syncListener) {
            this.persistence = enabled;
            this.indexing = indexing;
            this.syncListener = syncListener;
        }
    }

    @SerializeWith(value=ToEmptyBytesKeyValueFilterConverterExternalizer.class)
    static class ToEmptyBytesKeyValueFilterConverter
    extends AbstractKeyValueFilterConverter {
        public static ToEmptyBytesKeyValueFilterConverter INSTANCE = new ToEmptyBytesKeyValueFilterConverter();
        static final byte[] bytes = Util.EMPTY_BYTE_ARRAY;

        private ToEmptyBytesKeyValueFilterConverter() {
        }

        public Object filterAndConvert(Object key, Object value, Metadata metadata) {
            return bytes;
        }

        public MediaType format() {
            return null;
        }

        public static final class ToEmptyBytesKeyValueFilterConverterExternalizer
        implements Externalizer<ToEmptyBytesKeyValueFilterConverter> {
            public void writeObject(ObjectOutput output, ToEmptyBytesKeyValueFilterConverter object) {
            }

            public ToEmptyBytesKeyValueFilterConverter readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    class ToEmptyBytesFactory
    implements ParamKeyValueFilterConverterFactory {
        ToEmptyBytesFactory() {
        }

        public KeyValueFilterConverter getFilterConverter(Object[] params) {
            return ToEmptyBytesKeyValueFilterConverter.INSTANCE;
        }

        public boolean binaryParam() {
            return true;
        }
    }
}

