/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.server.hotrod.CacheNotFoundException;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.GetStreamResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.UnknownVersionException;
import org.infinispan.server.hotrod.VersionedDecoder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class CacheDecodeContext {
    static final long MillisecondsIn30days = 2592000000L;
    static final Log log = (Log)LogFactory.getLog(CacheDecodeContext.class, Log.class);
    static final boolean isTrace = log.isTraceEnabled();
    private final HotRodServer server;
    VersionedDecoder decoder;
    HotRodHeader header;
    Subject subject;
    AdvancedCache<byte[], byte[]> cache;
    byte[] key;
    RequestParameters params;
    Object operationDecodeContext;

    CacheDecodeContext(HotRodServer server) {
        this.server = server;
    }

    public HotRodHeader getHeader() {
        return this.header;
    }

    public byte[] getKey() {
        return this.key;
    }

    public RequestParameters getParams() {
        return this.params;
    }

    ErrorResponse createExceptionResponse(Throwable e) {
        if (e instanceof InvalidMagicIdException) {
            log.exceptionReported(e);
            return new ErrorResponse(0, 0L, "", 1, OperationStatus.InvalidMagicOrMsgId, 0, e.toString());
        }
        if (e instanceof HotRodUnknownOperationException) {
            log.exceptionReported(e);
            HotRodUnknownOperationException hruoe = (HotRodUnknownOperationException)e;
            return new ErrorResponse(hruoe.version, hruoe.messageId, "", 1, OperationStatus.UnknownOperation, 0, e.toString());
        }
        if (e instanceof UnknownVersionException) {
            log.exceptionReported(e);
            UnknownVersionException uve = (UnknownVersionException)e;
            return new ErrorResponse(uve.version, uve.messageId, "", 1, OperationStatus.UnknownVersion, 0, e.toString());
        }
        if (e instanceof RequestParsingException) {
            log.exceptionReported(e);
            String msg = e.getCause() == null ? e.toString() : String.format("%s: %s", e.getMessage(), e.getCause().toString());
            RequestParsingException rpe = (RequestParsingException)e;
            return new ErrorResponse(rpe.version, rpe.messageId, "", 1, OperationStatus.ParseError, 0, msg);
        }
        if (e instanceof IllegalStateException) {
            log.exceptionReported(e);
            return this.decoder.createErrorResponse(this.header, e);
        }
        if (this.decoder != null) {
            return this.decoder.createErrorResponse(this.header, e);
        }
        log.exceptionReported(e);
        return new ErrorResponse(0, 0L, "", 1, OperationStatus.ServerError, 1, e.toString());
    }

    Response replace() {
        byte[] prev = (byte[])this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).get((Object)this.key);
        if (prev != null) {
            prev = (byte[])this.cache.replace((Object)this.key, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
        }
        if (prev != null) {
            return this.successResp(prev);
        }
        return this.notExecutedResp(prev);
    }

    void obtainCache(EmbeddedCacheManager cacheManager, boolean loopback) throws RequestParsingException {
        String cacheName = this.header.cacheName;
        AdvancedCache cache = this.server.getKnownCacheInstance(cacheName);
        if (cache == null) {
            InternalCacheRegistry icr = (InternalCacheRegistry)cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
            if (icr.isPrivateCache(cacheName)) {
                throw new RequestParsingException(String.format("Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", cacheName), this.header.version, this.header.messageId);
            }
            if (icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.PROTECTED)) {
                if (!cacheManager.getCacheManagerConfiguration().security().authorization().enabled() && !loopback) {
                    throw new RequestParsingException(String.format("Remote requests are allowed to protected caches only over loopback or if authorization is enabled. Do no send remote requests to cache '%s'", cacheName), this.header.version, this.header.messageId);
                }
                cache = this.server.getCacheInstance(cacheName, cacheManager, true, false);
            } else {
                if (!cacheName.isEmpty() && !cacheManager.getCacheNames().contains(cacheName)) {
                    throw new CacheNotFoundException(String.format("Cache with name '%s' not found amongst the configured caches", cacheName), this.header.version, this.header.messageId);
                }
                cache = this.server.getCacheInstance(cacheName, cacheManager, true, true);
            }
        }
        this.cache = this.decoder.getOptimizedCache(this.header, (AdvancedCache<byte[], byte[]>)cache, this.server.getCacheConfiguration(cacheName));
    }

    Metadata buildMetadata() {
        EmbeddedMetadata.Builder metadata = new EmbeddedMetadata.Builder();
        metadata.version(this.generateVersion(this.server.getCacheRegistry(this.header.cacheName), (Cache<byte[], byte[]>)this.cache));
        if (this.params.lifespan.duration != -2L) {
            metadata.lifespan(CacheDecodeContext.toMillis(this.params.lifespan, this.header));
        }
        if (this.params.maxIdle.duration != -2L) {
            metadata.maxIdle(CacheDecodeContext.toMillis(this.params.maxIdle, this.header));
        }
        return metadata.build();
    }

    Response get() {
        return this.createGetResponse((CacheEntry<byte[], byte[]>)this.cache.getCacheEntry((Object)this.key));
    }

    Response getKeyMetadata() {
        CacheEntry ce = this.cache.getCacheEntry((Object)this.key);
        if (ce != null) {
            long version;
            NumericVersion entryVersion = (NumericVersion)ce.getMetadata().version();
            byte[] v = (byte[])ce.getValue();
            int lifespan = ce.getLifespan() < 0L ? -1 : (int)ce.getLifespan() / 1000;
            int maxIdle = ce.getMaxIdle() < 0L ? -1 : (int)ce.getMaxIdle() / 1000;
            long l = version = entryVersion != null ? entryVersion.getVersion() : 0L;
            if (this.header.op == HotRodOperation.GET_WITH_METADATA) {
                return new GetWithMetadataResponse(this.header.version, this.header.messageId, this.header.cacheName, this.header.clientIntel, this.header.op, OperationStatus.Success, this.header.topologyId, v, version, ce.getCreated(), lifespan, ce.getLastUsed(), maxIdle);
            }
            int offset = (Integer)this.operationDecodeContext;
            return new GetStreamResponse(this.header.version, this.header.messageId, this.header.cacheName, this.header.clientIntel, this.header.op, OperationStatus.Success, this.header.topologyId, v, offset, version, ce.getCreated(), lifespan, ce.getLastUsed(), maxIdle);
        }
        if (this.header.op == HotRodOperation.GET_WITH_METADATA) {
            return new GetWithMetadataResponse(this.header.version, this.header.messageId, this.header.cacheName, this.header.clientIntel, this.header.op, OperationStatus.KeyDoesNotExist, this.header.topologyId);
        }
        return new GetStreamResponse(this.header.version, this.header.messageId, this.header.cacheName, this.header.clientIntel, this.header.op, OperationStatus.KeyDoesNotExist, this.header.topologyId);
    }

    Response containsKey() {
        if (this.cache.containsKey((Object)this.key)) {
            return this.successResp(null);
        }
        return this.notExistResp();
    }

    Response replaceIfUnmodified() {
        CacheEntry entry = this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getCacheEntry((Object)this.key);
        if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                boolean replaced = this.cache.replace((Object)this.key, (Object)prev, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
                if (replaced) {
                    return this.successResp(prev);
                }
                return this.notExecutedResp(prev);
            }
            return this.notExecutedResp(prev);
        }
        return this.notExistResp();
    }

    Response putIfAbsent() {
        byte[] prev = (byte[])this.cache.get((Object)this.key);
        if (prev == null) {
            prev = (byte[])this.cache.putIfAbsent((Object)this.key, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
        }
        if (prev == null) {
            return this.successResp(prev);
        }
        return this.notExecutedResp(prev);
    }

    Response put() {
        byte[] prev = (byte[])this.cache.put((Object)this.key, (Object)((byte[])this.operationDecodeContext), this.buildMetadata());
        return this.successResp(prev);
    }

    EntryVersion generateVersion(ComponentRegistry registry, Cache<byte[], byte[]> cache) {
        VersionGenerator cacheVersionGenerator = registry.getVersionGenerator();
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator().clustered(registry.getComponent(RpcManager.class) != null);
            registry.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
            return newVersionGenerator.generateNew();
        }
        return cacheVersionGenerator.generateNew();
    }

    Response remove() {
        byte[] prev = (byte[])this.cache.remove((Object)this.key);
        if (prev != null) {
            return this.successResp(prev);
        }
        return this.notExistResp();
    }

    Response removeIfUnmodified() {
        CacheEntry entry = this.cache.getCacheEntry((Object)this.key);
        if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                boolean removed = this.cache.remove((Object)this.key, (Object)prev);
                if (removed) {
                    return this.successResp(prev);
                }
                return this.notExecutedResp(prev);
            }
            return this.notExecutedResp(prev);
        }
        return this.notExistResp();
    }

    Response clear() {
        this.cache.clear();
        return this.successResp(null);
    }

    Response successResp(byte[] prev) {
        return this.decoder.createSuccessResponse(this.header, prev);
    }

    Response notExecutedResp(byte[] prev) {
        return this.decoder.createNotExecutedResponse(this.header, prev);
    }

    Response notExistResp() {
        return this.decoder.createNotExistResponse(this.header);
    }

    Response createGetResponse(CacheEntry<byte[], byte[]> entry) {
        return this.decoder.createGetResponse(this.header, entry);
    }

    ComponentRegistry getCacheRegistry(String cacheName) {
        return this.server.getCacheRegistry(cacheName);
    }

    static long toMillis(ExpirationParam param, HotRodHeader h) {
        if (param.duration > 0L) {
            long milliseconds = param.unit.toTimeUnit().toMillis(param.duration);
            if (milliseconds > 2592000000L) {
                long unixTimeExpiry = milliseconds - System.currentTimeMillis();
                return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
            }
            return milliseconds;
        }
        return param.duration;
    }

    static class RequestParameters {
        final int valueLength;
        final ExpirationParam lifespan;
        final ExpirationParam maxIdle;
        final long streamVersion;

        RequestParameters(int valueLength, ExpirationParam lifespan, ExpirationParam maxIdle, long streamVersion) {
            this.valueLength = valueLength;
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
            this.streamVersion = streamVersion;
        }

        public String toString() {
            return "RequestParameters{valueLength=" + this.valueLength + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", streamVersion=" + this.streamVersion + '}';
        }
    }

    static class ExpirationParam {
        final long duration;
        final TimeUnitValue unit;

        ExpirationParam(long duration, TimeUnitValue unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public String toString() {
            return "ExpirationParam{duration=" + this.duration + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }
}

