/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.security.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.InetAddressPrincipal;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.external.ExternalSaslServerFactory;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.hotrod.AuthMechListResponse;
import org.infinispan.server.hotrod.AuthResponse;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.ResponseWriting;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.KeyValuePair;

public class AuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private static final Log log = (Log)LogFactory.getLog(AuthenticationHandler.class, Log.class);
    private final HotRodServer server;
    private final HotRodServerConfiguration serverConfig;
    private final AuthenticationConfiguration authenticationConfig;
    private final boolean requireAuthentication;
    private SaslServer saslServer;
    private AuthorizingCallbackHandler callbackHandler;
    private Subject subject = ANONYMOUS;
    private static final Subject ANONYMOUS = new Subject();

    public AuthenticationHandler(HotRodServer server) {
        this.server = server;
        this.serverConfig = (HotRodServerConfiguration)server.getConfiguration();
        this.authenticationConfig = ((HotRodServerConfiguration)server.getConfiguration()).authentication();
        this.requireAuthentication = !this.authenticationConfig.mechProperties().containsKey("javax.security.sasl.policy.noanonymous") || this.authenticationConfig.mechProperties().get("javax.security.sasl.policy.noanonymous").equals("true");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block19: {
            block18: {
                if (!(msg instanceof CacheDecodeContext)) break block18;
                CacheDecodeContext cdc = (CacheDecodeContext)msg;
                HotRodHeader hrh = cdc.header;
                HotRodOperation op = hrh.op;
                switch (op) {
                    case AUTH_MECH_LIST: {
                        ResponseWriting.writeResponse(ctx.channel(), new AuthMechListResponse(hrh.version, hrh.messageId, hrh.cacheName, hrh.clientIntel, this.authenticationConfig.allowedMechs(), hrh.topologyId));
                        break;
                    }
                    case AUTH: {
                        SslHandler sslHandler;
                        if (!this.serverConfig.authentication().enabled()) {
                            cdc.decoder.createErrorResponse(hrh, log.invalidOperation());
                            break;
                        }
                        KeyValuePair opContext = (KeyValuePair)cdc.operationDecodeContext;
                        if (this.saslServer == null) {
                            SaslServerFactory ssf;
                            ServerAuthenticationProvider sap = this.authenticationConfig.serverAuthenticationProvider();
                            String mech = (String)opContext.getKey();
                            this.callbackHandler = sap.getCallbackHandler(mech, this.authenticationConfig.mechProperties());
                            if ("EXTERNAL".equals(mech)) {
                                sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                                try {
                                    if (sslHandler == null) {
                                        throw log.externalMechNotAllowedWithoutSSLClientCert();
                                    }
                                    ssf = new ExternalSaslServerFactory(sslHandler.engine().getSession().getPeerPrincipal());
                                }
                                catch (SSLPeerUnverifiedException e) {
                                    throw log.externalMechNotAllowedWithoutSSLClientCert();
                                }
                            } else {
                                ssf = this.server.getSaslServerFactory(mech);
                            }
                            this.saslServer = this.authenticationConfig.serverSubject() != null ? Subject.doAs(this.authenticationConfig.serverSubject(), () -> ssf.createSaslServer(mech, "hotrod", this.authenticationConfig.serverName(), this.authenticationConfig.mechProperties(), (CallbackHandler)this.callbackHandler)) : ssf.createSaslServer(mech, "hotrod", this.authenticationConfig.serverName(), this.authenticationConfig.mechProperties(), (CallbackHandler)this.callbackHandler);
                        }
                        byte[] serverChallenge = this.saslServer.evaluateResponse((byte[])opContext.getValue());
                        ResponseWriting.writeResponse(ctx.channel(), new AuthResponse(hrh.version, hrh.messageId, hrh.cacheName, hrh.clientIntel, serverChallenge, hrh.topologyId));
                        if (this.saslServer.isComplete()) {
                            ArrayList<Object> extraPrincipals = new ArrayList<Object>();
                            String id = this.normalizeAuthorizationId(this.saslServer.getAuthorizationID());
                            extraPrincipals.add(new SimpleUserPrincipal(id));
                            extraPrincipals.add(new InetAddressPrincipal(((InetSocketAddress)ctx.channel().remoteAddress()).getAddress()));
                            sslHandler = (SslHandler)ctx.pipeline().get("ssl");
                            try {
                                if (sslHandler != null) {
                                    extraPrincipals.add(sslHandler.engine().getSession().getPeerPrincipal());
                                }
                            }
                            catch (SSLPeerUnverifiedException e) {
                                // empty catch block
                            }
                            this.subject = this.callbackHandler.getSubjectUserInfo(extraPrincipals).getSubject();
                            String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                            if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
                                SaslQopHandler qopHandler = new SaslQopHandler(this.saslServer);
                                ctx.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
                                break;
                            }
                            this.saslServer.dispose();
                            this.callbackHandler = null;
                            this.saslServer = null;
                            break;
                        }
                        break block19;
                    }
                    default: {
                        if (this.requireAuthentication && op.requiresAuthentication() && this.subject == ANONYMOUS) {
                            throw log.unauthorizedOperation();
                        }
                        if (op.requiresAuthentication()) {
                            ((CacheDecodeContext)msg).withSubect(this.subject);
                        }
                        super.channelRead(ctx, msg);
                    }
                }
                break block19;
            }
            super.channelRead(ctx, msg);
        }
    }

    String normalizeAuthorizationId(String id) {
        int realm = id.indexOf(64);
        if (realm >= 0) {
            return id.substring(0, realm);
        }
        return id;
    }
}

