/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.tx.ControlByte;

class TransactionWrite {
    final byte[] key;
    final long versionRead;
    final CacheDecodeContext.ExpirationParam lifespan;
    final CacheDecodeContext.ExpirationParam maxIdle;
    final byte[] value;
    private final byte control;

    TransactionWrite(byte[] key, long versionRead, byte control, CacheDecodeContext.ExpirationParam lifespan, CacheDecodeContext.ExpirationParam maxIdle, byte[] value) {
        this.key = key;
        this.versionRead = versionRead;
        this.control = control;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.value = value;
    }

    public boolean isRemove() {
        return ControlByte.REMOVE_OP.hasFlag(this.control);
    }

    public String toString() {
        return "TransactionWrite{key=" + Util.printArray((byte[])this.key, (boolean)true) + ", versionRead=" + this.versionRead + ", control=" + ControlByte.prettyPrint(this.control) + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", value=" + Util.printArray((byte[])this.value, (boolean)true) + '}';
    }

    boolean skipRead() {
        return ControlByte.NOT_READ.hasFlag(this.control);
    }

    boolean wasNonExisting() {
        return ControlByte.NON_EXISTING.hasFlag(this.control);
    }
}

