/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Consumer;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.util.EncodeUtil;
import org.infinispan.server.hotrod.counter.CounterDecodeContext;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.util.logging.LogFactory;

public class CounterCreateDecodeContext
extends CounterDecodeContext {
    private static final Log log = (Log)LogFactory.getLog(CounterCreateDecodeContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private DecodeState decodeState = DecodeState.DECODE_FLAGS;
    private CounterConfiguration.Builder builder;

    public CounterConfiguration getConfiguration() {
        return this.builder.build();
    }

    @Override
    CounterDecodeContext.DecodeStep nextStep() {
        switch (this.decodeState) {
            case DECODE_DONE: {
                return null;
            }
            case DECODE_INITIAL_VALUE: {
                return buffer -> this.decodeLong(buffer, this::setInitialValue);
            }
            case DECODE_UPPER_BOUND: {
                return buffer -> this.decodeLong(buffer, this::setUpperBound);
            }
            case DECODE_LOWER_BOUND: {
                return buffer -> this.decodeLong(buffer, this::setLowerBound);
            }
            case DECODE_CONCURRENCY: {
                return this::decodeConcurrencyLevel;
            }
            case DECODE_FLAGS: {
                return this::decodeFlags;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    boolean trace() {
        return trace;
    }

    @Override
    Log log() {
        return log;
    }

    private boolean decodeLong(ByteBuf buffer, Consumer<Long> consumer) {
        Optional<Long> optValue = ExtendedByteBuf.readMaybeLong(buffer);
        optValue.ifPresent(consumer);
        return !optValue.isPresent();
    }

    private void setInitialValue(long value) {
        this.builder.initialValue(value);
        this.decodeState = DecodeState.DECODE_DONE;
        this.logDecoded("initial-value", value);
    }

    private void setUpperBound(long value) {
        this.builder.upperBound(value);
        this.decodeState = DecodeState.DECODE_INITIAL_VALUE;
        this.logDecoded("upper-bound", value);
    }

    private void setLowerBound(long value) {
        this.builder.lowerBound(value);
        this.decodeState = DecodeState.DECODE_UPPER_BOUND;
        this.logDecoded("lower-bound", value);
    }

    private void setConcurrencyLevel(int value) {
        this.builder.concurrencyLevel(value);
        this.decodeState = DecodeState.DECODE_INITIAL_VALUE;
        this.logDecoded("concurrency-level", value);
    }

    private boolean decodeConcurrencyLevel(ByteBuf buffer) {
        Optional<Integer> optConcurrency = ExtendedByteBuf.readMaybeVInt(buffer);
        optConcurrency.ifPresent(this::setConcurrencyLevel);
        return !optConcurrency.isPresent();
    }

    private void createBuilderAndSetStorage(byte flags) {
        this.createBuilder(flags);
        this.setStorage(flags);
    }

    private void setStorage(byte flags) {
        Storage storage = EncodeUtil.decodeStorage((byte)flags);
        this.builder.storage(storage);
        this.logDecoded("storage", storage);
    }

    private void createBuilder(byte flags) {
        CounterType type = EncodeUtil.decodeType((byte)flags);
        this.builder = CounterConfiguration.builder((CounterType)type);
        this.logDecoded("counter-type", type);
        switch (type) {
            case WEAK: {
                this.decodeState = DecodeState.DECODE_CONCURRENCY;
                break;
            }
            case BOUNDED_STRONG: {
                this.decodeState = DecodeState.DECODE_LOWER_BOUND;
                break;
            }
            case UNBOUNDED_STRONG: {
                this.decodeState = DecodeState.DECODE_INITIAL_VALUE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown flag " + flags);
            }
        }
    }

    private boolean decodeFlags(ByteBuf buffer) {
        Optional<Byte> optFlags = ExtendedByteBuf.readMaybeByte(buffer);
        optFlags.ifPresent(this::createBuilderAndSetStorage);
        return !optFlags.isPresent();
    }

    private static enum DecodeState {
        DECODE_FLAGS,
        DECODE_INITIAL_VALUE,
        DECODE_UPPER_BOUND,
        DECODE_LOWER_BOUND,
        DECODE_CONCURRENCY,
        DECODE_DONE;

    }
}

