/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.AuthMechListResponse;
import org.infinispan.server.hotrod.AuthResponse;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.Events;
import org.infinispan.server.hotrod.ExecResponse;
import org.infinispan.server.hotrod.GetAllResponse;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetStreamResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HashDistAware20Response;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.IterationNextResponse;
import org.infinispan.server.hotrod.IterationStartResponse;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.SizeResponse;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.TransactionResponse;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.counter.listener.ClientCounterEvent;
import org.infinispan.server.hotrod.counter.response.CounterResponse;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.multimap.MultimapGetWithMetadataResponse;
import org.infinispan.server.hotrod.multimap.MultimapResponse;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.topology.CacheTopology;

class Encoder2x
implements VersionedEncoder {
    private static final Log log = (Log)LogFactory.getLog(Encoder2x.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();

    Encoder2x() {
    }

    @Override
    public void writeEvent(Events.Event e, ByteBuf buf) {
        if (isTrace) {
            log.tracef("Write event %s", e);
        }
        this.writeHeaderNoTopology(buf, e.messageId, e.op);
        ExtendedByteBuf.writeRangedBytes(e.listenerId, buf);
        e.writeEvent(buf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeHeader(Response r, ByteBuf buf, Cache<Address, ServerAddress> addressCache, HotRodServer server) {
        boolean compatibilityEnabled;
        Optional<AbstractTopologyResponse> newTopology;
        CacheTopology cacheTopology;
        String cacheName;
        String string = cacheName = r.cacheName.isEmpty() ? ((HotRodServerConfiguration)server.getConfiguration()).defaultCacheName() : r.cacheName;
        if ("org.infinispan.COUNTER".equals(cacheName)) {
            cacheTopology = this.getCounterCacheTopology(server.getCacheManager());
            newTopology = this.getTopologyResponse(r, addressCache, CacheMode.DIST_SYNC, cacheTopology);
            compatibilityEnabled = false;
        } else {
            ComponentRegistry cr = server.getCacheRegistry(cacheName);
            Configuration configuration = server.getCacheConfiguration(cacheName);
            CacheMode cacheMode = configuration == null ? CacheMode.LOCAL : configuration.clustering().cacheMode();
            cacheTopology = cacheMode.isClustered() ? cr.getDistributionManager().getCacheTopology() : null;
            newTopology = this.getTopologyResponse(r, addressCache, cacheMode, cacheTopology);
            compatibilityEnabled = configuration != null && configuration.compatibility().enabled();
        }
        buf.writeByte(161);
        ExtendedByteBuf.writeUnsignedLong(r.messageId, buf);
        buf.writeByte(r.operation.getResponseOpCode());
        this.writeStatus(r, buf, server, compatibilityEnabled);
        if (newTopology.isPresent()) {
            AbstractTopologyResponse topology = newTopology.get();
            if (topology instanceof TopologyAwareResponse) {
                this.writeTopologyUpdate((TopologyAwareResponse)topology, buf);
                if (r.clientIntel != 3) return;
                this.writeEmptyHashInfo(topology, buf);
                return;
            } else {
                if (!(topology instanceof HashDistAware20Response)) throw new IllegalArgumentException("Unsupported response: " + topology);
                this.writeHashTopologyUpdate((HashDistAware20Response)topology, cacheTopology, buf);
            }
            return;
        } else {
            if (isTrace) {
                log.trace("Write topology response header with no change");
            }
            buf.writeByte(0);
        }
    }

    @Override
    public void writeCounterEvent(ClientCounterEvent event, ByteBuf buffer) {
        this.writeHeaderNoTopology(buffer, 0L, HotRodOperation.COUNTER_EVENT);
        event.writeTo(buffer);
    }

    private CacheTopology getCounterCacheTopology(EmbeddedCacheManager cacheManager) {
        AdvancedCache cache = cacheManager.getCache("org.infinispan.COUNTER").getAdvancedCache();
        return cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? cache.getComponentRegistry().getDistributionManager().getCacheTopology() : null;
    }

    private void writeHeaderNoTopology(ByteBuf buffer, long messageId, HotRodOperation operation) {
        buffer.writeByte(161);
        ExtendedByteBuf.writeUnsignedLong(messageId, buffer);
        buffer.writeByte(operation.getResponseOpCode());
        buffer.writeByte((int)OperationStatus.Success.getCode());
        buffer.writeByte(0);
    }

    private void writeStatus(Response r, ByteBuf buf, HotRodServer server, boolean compatibilityEnabled) {
        if (server == null || HotRodVersion.HOTROD_24.isOlder(r.version)) {
            buf.writeByte((int)r.status.getCode());
        } else {
            OperationStatus st = OperationStatus.withCompatibility(r.status, compatibilityEnabled);
            buf.writeByte((int)st.getCode());
        }
    }

    private void writeTopologyUpdate(TopologyAwareResponse t, ByteBuf buffer) {
        Map topologyMap = t.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            log.noMembersInTopology();
            buffer.writeByte(0);
        } else {
            if (isTrace) {
                log.tracef("Write topology change response header %s", t);
            }
            buffer.writeByte(1);
            ExtendedByteBuf.writeUnsignedInt(t.topologyId, buffer);
            ExtendedByteBuf.writeUnsignedInt(topologyMap.size(), buffer);
            for (ServerAddress address : topologyMap.values()) {
                ExtendedByteBuf.writeString(address.getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
            }
        }
    }

    private void writeEmptyHashInfo(AbstractTopologyResponse t, ByteBuf buffer) {
        if (isTrace) {
            log.tracef("Return limited hash distribution aware header because the client %s doesn't ", t);
        }
        buffer.writeByte(0);
        ExtendedByteBuf.writeUnsignedInt(t.numSegments, buffer);
    }

    private void writeHashTopologyUpdate(HashDistAware20Response h, CacheTopology cacheTopology, ByteBuf buf) {
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        Map<Address, ServerAddress> members = h.serverEndpointsMap.entrySet().stream().filter(e -> ch.getMembers().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (isTrace) {
            log.trace("Topology cache contains: " + h.serverEndpointsMap);
            log.trace("After read consistent hash filter, members are: " + members);
        }
        if (members.isEmpty()) {
            log.noMembersInHashTopology(ch, h.serverEndpointsMap.toString());
            buf.writeByte(0);
        } else {
            if (isTrace) {
                log.tracef("Write hash distribution change response header %s", h);
            }
            buf.writeByte(1);
            ExtendedByteBuf.writeUnsignedInt(h.topologyId, buf);
            AtomicInteger indexCount = new AtomicInteger(-1);
            ExtendedByteBuf.writeUnsignedInt(members.size(), buf);
            HashMap indexedMembers = new HashMap();
            members.forEach((addr, serverAddr) -> {
                ExtendedByteBuf.writeString(serverAddr.getHost(), buf);
                ExtendedByteBuf.writeUnsignedShort(serverAddr.getPort(), buf);
                indexCount.incrementAndGet();
                indexedMembers.put(addr, indexCount.get());
            });
            int numSegments = ch.getNumSegments();
            buf.writeByte((int)h.hashFunction);
            ExtendedByteBuf.writeUnsignedInt(numSegments, buf);
            for (int segmentId = 0; segmentId < numSegments; ++segmentId) {
                List<Address> owners = ch.locateOwnersForSegment(segmentId).stream().filter(members::containsKey).collect(Collectors.toList());
                int ownersSize = owners.size();
                if (ownersSize == 0) {
                    buf.writeByte(1);
                    ExtendedByteBuf.writeUnsignedInt(0, buf);
                    continue;
                }
                buf.writeByte(ownersSize);
                owners.forEach(ownerAddr -> {
                    Integer index = (Integer)indexedMembers.get(ownerAddr);
                    if (index != null) {
                        ExtendedByteBuf.writeUnsignedInt(index, buf);
                    }
                });
            }
        }
    }

    private Optional<AbstractTopologyResponse> getTopologyResponse(Response r, Cache<Address, ServerAddress> addressCache, CacheMode cacheMode, CacheTopology cacheTopology) {
        if (addressCache != null) {
            switch (r.clientIntel) {
                case 2: 
                case 3: {
                    int currentTopologyId;
                    if (!cacheMode.isClustered() || r.topologyId >= (currentTopologyId = cacheTopology.getTopologyId())) break;
                    return this.generateTopologyResponse(r, addressCache, cacheMode, cacheTopology);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<AbstractTopologyResponse> generateTopologyResponse(Response r, Cache<Address, ServerAddress> addressCache, CacheMode cacheMode, CacheTopology cacheTopology) {
        int currentTopologyId = cacheTopology.getTopologyId();
        List cacheMembers = cacheTopology.getMembers();
        HashMap<Address, ServerAddress> serverEndpoints = new HashMap<Address, ServerAddress>();
        addressCache.forEach(serverEndpoints::put);
        int topologyId = currentTopologyId;
        if (isTrace) {
            log.tracef("Check for partial topologies: members=%s, endpoints=%s, client-topology=%s, server-topology=%s", new Object[]{cacheMembers, cacheMembers, r.topologyId, topologyId});
        }
        if (!serverEndpoints.keySet().containsAll(cacheMembers)) {
            int clientTopologyId = r.topologyId;
            if (currentTopologyId - clientTopologyId < 2) {
                if (isTrace) {
                    log.trace("Postpone topology update");
                }
                return Optional.empty();
            }
            --topologyId;
            if (isTrace) {
                log.tracef("Send partial topology update with topology id %s", topologyId);
            }
        }
        if (r.clientIntel == 3 && !cacheMode.isInvalidation()) {
            int numSegments = cacheTopology.getReadConsistentHash().getNumSegments();
            return Optional.of(new HashDistAware20Response(topologyId, serverEndpoints, numSegments, 3));
        }
        return Optional.of(new TopologyAwareResponse(topologyId, serverEndpoints, 0));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeResponse(Response response, ByteBuf buf, EmbeddedCacheManager cacheManager, HotRodServer server) {
        switch (1.$SwitchMap$org$infinispan$server$hotrod$HotRodOperation[response.operation.ordinal()]) {
            case 1: {
                r = (GetResponse)response;
                if (r.status != OperationStatus.Success) break;
                ExtendedByteBuf.writeRangedBytes(r.data, buf);
                break;
            }
            case 2: {
                r = (GetWithMetadataResponse)response;
                if (r.status != OperationStatus.Success) break;
                MetadataUtils.writeMetadata(r.lifespan, r.maxIdle, r.created, r.lastUsed, r.dataVersion, buf);
                ExtendedByteBuf.writeRangedBytes(r.data, buf);
                break;
            }
            case 3: {
                r = (GetWithVersionResponse)response;
                if (r.status != OperationStatus.Success) break;
                buf.writeLong(r.dataVersion);
                ExtendedByteBuf.writeRangedBytes(r.data, buf);
                break;
            }
            case 4: {
                r = (GetStreamResponse)response;
                if (r.status != OperationStatus.Success) break;
                MetadataUtils.writeMetadata(r.lifespan, r.maxIdle, r.created, r.lastUsed, r.dataVersion, buf);
                ExtendedByteBuf.writeRangedBytes(r.data, r.offset, buf);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (!(response instanceof ResponseWithPrevious)) break;
                r = (ResponseWithPrevious)response;
                if (!r.previous.isPresent()) {
                    ExtendedByteBuf.writeUnsignedInt(0, buf);
                    break;
                }
                ExtendedByteBuf.writeRangedBytes(r.previous.get(), buf);
                break;
            }
            case 11: {
                r = (StatsResponse)response;
                ExtendedByteBuf.writeUnsignedInt(r.stats.size(), buf);
                for (Map.Entry<String, String> stat : r.stats.entrySet()) {
                    ExtendedByteBuf.writeString(stat.getKey(), buf);
                    ExtendedByteBuf.writeString(stat.getValue(), buf);
                }
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (response.status != OperationStatus.Success) break;
                ((CounterResponse)response).writeTo(buf);
                break;
            }
            case 31: {
                r = (SizeResponse)response;
                ExtendedByteBuf.writeUnsignedLong(r.size, buf);
                break;
            }
            case 32: {
                r = (AuthMechListResponse)response;
                ExtendedByteBuf.writeUnsignedInt(r.mechs.size(), buf);
                r.mechs.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeResponse$3(io.netty.buffer.ByteBuf java.lang.String ), (Ljava/lang/String;)V)((ByteBuf)buf));
                break;
            }
            case 33: {
                r = (AuthResponse)response;
                if (r.challenge != null) {
                    buf.writeBoolean(false);
                    ExtendedByteBuf.writeRangedBytes(r.challenge, buf);
                    break;
                }
                buf.writeBoolean(true);
                ExtendedByteBuf.writeUnsignedInt(0, buf);
                break;
            }
            case 34: {
                r = (ExecResponse)response;
                ExtendedByteBuf.writeRangedBytes(r.result, buf);
                break;
            }
            case 35: {
                r = (BulkGetResponse)response;
                if (Encoder2x.isTrace) {
                    Encoder2x.log.trace("About to respond to bulk get request");
                }
                if (r.status != OperationStatus.Success) break;
                iterator = r.entries.iterator();
                stat = null;
                max = 0x7FFFFFFF;
                if (r.count != 0) {
                    if (Encoder2x.isTrace) {
                        Encoder2x.log.tracef("About to write (max) %d messages to the client", r.count);
                    }
                    max = r.count;
                }
                for (count = 0; iterator.hasNext() && count < max; ++count) {
                    entry = (Map.Entry)iterator.next();
                    buf.writeByte(1);
                    ExtendedByteBuf.writeRangedBytes((byte[])entry.getKey(), buf);
                    ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), buf);
                }
                buf.writeByte(0);
                if (iterator == null) break;
                if (stat == null) ** GOTO lbl102
                try {
                    iterator.close();
                }
                catch (Throwable var8_38) {
                    stat.addSuppressed(var8_38);
                }
                break;
lbl102:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var8_39) {
                    try {
                        stat = var8_39;
                        throw var8_39;
                    }
                    catch (Throwable var11_42) {
                        if (iterator != null) {
                            if (stat != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var12_43) {
                                    stat.addSuppressed(var12_43);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var11_42;
                    }
                }
            }
            case 36: {
                r = (BulkGetKeysResponse)response;
                if (r.status != OperationStatus.Success) break;
                r.iterator.forEachRemaining((Consumer<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeResponse$4(io.netty.buffer.ByteBuf byte[] ), ([B)V)((ByteBuf)buf));
                buf.writeByte(0);
                break;
            }
            case 37: {
                r = (QueryResponse)response;
                ExtendedByteBuf.writeRangedBytes(r.result, buf);
                break;
            }
            case 38: {
                r = (IterationStartResponse)response;
                ExtendedByteBuf.writeString(r.iterationId, buf);
                break;
            }
            case 39: {
                r = (IterationNextResponse)response;
                ExtendedByteBuf.writeRangedBytes(r.iterationResult.segmentsToBytes(), buf);
                entries = r.iterationResult.getEntries();
                ExtendedByteBuf.writeUnsignedInt(entries.size(), buf);
                projectionLength = Encoder2x.projectionInfo(entries, r.version);
                projectionLength.ifPresent((Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeResponse$5(io.netty.buffer.ByteBuf java.lang.Integer ), (Ljava/lang/Integer;)V)((ByteBuf)buf));
                entries.forEach((Consumer<CacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeResponse$6(org.infinispan.server.hotrod.IterationNextResponse io.netty.buffer.ByteBuf org.infinispan.container.entries.CacheEntry ), (Lorg/infinispan/container/entries/CacheEntry;)V)((IterationNextResponse)r, (ByteBuf)buf));
                break;
            }
            case 40: {
                r = (GetAllResponse)response;
                if (r.status != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt(r.entries.size(), buf);
                r.entries.forEach((BiConsumer<byte[], byte[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$writeResponse$7(io.netty.buffer.ByteBuf byte[] byte[] ), ([B[B)V)((ByteBuf)buf));
                break;
            }
            case 41: {
                r = (ErrorResponse)response;
                ExtendedByteBuf.writeString(r.msg, buf);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                throw new UnsupportedOperationException(response.toString());
            }
            case 46: 
            case 47: 
            case 48: {
                txRsp = (TransactionResponse)response;
                if (txRsp.status != OperationStatus.Success) break;
                buf.writeInt(txRsp.xaReturnCode);
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt(((Collection)r.getResult()).size(), buf);
                ((Collection)r.getResult()).forEach((Consumer<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeResponse$8(io.netty.buffer.ByteBuf byte[] ), ([B)V)((ByteBuf)buf));
                break;
            }
            case 51: {
                r = (MultimapGetWithMetadataResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                MetadataUtils.writeMetadata(r.getLifespan(), r.getMaxIdle(), r.getCreated(), r.getLastUsed(), r.getDataVersion(), buf);
                ExtendedByteBuf.writeUnsignedInt(((Collection)r.getResult()).size(), buf);
                ((Collection)r.getResult()).forEach((Consumer<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeResponse$9(io.netty.buffer.ByteBuf byte[] ), ([B)V)((ByteBuf)buf));
                break;
            }
            case 52: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case 53: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case 54: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedLong((Long)r.getResult(), buf);
                break;
            }
            case 55: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case 56: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case 57: {
                r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            default: {
                throw new UnsupportedOperationException(response.toString());
            }
        }
    }

    static Optional<Integer> projectionInfo(List<CacheEntry> entries, byte version) {
        if (!entries.isEmpty()) {
            CacheEntry entry = entries.get(0);
            if (entry.getValue() instanceof Object[]) {
                return Optional.of(((Object[])entry.getValue()).length);
            }
            if (HotRodVersion.HOTROD_24.isAtLeast(version)) {
                return Optional.of(1);
            }
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$writeResponse$9(ByteBuf buf, byte[] v) {
        ExtendedByteBuf.writeRangedBytes(v, buf);
    }

    private static /* synthetic */ void lambda$writeResponse$8(ByteBuf buf, byte[] v) {
        ExtendedByteBuf.writeRangedBytes(v, buf);
    }

    private static /* synthetic */ void lambda$writeResponse$7(ByteBuf buf, byte[] k, byte[] v) {
        ExtendedByteBuf.writeRangedBytes(k, buf);
        ExtendedByteBuf.writeRangedBytes(v, buf);
    }

    private static /* synthetic */ void lambda$writeResponse$6(IterationNextResponse r, ByteBuf buf, CacheEntry cacheEntry) {
        if (HotRodVersion.HOTROD_25.isAtLeast(r.version)) {
            if (r.iterationResult.isMetadata()) {
                buf.writeByte(1);
                InternalCacheEntry ice = (InternalCacheEntry)cacheEntry;
                int lifespan = ice.getLifespan() < 0L ? -1 : (int)(ice.getLifespan() / 1000L);
                int maxIdle = ice.getMaxIdle() < 0L ? -1 : (int)(ice.getMaxIdle() / 1000L);
                long lastUsed = ice.getLastUsed();
                long created = ice.getCreated();
                long dataVersion = MetadataUtils.extractVersion((CacheEntry)ice);
                MetadataUtils.writeMetadata(lifespan, maxIdle, created, lastUsed, dataVersion, buf);
            } else {
                buf.writeByte(0);
            }
        }
        Object key = r.iterationResult.getResultFunction().apply(cacheEntry.getKey());
        Object value = cacheEntry.getValue();
        ExtendedByteBuf.writeRangedBytes((byte[])key, buf);
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                ExtendedByteBuf.writeRangedBytes((byte[])o, buf);
            }
        } else if (value instanceof byte[]) {
            ExtendedByteBuf.writeRangedBytes((byte[])value, buf);
        } else {
            throw new IllegalArgumentException("Unsupported type passed: " + value.getClass());
        }
    }

    private static /* synthetic */ void lambda$writeResponse$5(ByteBuf buf, Integer i) {
        ExtendedByteBuf.writeUnsignedInt(i, buf);
    }

    private static /* synthetic */ void lambda$writeResponse$4(ByteBuf buf, byte[] key) {
        buf.writeByte(1);
        ExtendedByteBuf.writeRangedBytes(key, buf);
    }

    private static /* synthetic */ void lambda$writeResponse$3(ByteBuf buf, String s) {
        ExtendedByteBuf.writeString(s, buf);
    }
}

