/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.infinispan.server.hotrod.counter.CounterDecodeContext;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.util.logging.LogFactory;

public class CounterAddDecodeContext
extends CounterDecodeContext {
    private static final Log log = (Log)LogFactory.getLog(CounterAddDecodeContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private long value;
    private boolean decodeDone = false;

    public long getValue() {
        return this.value;
    }

    @Override
    CounterDecodeContext.DecodeStep nextStep() {
        return this.decodeDone ? null : this::decodeValue;
    }

    @Override
    boolean trace() {
        return trace;
    }

    @Override
    Log log() {
        return log;
    }

    private boolean decodeValue(ByteBuf buffer) {
        Optional<Long> optValue = ExtendedByteBuf.readMaybeLong(buffer);
        optValue.ifPresent(value -> {
            this.value = value;
            this.logDecoded("value", value);
            this.decodeDone = true;
        });
        return !optValue.isPresent();
    }
}

