/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.Objects;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.xa.Xid;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.command.tx.ForwardCommitCommand;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.SecondPhaseTransactionDecodeContext;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.ByteString;

public class CommitTransactionDecodeContext
extends SecondPhaseTransactionDecodeContext {
    private static final Log log = (Log)LogFactory.getLog(CommitTransactionDecodeContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final boolean onePhaseCommit;

    public CommitTransactionDecodeContext(AdvancedCache<byte[], byte[]> cache, XidImpl xid) {
        super(cache, xid);
        this.onePhaseCommit = cache.getCacheConfiguration().transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    @Override
    final Log log() {
        return log;
    }

    @Override
    final boolean isTrace() {
        return trace;
    }

    @Override
    protected void performRemote() {
        try {
            if (this.onePhaseCommit) {
                this.onePhaseCommit();
            } else {
                this.secondPhaseCommit();
            }
        }
        catch (Throwable throwable) {
            throw Util.rewrapAsCacheException((Throwable)throwable);
        }
        finally {
            this.forgetTransaction();
        }
    }

    @Override
    protected void performLocal() throws HeuristicRollbackException, HeuristicMixedException, RollbackException {
        try {
            EmbeddedTransaction tx = Objects.requireNonNull(this.serverTransactionTable.getLocalTx((Xid)this.xid));
            if (this.txState.status() != 3) {
                this.updateState();
            }
            tx.runCommit(false);
        }
        finally {
            this.serverTransactionTable.removeGlobalStateAndLocalTx(this.xid);
        }
    }

    @Override
    protected CacheRpcCommand buildForwardCommand(ByteString cacheName) {
        return new ForwardCommitCommand(cacheName, XidImpl.copy((Xid)this.xid));
    }

    private void onePhaseCommit() throws Throwable {
        PrepareCommand command = this.commandsFactory.buildPrepareCommand(this.txState.getGlobalTransaction(), this.txState.getModifications(), true);
        this.updateState();
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true));
        this.commandsFactory.initializeReplicableCommand((ReplicableCommand)command, false);
        command.invokeAsync().join();
    }

    private void secondPhaseCommit() throws Throwable {
        CommitCommand command = this.commandsFactory.buildCommitCommand(this.txState.getGlobalTransaction());
        this.updateState();
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true));
        this.commandsFactory.initializeReplicableCommand((ReplicableCommand)command, false);
        command.invokeAsync().join();
    }

    private void updateState() {
        if (this.txState.status() != 3) {
            this.advance(this.txState.commit());
        }
    }
}

